/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search.algorithm;

import com.google.common.collect.Lists;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.TemplateMatchingUtilities;

public class TemplateMatcher {
    public static List<RegionMatch> findMatchesByGrayscaleAtOriginalResolution(BufferedImage input, BufferedImage target, int limit, double minScore) {
        opencv_core.IplImage input1 = ImagePreprocessor.createGrayscale(input);
        opencv_core.IplImage target1 = ImagePreprocessor.createGrayscale(target);
        opencv_core.IplImage resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(input1, target1);
        return TemplateMatcher.fetchMatches(resultMatrix, target1, limit, minScore);
    }

    public static List<RegionMatch> findMatchesByGrayscaleAtOriginalResolutionWithROIs(BufferedImage input, BufferedImage target, int limit, double minScore, List<Rectangle> rois) {
        opencv_core.IplImage input1 = ImagePreprocessor.createGrayscale(input);
        opencv_core.IplImage target1 = ImagePreprocessor.createGrayscale(target);
        opencv_core.IplImage resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrixWithMultipleROIs(input1, target1, rois);
        return TemplateMatcher.fetchMatches(resultMatrix, target1, limit, minScore);
    }

    private static List<RegionMatch> fetchMatches(opencv_core.IplImage resultMatrix, opencv_core.IplImage target, int limit, double minScore) {
        ArrayList matches = Lists.newArrayList();
        while (matches.size() < limit) {
            TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch(resultMatrix, target);
            RegionMatch m3 = new RegionMatch(result);
            m3.setScore(result.score);
            if (!(m3.getScore() >= minScore)) break;
            matches.add(m3);
        }
        return matches;
    }
}

