/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.updater.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class PathUtils {
    private static final String relativeSeparator = "/";
    private static final String windowSeparator = "\\";

    private PathUtils() {
    }

    public static String absoluteToRelativePath(String absolutePath, String projectFolderPath) {
        return PathUtils.getRelativePath(absolutePath, projectFolderPath);
    }

    public static String relativeToAbsolutePath(String relativePath, String projectFolderPath) {
        Path path = new File(relativePath).toPath();
        if (path.isAbsolute()) {
            return path.toAbsolutePath().toString();
        }
        Path projectPath = new File(projectFolderPath).toPath();
        return projectPath.resolve(path).normalize().toString();
    }

    private static String getRelativePath(String targetPath, String basePath) {
        String[] base = basePath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), -1);
        String[] target = targetPath.replace(windowSeparator, relativeSeparator).split(Pattern.quote(relativeSeparator), 0);
        Object common = "";
        int commonIndex = 0;
        for (int i = 0; i < target.length && i < base.length && target[i].equals(base[i]); ++i) {
            common = (String)common + target[i] + relativeSeparator;
            ++commonIndex;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        Object relative = "";
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex;
            for (int i = 1; i <= numDirsUp; ++i) {
                relative = (String)relative + "../";
            }
        }
        relative = (String)relative + targetPath.replace(windowSeparator, relativeSeparator).substring(((String)common).length());
        return relative;
    }
}

