/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.updater.utils;

import com.kms.katalon.updater.utils.LogUtils;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArchUtils;
import org.apache.commons.lang3.arch.Processor;

public class PlatformUtils {
    private static final Logger logger = LogUtils.getLogger();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String OS_MAC = "macosx";
    private static final String OS_WINDOWS = "win32";
    private static final String OS_LINUX = "linux";

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isWindows() {
        return OS.contains("windows");
    }

    public static boolean isLinux() {
        return OS.contains(OS_LINUX);
    }

    public static boolean is64Bit() {
        return PlatformUtils.getProcessorArch() == 64;
    }

    public static boolean is32Bit() {
        return PlatformUtils.getProcessorArch() == 32;
    }

    public static String getPlatform() {
        return String.format("%s-%s", PlatformUtils.getOSName(), PlatformUtils.getArch());
    }

    private static int getProcessorArch() {
        return ArchUtils.getProcessor().getArch() == Processor.Arch.BIT_64 ? 64 : 32;
    }

    public static String getArch() {
        return PlatformUtils.is64Bit() ? "x86_64" : "x86";
    }

    public static String getOSName() {
        if (PlatformUtils.isWindows()) {
            return OS_WINDOWS;
        }
        if (PlatformUtils.isLinux()) {
            return OS_LINUX;
        }
        return OS_MAC;
    }

    public static void forceCloseKatalon() {
        try {
            if (PlatformUtils.isWindows()) {
                new ProcessBuilder(new String[0]).command("TASKKILL", "/F", "/IM", "katalon.exe").start();
                return;
            }
            new ProcessBuilder(new String[0]).command("killall", "-KILL", "katalon").start();
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }
}

