/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.aws;

import com.kms.katalon.core.testobject.authorization.AwsSignatureAuthorization;
import com.kms.katalon.core.testobject.authorization.AwsSignatureLocation;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.core.webservice.exception.WebServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.BinaryUtils;

public class Authenticator {
    private static String AWS_CONTENT_HASH_HEADER_NAME = "x-amz-content-sha256";
    private Aws4Signer aws4Signer = Aws4Signer.create();

    public HttpUriRequest sign(HttpUriRequest request, RequestAuthorization authenticationSetting) throws IOException, GeneralSecurityException, WebServiceException {
        AwsSignatureAuthorization awsSetting = AwsSignatureAuthorization.adapt((RequestAuthorization)authenticationSetting);
        boolean signedQueryParam = awsSetting.getSignatureLocation() == AwsSignatureLocation.QUERY_STRING;
        SdkHttpFullRequest signedRequest = this.signInternal(request, awsSetting, signedQueryParam);
        HttpRequestWrapper outputSignedRequest = HttpRequestWrapper.wrap((HttpRequest)request);
        if (signedQueryParam) {
            outputSignedRequest.setURI(signedRequest.getUri());
        }
        signedRequest.headers().entrySet().stream().forEach(signedHeader -> {
            String key = (String)signedHeader.getKey();
            if (key.toLowerCase().equals("authorization") && !signedQueryParam) {
                outputSignedRequest.removeHeaders(key);
                outputSignedRequest.addHeader(key, String.join((CharSequence)",", (Iterable)signedHeader.getValue()));
            } else if (!outputSignedRequest.containsHeader(key)) {
                outputSignedRequest.addHeader(key, String.join((CharSequence)",", (Iterable)signedHeader.getValue()));
            }
        });
        return outputSignedRequest;
    }

    private SdkHttpFullRequest convertToAwsRequest(HttpUriRequest request, AwsSignatureAuthorization awsSetting) throws WebServiceException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)request.getMethod())).uri(request.getURI());
        boolean requestPayloadAvailable = false;
        Header[] headerArray = request.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header h = headerArray[n2];
            builder.appendHeader(h.getName(), h.getValue());
            ++n2;
        }
        if (request instanceof HttpEntityEnclosingRequest && Objects.nonNull(entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity())) {
            try {
                final InputStream is = this.convert(entity);
                builder.contentStreamProvider(new ContentStreamProvider(){

                    public InputStream newStream() {
                        return is;
                    }
                });
            }
            catch (IOException e) {
                throw new WebServiceException("Converting HttpUriRequest to SdkHttpFullRequest fails on copying request body from HttpUriRequest", e);
            }
            try {
                builder.appendHeader(AWS_CONTENT_HASH_HEADER_NAME, this.hash(Optional.of(entity)));
                requestPayloadAvailable = true;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new WebServiceException(String.format("Fails to hash the request body from HttpUriRequest for the header %s", AWS_CONTENT_HASH_HEADER_NAME), e);
            }
        }
        if (!requestPayloadAvailable) {
            try {
                builder.appendHeader(AWS_CONTENT_HASH_HEADER_NAME, this.hash(Optional.empty()));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new WebServiceException(String.format("Fails to create hash for the empty payload for the header %s", AWS_CONTENT_HASH_HEADER_NAME), e);
            }
        }
        return builder.build();
    }

    private SdkHttpFullRequest signInternal(HttpUriRequest request, AwsSignatureAuthorization awsSetting, boolean presign) throws IOException, GeneralSecurityException, WebServiceException {
        SdkHttpFullRequest awsRequest = this.convertToAwsRequest(request, awsSetting);
        AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)((String)awsSetting.getAwsAccessKey().get()), (String)((String)awsSetting.getAwsSecretKey().get()));
        if (awsSetting.getAwsSessionToken().isPresent()) {
            awsCredentials = AwsSessionCredentials.create((String)((String)awsSetting.getAwsAccessKey().get()), (String)((String)awsSetting.getAwsSecretKey().get()), (String)((String)awsSetting.getAwsSessionToken().get()));
        }
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)((String)awsSetting.getAwsServiceName().get())).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)Region.of((String)awsSetting.getAwsRegion())).putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)awsCredentials);
        return presign ? this.aws4Signer.presign(awsRequest, executionAttributes) : this.aws4Signer.sign(awsRequest, executionAttributes);
    }

    private InputStream convert(HttpEntity httpPayload) throws IOException {
        PipedInputStream pis = new PipedInputStream((int)httpPayload.getContentLength());
        Throwable throwable = null;
        Object var4_5 = null;
        try (PipedOutputStream pos = new PipedOutputStream(pis);){
            httpPayload.writeTo((OutputStream)pos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pis;
    }

    private String hash(Optional<HttpEntity> httpPayload) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] rawPayload = new byte[]{};
        if (httpPayload.isPresent()) {
            rawPayload = IOUtils.toByteArray((InputStream)this.convert(httpPayload.get()));
        }
        byte[] hashedBytes = digest.digest(rawPayload);
        return BinaryUtils.toHex((byte[])hashedBytes);
    }
}

