/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.util;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.ValidationDataType;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIUtil {
    public static boolean isValidOpenAPISpecification(String specSrc, ValidationDataType dataType, String projectLocation) {
        specSrc = OpenAPIUtil.getFullSpecLocation(dataType, specSrc, projectLocation);
        try {
            return OpenAPIUtil.isOpenAPIv2(specSrc) || OpenAPIUtil.isOpenAPIv3(specSrc);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFullSpecLocation(ValidationDataType type, String specSrc, String projectLocation) {
        File file;
        if (!(type != ValidationDataType.FILE && (type != null && type != ValidationDataType.AUTO || OpenAPIUtil.isUrl(specSrc)) || (file = new File(specSrc)).isAbsolute())) {
            specSrc = new File(projectLocation, specSrc).getAbsolutePath();
        }
        return specSrc;
    }

    private static boolean isOpenAPIv3(String specSrc) {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult swaggerParseResult = OpenAPIUtil.isUrlOrFile(specSrc) ? openAPIV3Parser.readLocation(specSrc, null, null) : openAPIV3Parser.readContents(specSrc, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        List messages = swaggerParseResult.getMessages();
        return openAPI != null && (messages == null || messages.isEmpty());
    }

    private static boolean isOpenAPIv2(String specSrc) {
        SwaggerConverter converter = new SwaggerConverter();
        SwaggerParseResult swaggerParseResult = OpenAPIUtil.isUrlOrFile(specSrc) ? converter.readLocation(specSrc, null, null) : converter.readContents(specSrc, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        List messages = swaggerParseResult.getMessages();
        return openAPI != null && (messages == null || messages.isEmpty());
    }

    private static OpenApiInteractionValidator getValidator(String specSrc) throws Exception {
        OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
        SwaggerParseResult swaggerParseResult = OpenAPIUtil.isUrlOrFile(specSrc) ? openAPIV3Parser.readLocation(specSrc, null, null) : openAPIV3Parser.readContents(specSrc, null, null);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        List messages = swaggerParseResult.getMessages();
        if (openAPI != null && (messages == null || messages.isEmpty())) {
            return OpenApiInteractionValidator.createFor((OpenAPI)openAPI).build();
        }
        SwaggerConverter swaggerConverter = new SwaggerConverter();
        swaggerParseResult = OpenAPIUtil.isUrlOrFile(specSrc) ? swaggerConverter.readLocation(specSrc, null, null) : swaggerConverter.readContents(specSrc, null, null);
        openAPI = swaggerParseResult.getOpenAPI();
        messages = swaggerParseResult.getMessages();
        if (openAPI != null && (messages == null || messages.isEmpty())) {
            return OpenApiInteractionValidator.createFor((OpenAPI)openAPI).build();
        }
        if (messages == null || messages.isEmpty()) {
            throw new Exception("Invalid OpenAPI specification");
        }
        throw new Exception("Invalid OpenAPI specification: " + (String)messages.get(0));
    }

    private static boolean isUrlOrFile(String specSrc) {
        return OpenAPIUtil.isUrl(specSrc) || OpenAPIUtil.isFile(specSrc);
    }

    public static boolean isUrl(String specSrc) {
        try {
            new URL(specSrc);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isFile(String specSrc) {
        try {
            return Files.exists(Paths.get(specSrc, new String[0]), new LinkOption[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ValidationReport validateRequest(RequestObject request, String specSrc) throws Exception {
        OpenApiInteractionValidator validator = OpenAPIUtil.getValidator(specSrc);
        return validator.validateRequest((Request)OpenAPIUtil.getRequestBuilder(request));
    }

    public static ValidationReport validateResponse(ResponseObject response, RequestObject request, String specSrc) throws Exception {
        Request.Method method = OpenAPIUtil.parseToRequestMethod(request.getHttpMethod());
        URI uri = new URI(request.getUrl());
        OpenApiInteractionValidator validator = OpenAPIUtil.getValidator(specSrc);
        return validator.validateResponse(uri.getPath(), method, (Response)OpenAPIUtil.getResponseBuilder(response));
    }

    private static Request.Method parseToRequestMethod(String method) {
        if (StringUtils.isBlank((CharSequence)method) || StringUtils.startsWithIgnoreCase((CharSequence)method, (CharSequence)"SOAP")) {
            return null;
        }
        return Request.Method.valueOf((String)method);
    }

    private static Properties extractQueries(String queryString) throws MalformedURLException {
        String[] elements;
        Properties props = new Properties();
        if (StringUtils.isNotBlank((CharSequence)queryString) && (elements = queryString.split("&")).length != 0) {
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String[] a = str.split("=");
                if (a.length != 1) {
                    props.setProperty(a[0], a[1]);
                } else {
                    props.setProperty(a[0], "");
                }
                ++n2;
            }
        }
        return props;
    }

    private static SimpleRequest getRequestBuilder(RequestObject request) throws MalformedURLException {
        URL url = new URL(request.getRestUrl());
        String path = url.getPath();
        SimpleRequest.Builder builder = OpenAPIUtil.createRequestBuilder(request, path);
        OpenAPIUtil.buildRequestQueryParams(url, builder);
        OpenAPIUtil.buildRequestHeaders(builder, request.getHttpHeaderProperties());
        OpenAPIUtil.buildRequestBody(builder, request);
        return builder.build();
    }

    private static void buildRequestBody(SimpleRequest.Builder requestBuilder, RequestObject request) {
        if (request.getBodyContent() != null) {
            requestBuilder.withBody(request.getHttpBody());
        }
    }

    private static SimpleRequest.Builder createRequestBuilder(RequestObject request, String path) {
        String requestMethod = request.getRestRequestMethod();
        if (StringUtils.isNotBlank((CharSequence)request.getSoapRequestMethod())) {
            requestMethod = request.getSoapRequestMethod();
        }
        Request.Method method = Enum.valueOf(Request.Method.class, requestMethod);
        return new SimpleRequest.Builder(method, path);
    }

    private static void buildRequestHeaders(SimpleRequest.Builder requestBuilder, List<TestObjectProperty> headers) {
        for (TestObjectProperty prop : headers) {
            if (!prop.isActive()) continue;
            requestBuilder.withHeader(prop.getName(), new String[]{prop.getValue()});
        }
    }

    private static void buildRequestQueryParams(URL url, SimpleRequest.Builder requestBuilder) throws MalformedURLException {
        Properties props = OpenAPIUtil.extractQueries(url.getQuery());
        Enumeration<Object> enuKeys = props.keys();
        while (enuKeys.hasMoreElements()) {
            String key = (String)enuKeys.nextElement();
            String value = props.getProperty(key);
            requestBuilder.withQueryParam(key, new String[]{value});
        }
    }

    private static SimpleResponse getResponseBuilder(ResponseObject response) throws IOException {
        SimpleResponse.Builder builder = SimpleResponse.Builder.status((int)response.getStatusCode()).withBody(response.getResponseText());
        return builder.build();
    }
}

