/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.component;

import com.katalon.capability.constant.DriverType;
import com.kms.katalon.composer.execution.components.DriverPreferenceComposite;
import com.kms.katalon.composer.execution.components.DriverPropertyMapComposite;
import com.kms.katalon.composer.mobile.component.DeviceSelectionComposite;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.driver.MobileDriverConnector;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MobileDriverPreferenceComposite
extends DriverPreferenceComposite {
    protected DeviceSelectionComposite deviceSelectionComposite;

    public MobileDriverPreferenceComposite(Composite parent, int style, MobileDriverConnector driverConnector) {
        super(parent, style, (IDriverConnector)driverConnector);
    }

    protected void createContents(IDriverConnector driverConnector) {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        Composite deviceSelectionCompositeContainer = new Composite((Composite)this, 0);
        deviceSelectionCompositeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        deviceSelectionCompositeContainer.setLayout((Layout)new GridLayout());
        MobileDriverType mobileDriverType = (MobileDriverType)driverConnector.getDriverType();
        DriverType driverType = switch (mobileDriverType) {
            case MobileDriverType.ANDROID_DRIVER -> DriverType.ANDROID_DRIVER;
            case MobileDriverType.IOS_DRIVER -> DriverType.IOS_DRIVER;
            default -> throw new IncompatibleClassChangeError();
        };
        this.deviceSelectionComposite = new DeviceSelectionComposite(deviceSelectionCompositeContainer, 0, driverType);
        this.driverPropertyMapComposite = new DriverPropertyMapComposite((Composite)this);
        this.deviceSelectionComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MobileDriverPreferenceComposite.this.deviceSelectionComposite != null) {
                    MobileDriverPreferenceComposite.this.updateDeviceToDriverConnector(MobileDriverPreferenceComposite.this.deviceSelectionComposite.getSelectedDevice());
                }
            }
        });
        this.deviceSelectionComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileDriverPreferenceComposite.this.updateDeviceToDriverConnector(MobileDriverPreferenceComposite.this.deviceSelectionComposite.getSelectedDevice());
            }
        });
        this.deviceSelectionComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MobileDriverPreferenceComposite.this.updateDeviceToDriverConnector(MobileDriverPreferenceComposite.this.deviceSelectionComposite.getSelectedDevice());
            }
        });
    }

    public void updateInputToDriverConnector() {
        if (this.driverConnector == null) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.driverPropertyMapComposite.getDriverProperties());
        String deviceId = ((MobileDriverConnector)this.driverConnector).getDefaultDeviceId();
        properties.put("deviceId", deviceId);
        this.driverConnector.setUserConfigProperties(properties);
    }

    public void updateInputToUI() {
        String deviceId = ((MobileDriverConnector)this.driverConnector).getDefaultDeviceId();
        this.deviceSelectionComposite.setDeviceId(deviceId);
        LinkedHashMap configProperties = new LinkedHashMap();
        configProperties.putAll(this.driverConnector.getUserConfigProperties());
        if (configProperties.containsKey("deviceId")) {
            configProperties.remove("deviceId");
        }
        this.driverPropertyMapComposite.setDriverProperties(configProperties);
    }

    public void setInput(Map<String, Object> driverProperties) {
        this.driverConnector.setUserConfigProperties(driverProperties);
        this.updateInputToUI();
    }

    private void updateDeviceToDriverConnector(MobileDeviceInfo deviceInfo) {
        if (this.driverConnector != null) {
            ((MobileDriverConnector)this.driverConnector).setDevice(deviceInfo);
            ((MobileDriverConnector)this.driverConnector).updateDefaultDeviceId();
        }
    }
}

