/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.strategies;

import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.entity.file.FileEntity;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Predicate;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class StringMatchPrecheckEntityLoadStrategy
implements IEntityLoadStrategy {
    private Predicate<String> predicate;

    public StringMatchPrecheckEntityLoadStrategy(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public FileEntity load(String filePath, Unmarshaller unmarshaller) throws Exception {
        String content = Files.readString(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        if (!this.predicate.test(content)) {
            return null;
        }
        FileEntity entity = (FileEntity)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(content)));
        return entity;
    }
}

