/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.common;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.driver.internal.DriverCleanerCollector;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;
import groovy.lang.Binding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class CommonExecutor {
    public void setStatusTestSuiteContext(InternalTestSuiteContext testSuiteContext) {
        String status = "COMPLETE";
        if (ErrorCollector.getCollector().containsErrors()) {
            status = "ERROR";
        }
        testSuiteContext.setStatus(status);
    }

    public void cleanDriver() {
        if (RunConfiguration.shouldTerminateDriverAfterTestSuite()) {
            DriverCleanerCollector.getInstance().cleanDrivers();
        }
    }

    public void accessTestCaseMainPhaseLoop(ScriptEngine scriptEngine, TestCaseBinding testCaseBinding) {
        HashMap values = testCaseBinding.getBindedValues() != null ? testCaseBinding.getBindedValues() : new HashMap();
        HashMap<String, Object> bindedValues = new HashMap<String, Object>();
        scriptEngine.changeConfigForCollectingVariable();
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                Object runScript = scriptEngine.runScriptWithoutLogging(value != null ? value.toString() : null, new Binding());
                bindedValues.put(key, runScript);
            }
            catch (Exception exception) {
                bindedValues.put(key, value);
            }
        }
        testCaseBinding.setBindedValues(bindedValues);
    }

    public TestResult accessTestCaseMainPhase(int index, TestCaseBinding tcBinding) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> coppiedErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();
        try {
            String bindedVal = tcBinding.getBindedValues() == null ? "" : tcBinding.getBindedValues().getOrDefault(tcBinding.getIterationVariableName(), "");
            String getIterationVariableValue = Objects.toString(bindedVal);
            InternalTestCaseContext testCaseContext = new InternalTestCaseContext(tcBinding.getTestCaseId(), index, tcBinding.getTestCaseName(), getIterationVariableValue);
            TestCaseExecutor testCaseExecutor = this.accessTestCaseMainPhaseBody(tcBinding, testCaseContext);
            TestResult testResult = testCaseExecutor.execute(FailureHandling.STOP_ON_FAILURE);
            return testResult;
        }
        finally {
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedErrors);
        }
    }

    public abstract TestCaseExecutor accessTestCaseMainPhaseBody(TestCaseBinding var1, InternalTestCaseContext var2);
}

