/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventEmitter {
    Map<String, List<CustomEventListener>> listenerMap = new ConcurrentHashMap<String, List<CustomEventListener>>();

    public <EventType extends Enum<EventType>> EventSubscriber on(EventType eventType, CustomEventListener listener) {
        return this.on(eventType.name(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSubscriber on(String eventName, CustomEventListener listener) {
        List<CustomEventListener> listeners;
        List<CustomEventListener> list = listeners = this.getListeners(eventName);
        synchronized (list) {
            listeners.add(listener);
        }
        return new EventSubscriber(this, eventName, listener);
    }

    public <EventType extends Enum<EventType>> void off(EventType eventType, CustomEventListener listener) {
        this.off(eventType.name(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void off(String eventType, CustomEventListener listener) {
        List<CustomEventListener> listeners;
        List<CustomEventListener> list = listeners = this.getListeners(eventType);
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    private synchronized List<CustomEventListener> getListeners(String type) {
        return this.listenerMap.computeIfAbsent(type, k -> new ArrayList());
    }

    public <EventType extends CustomEvent> void emit(EventType event) {
        this.emit(event.type, event);
    }

    public <EventType extends Enum<EventType>> void emit(EventType eventType, Object event) {
        this.emit(eventType.name(), event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(String eventType, Object event) {
        List<CustomEventListener> listeners;
        List<CustomEventListener> list = listeners = this.getListeners(eventType);
        synchronized (list) {
            listeners.forEach(listener -> listener.call(event));
        }
    }

    public static void safeUnsubscribe(EventSubscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        subscriber.unsubscribe();
    }

    public static class CustomEvent {
        public String type;
        public Object data;
    }

    public static interface CustomEventListener<EventType> {
        public void call(EventType var1);
    }

    public static class EventSubscriber {
        private WeakReference<EventEmitter> emitterRef;
        private String eventName;
        private CustomEventListener listener;

        public EventSubscriber(EventEmitter emitter, String eventName, CustomEventListener listener) {
            this.emitterRef = new WeakReference<EventEmitter>(emitter);
            this.eventName = eventName;
            this.listener = listener;
        }

        public void unsubscribe() {
            EventEmitter emitter = (EventEmitter)this.emitterRef.get();
            if (emitter == null) {
                return;
            }
            emitter.off(this.eventName, this.listener);
        }
    }
}

