/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenrecorder;

import atu.testrecorder.media.MovieWriter;
import atu.testrecorder.media.avi.AVIWriter;
import atu.testrecorder.media.color.Colors;
import atu.testrecorder.media.quicktime.QuickTimeWriter;
import com.kms.katalon.core.helper.screenrecorder.AbstractVideoRecorder;
import com.kms.katalon.core.helper.screenrecorder.VideoConfiguration;
import com.kms.katalon.core.helper.screenrecorder.VideoCursor;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoRecorderException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class ATUVideoRecorder
extends AbstractVideoRecorder {
    private MovieWriter movieWriter;
    private Robot robot;
    private Rectangle screenBounds;
    private BufferedImage screenCapture;
    private List<MouseCapture> mouseCaptures;
    private BufferedImage videoImg;
    private Graphics2D videoGraphics;
    private ScheduledThreadPoolExecutor screenTimer;
    private long tempStartTime;
    private Runnable screenTimerCommand;
    private ScheduledThreadPoolExecutor mouseTimer;
    private Runnable mouseTimerCommand;
    private final Object sync = new Object();
    private String outputDirLocation;
    private String outputVideoName;
    private File videoFile;
    private File videoTempFile;

    public ATUVideoRecorder(String outputDirLocation, String outputVideoName) throws VideoRecorderException {
        this.videoConfig = new VideoConfiguration();
        this.outputDirLocation = outputDirLocation;
        this.outputVideoName = outputVideoName;
        this.recorder(outputDirLocation, outputVideoName);
    }

    public ATUVideoRecorder(String outputDirLocation, String outputVideoName, VideoConfiguration videoConfig) throws VideoRecorderException {
        this.videoConfig = videoConfig;
        this.outputDirLocation = outputDirLocation;
        this.outputVideoName = outputVideoName;
        this.recorder(outputDirLocation, outputVideoName);
    }

    @Override
    public void reload() throws VideoRecorderException {
        this.recorder(this.outputDirLocation, this.outputVideoName);
        this.started = false;
    }

    private void recorder(String outputDirLocation, String outputVideoName) throws VideoRecorderException {
        try {
            Window window = new Window(null);
            GraphicsConfiguration cfg = window.getGraphicsConfiguration();
            this.screenBounds = cfg.getBounds();
            this.robot = new Robot(cfg.getDevice());
            this.mouseCaptures = Collections.synchronizedList(new LinkedList());
            this.videoImg = this.getVideoImage(this.videoConfig);
            this.videoGraphics = this.videoImg.createGraphics();
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.videoGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.screenTimerCommand = new Runnable(){

                @Override
                public void run() {
                    try {
                        ATUVideoRecorder.this.grabScreen();
                    }
                    catch (VideoRecorderException videoRecorderException) {}
                }
            };
            this.mouseTimerCommand = new Runnable(){

                @Override
                public void run() {
                    ATUVideoRecorder.this.grabMouse();
                }
            };
            this.createMovieWriter(outputDirLocation, outputVideoName);
        }
        catch (VideoRecorderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VideoRecorderException(e);
        }
    }

    private BufferedImage getVideoImage(VideoConfiguration videoConfig) throws VideoRecorderException {
        int depth = videoConfig.getDepth();
        int screenWidth = this.screenBounds.width;
        int screenHeight = this.screenBounds.height;
        if (depth == 24) {
            return new BufferedImage(screenWidth, screenHeight, 1);
        }
        if (depth == 16) {
            return new BufferedImage(screenWidth, screenHeight, 9);
        }
        if (depth == 8) {
            return new BufferedImage(screenWidth, screenHeight, 13, Colors.createMacColors());
        }
        throw new VideoRecorderException("Unsupported color depth " + depth);
    }

    protected void createMovieWriter(String outputDirLocation, String outputVideoName) throws VideoRecorderException, IOException {
        File videoFile = this.getVideoFile(outputDirLocation, outputVideoName);
        int videoDepth = this.videoConfig.getDepth();
        int videoWidth = this.screenBounds.width;
        int videoHeight = this.screenBounds.height;
        VideoFileFormat videoFormat = this.videoConfig.getVideoFormat();
        if (videoFormat == VideoFileFormat.AVI) {
            AVIWriter aviWriter = new AVIWriter(videoFile);
            aviWriter.addVideoTrack(AVIWriter.VIDEO_SCREEN_CAPTURE, 1L, this.videoConfig.getMouseRate(), videoWidth, videoHeight, videoDepth, this.videoConfig.getAviSyncInterval());
            if (videoDepth == 8) {
                aviWriter.setPalette(0, (IndexColorModel)this.videoImg.getColorModel());
            }
            this.movieWriter = aviWriter;
            return;
        }
        if (videoFormat == VideoFileFormat.MOV) {
            QuickTimeWriter movWriter = new QuickTimeWriter(videoFile);
            movWriter.addVideoTrack(QuickTimeWriter.VIDEO_ANIMATION, 1000L, videoWidth, videoHeight, videoDepth, this.videoConfig.getQuicktimeSyncInterval());
            this.movieWriter = movWriter;
            return;
        }
        throw new VideoRecorderException("Unsupported video format " + String.valueOf((Object)videoFormat));
    }

    private File getVideoFile(String outputDirLocation, String outputVideoName) throws IOException {
        File outputDir;
        if (outputDirLocation == null || outputDirLocation.trim().isEmpty()) {
            outputDirLocation = VIDEO_TEMP_LOCATION;
        }
        if (outputVideoName == null || ((String)outputVideoName).trim().isEmpty()) {
            outputVideoName = "" + System.currentTimeMillis();
        }
        if (!(outputDir = new File(outputDirLocation + File.separator)).exists()) {
            outputDir.mkdirs();
        } else if (!outputDir.isDirectory()) {
            throw new IOException("\"" + outputDirLocation + "\" is not a directory.");
        }
        String fileLocationWithoutExt = outputDirLocation + File.separator + (String)outputVideoName;
        this.currentVideoLocation = fileLocationWithoutExt + ".tmp";
        this.videoTempFile = new File(this.currentVideoLocation);
        this.currentVideoLocation = fileLocationWithoutExt + this.videoConfig.getVideoFormat().getExtension();
        this.videoFile = new File(this.currentVideoLocation);
        return this.videoTempFile;
    }

    @Override
    public void start() throws VideoRecorderException {
        this.startTime = System.currentTimeMillis();
        this.tempStartTime = System.currentTimeMillis();
        this.interrupted = true;
        this.screenTimer = this.createTimerExecutor(this.videoConfig.getScreenRate(), this.screenTimerCommand);
        this.mouseTimer = this.createTimerExecutor(this.videoConfig.getMouseRate(), this.mouseTimerCommand);
        this.started = true;
    }

    private ScheduledThreadPoolExecutor createTimerExecutor(long rate, Runnable command) {
        long initialDelay = 1000L / rate;
        long period = 1000L / rate;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.MILLISECONDS);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws VideoRecorderException {
        try {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new VideoRecorderException(e.getMessage());
            }
            this.mouseTimer.shutdown();
            this.screenTimer.shutdown();
            try {
                this.mouseTimer.awaitTermination(1000L / this.videoConfig.getMouseRate(), TimeUnit.MILLISECONDS);
                this.screenTimer.awaitTermination(1000L / this.videoConfig.getScreenRate(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new VideoRecorderException(e.getMessage());
            }
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.movieWriter.close();
                }
                catch (IOException e) {
                    throw new VideoRecorderException(e.getMessage());
                }
                this.movieWriter = null;
            }
            this.videoGraphics.dispose();
            this.videoImg.flush();
            this.interrupted = false;
        }
        finally {
            this.started = false;
            if (this.interrupted) {
                this.videoTempFile.delete();
                return;
            }
            this.videoTempFile.renameTo(this.videoFile);
            this.videoTempFile.delete();
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public String getCurrentVideoLocation() {
        return this.currentVideoLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabScreen() throws VideoRecorderException {
        this.screenCapture = this.robot.createScreenCapture(new Rectangle(0, 0, this.screenBounds.width, this.screenBounds.height));
        long now = System.currentTimeMillis();
        this.videoGraphics.drawImage((Image)this.screenCapture, 0, 0, null);
        boolean hasMouseCapture = false;
        Point cursorOffset = this.videoConfig.getCursorOffset();
        BufferedImage cursorImage = this.videoConfig.getCursorImage();
        if (this.videoConfig.getCursor() != VideoCursor.NONE) {
            Point prevMouseLoc = new Point(0, 0);
            while (!this.mouseCaptures.isEmpty() && this.mouseCaptures.get((int)0).time < now) {
                MouseCapture mc = this.mouseCaptures.remove(0);
                long mcTime = mc.time;
                if (mcTime <= this.tempStartTime) continue;
                hasMouseCapture = true;
                Point mcLocation = mc.location;
                mcLocation.translate(-this.screenBounds.x, -this.screenBounds.y);
                Object object = this.sync;
                synchronized (object) {
                    if (this.movieWriter.isVFRSupported() && mcLocation.equals(prevMouseLoc) && mcTime - this.tempStartTime <= this.videoConfig.getMaxFrameDuration()) {
                        return;
                    }
                    prevMouseLoc.setLocation(mcLocation);
                    int startDestRectX = mcLocation.x + cursorOffset.x;
                    int startDestRectY = mcLocation.y + cursorOffset.y;
                    this.videoGraphics.drawImage((Image)cursorImage, startDestRectX, startDestRectY, null);
                    if (this.movieWriter == null) {
                        return;
                    }
                    try {
                        this.movieWriter.writeFrame(0, this.videoImg, mcTime - this.tempStartTime);
                    }
                    catch (IOException e) {
                        throw new VideoRecorderException(e);
                    }
                    this.tempStartTime = mcTime;
                    int endDestRectX = startDestRectX + cursorImage.getWidth() - 1;
                    int endDestRectY = startDestRectY + cursorImage.getHeight() - 1;
                    int startSrcRectX = startDestRectX;
                    int startSrcRectY = startDestRectY;
                    int endSrcRectX = endDestRectX;
                    int endSrcRectY = endDestRectY;
                    this.videoGraphics.drawImage(this.screenCapture, startDestRectX, startDestRectY, endDestRectX, endDestRectY, startSrcRectX, startSrcRectY, endSrcRectX, endSrcRectY, null);
                }
            }
        }
        if (hasMouseCapture) {
            return;
        }
        if (this.videoConfig.getCursor() != VideoCursor.NONE) {
            Point mouseLoc = MouseInfo.getPointerInfo().getLocation();
            this.videoGraphics.drawImage((Image)cursorImage, mouseLoc.x + cursorOffset.x, mouseLoc.x + cursorOffset.y, null);
        }
        Object object = this.sync;
        synchronized (object) {
            try {
                this.movieWriter.writeFrame(0, this.videoImg, now - this.tempStartTime);
            }
            catch (IOException e) {
                throw new VideoRecorderException(e);
            }
        }
        this.tempStartTime = now;
    }

    private void grabMouse() {
        this.mouseCaptures.add(new MouseCapture(System.currentTimeMillis(), MouseInfo.getPointerInfo().getLocation()));
    }

    @Override
    public void delete() {
        if (this.videoFile != null && this.videoFile.exists()) {
            FileUtils.deleteQuietly((File)this.videoFile);
        }
    }

    private static class MouseCapture {
        public long time;
        public Point location;

        public MouseCapture(long time, Point location) {
            this.time = time;
            this.location = location;
        }
    }
}

