/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenshot;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.helper.screenshot.ScreenCaptureException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ScreenCaptor {
    protected static final String SCREENSHOT_EXT = "png";
    protected final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    public final Map<String, String> takeScreenshotAndGetAttributes(boolean takeScreenShot) {
        if (!takeScreenShot || !this.isScreenCaptureEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            File newScreenshot = this.getNewFile(this.logger.getLogFolderPath());
            this.take(newScreenshot);
            attributes.put("attachment", newScreenshot.getName());
        }
        catch (ScreenCaptureException e) {
            this.logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_WARNING_CANNOT_TAKE_SCREENSHOT, ExceptionsUtil.getMessageForThrowable(e)), null, e);
        }
        return attributes;
    }

    public final void takeScreenshot() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            File newScreenshot = this.getNewFile(this.logger.getLogFolderPath());
            this.take(newScreenshot);
            attributes.put("attachment", newScreenshot.getName());
        }
        catch (ScreenCaptureException e) {
            this.logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_WARNING_CANNOT_TAKE_SCREENSHOT, ExceptionsUtil.getMessageForThrowable(e)), null, e);
        }
        this.logger.logInfo("take screenshot successully", attributes);
    }

    protected abstract void take(File var1) throws ScreenCaptureException;

    private String newFileName() {
        return System.currentTimeMillis() + ".png";
    }

    private File getNewFile(String parentFolder) {
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            newFile = new File(parentFolder, this.newFileName());
        }
        return newFile;
    }

    private final boolean isScreenCaptureEnabled() {
        Boolean screenCaptureOption = (Boolean)((Map)RunConfiguration.getExecutionGeneralProperties().get("report")).get("screenCaptureOption");
        return screenCaptureOption;
    }
}

