/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.ObjectUtil;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class TestCaseGroupLogRecord
extends TestCaseLogRecord {
    private int indexInReport = -1;
    private TestSuiteLogRecord testSuiteLogRecord;

    public TestCaseGroupLogRecord(TestSuiteLogRecord testSuiteLogRecord, ILogRecord firstRecord, int index) {
        super(firstRecord.getName());
        this.testSuiteLogRecord = testSuiteLogRecord;
        this.setType("TEST_CASE");
        if (firstRecord != null) {
            ObjectUtil.clone(firstRecord, this);
            this.setChildRecords(new ILogRecord[0]);
            this.addChildRecord(firstRecord);
            this.setParentLogRecord(null);
            if (firstRecord instanceof AbstractLogRecord) {
                AbstractLogRecord firstAbstractLogRecord = (AbstractLogRecord)firstRecord;
                super.setProperties(firstAbstractLogRecord.getProperties());
            }
        }
        this.setIndexInReport(index);
    }

    @Override
    public ILogRecord[] getChildRecords() {
        return this.childRecords.stream().filter(logRecord -> logRecord instanceof TestCaseLogRecord).map(logRecord -> {
            logRecord.setDescription(StringEscapeUtils.unescapeJava((String)logRecord.getDescription()));
            return logRecord;
        }).collect(Collectors.toList()).toArray(new ILogRecord[0]);
    }

    @Override
    public long getStartTime() {
        return !this.childRecords.isEmpty() ? this.getLastLogRecord().getStartTime() : 0L;
    }

    @Override
    public long getEndTime() {
        return !this.childRecords.isEmpty() ? this.getLastLogRecord().getEndTime() : 0L;
    }

    @Override
    public TestStatus getStatus() {
        return !this.childRecords.isEmpty() ? this.getLastLogRecord().getStatus() : null;
    }

    public TestCaseLogRecord getLastLogRecord() {
        return (TestCaseLogRecord)this.childRecords.get(this.childRecords.size() - 1);
    }

    @Override
    public Map<String, String> getProperties() {
        return !this.childRecords.isEmpty() ? this.getLastLogRecord().getProperties() : null;
    }

    public int getIndexInReport() {
        return this.indexInReport;
    }

    public void setIndexInReport(int indexInReport) {
        this.indexInReport = indexInReport;
    }

    @Override
    public int hashCode() {
        return this.indexInReport;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestCaseGroupLogRecord)) {
            return false;
        }
        TestCaseGroupLogRecord other = (TestCaseGroupLogRecord)obj;
        return this.indexInReport == other.indexInReport;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord() {
        return this.testSuiteLogRecord;
    }

    public void setTestSuiteLogRecord(TestSuiteLogRecord testSuiteLogRecord) {
        this.testSuiteLogRecord = testSuiteLogRecord;
    }
}

