/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.AbstractLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class TestCaseLogRecord
extends AbstractLogRecord {
    private boolean isOptional;
    private String tag;
    private String iterationVariableValue;
    private String origin;

    public TestCaseLogRecord(String name) {
        super(name);
        this.setType("TEST_CASE");
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getIterationVariableValue() {
        return this.iterationVariableValue;
    }

    public void setIterationVariableValue(String iterationVariableValue) {
        this.iterationVariableValue = iterationVariableValue;
    }

    public boolean isRetryTestCase() {
        return LogRecordHelper.getRetyCount(this) > 0;
    }

    @Override
    public ILogRecord[] getChildRecords() {
        ArrayList<ILogRecord> resultRecords = new ArrayList<ILogRecord>();
        for (ILogRecord logRecord : this.childRecords) {
            if (!(logRecord instanceof TestStepLogRecord)) continue;
            logRecord.setDescription(StringEscapeUtils.unescapeJava((String)logRecord.getDescription()));
            resultRecords.add(logRecord);
        }
        return resultRecords.toArray(new ILogRecord[resultRecords.size()]);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.isOptional, this.tag);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TestCaseLogRecord)) {
            return false;
        }
        if (LogRecordHelper.getRetyCount(this) != LogRecordHelper.getRetyCount((TestCaseLogRecord)obj)) {
            return false;
        }
        TestCaseLogRecord other = (TestCaseLogRecord)obj;
        return this.isOptional == other.isOptional && Objects.equals(this.tag, other.tag);
    }

    public String getTestCaseNameWithIteration() {
        if (StringUtils.isNotEmpty((CharSequence)this.iterationVariableValue)) {
            return this.getName() + " | " + this.iterationVariableValue;
        }
        return this.getName();
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
}

