/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.XMLParserException;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ExportReportProvider;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.reporting.pdf.TestSuitePdfGenerator;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.setting.ReportBundleSettingStore;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;

public class KatalonExportReportProvider
implements ExportReportProvider {
    private static final KeywordLogger logger = KeywordLogger.getInstance(KatalonExportReportProvider.class);

    @Override
    public String[] getSupportedTypeForTestSuite() {
        return new String[]{"HTML", "CSV (Summary)", "CSV (Details)", "PDF"};
    }

    @Override
    public String[] getSupportedTypeForTestSuiteCollection() {
        return new String[]{"HTML"};
    }

    @Override
    public File exportTestSuite(File exportLocation, String projectDir, String reportId, String formatType) throws IOException, URISyntaxException, XMLParserException, XMLStreamException {
        ReportSettings settings = ReportBundleSettingStore.getStore(projectDir).getSettings();
        File reportFolder = new File(projectDir, reportId);
        TestSuiteLogRecord testSuiteLogRecord = ReportWriterUtil.parseTestSuiteLog(reportFolder.getAbsolutePath());
        switch (formatType) {
            case "HTML": {
                ReportWriterUtil.writeHTMLReport(((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)ReportWriterUtil.SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(testSuiteLogRecord).settings(settings)).reportDir(reportFolder)).outputFile(exportLocation)).build());
                return exportLocation;
            }
            case "CSV (Summary)": {
                ReportWriterUtil.writeLogRecordToCSVFile(testSuiteLogRecord, exportLocation, Arrays.asList(testSuiteLogRecord.filterFinalTestCasesResult()), false);
                return exportLocation;
            }
            case "CSV (Details)": {
                ReportWriterUtil.writeLogRecordToCSVFile(testSuiteLogRecord, exportLocation, Arrays.asList(testSuiteLogRecord.filterFinalTestCasesResult()), true);
                return exportLocation;
            }
            case "PDF": {
                TestSuitePdfGenerator pdfGenerator = new TestSuitePdfGenerator(testSuiteLogRecord);
                try {
                    pdfGenerator.exportToPDF(exportLocation.getAbsolutePath());
                }
                catch (JasperReportException e) {
                    logger.logWarning(ExceptionsUtil.getStackTraceForThrowable(e));
                    throw new IOException(e);
                }
                return exportLocation;
            }
        }
        return null;
    }

    @Override
    public File exportTestSuiteCollection(File exportLocation, String projectDirLocation, String reportLocation, String formatType, TestSuiteCollectionLogRecord tscLogRecord) throws IOException, URISyntaxException, XMLParserException, XMLStreamException, DocumentException {
        switch (formatType) {
            case "HTML": {
                ReportSettings settings = ReportBundleSettingStore.getStore(projectDirLocation).getSettings();
                File testSuiteCollectionFile = new File(exportLocation, "index.html");
                ReportWriterUtil.writeCollectionHTMLReport(((ReportWriterUtil.CollectionReportGenerationOptionsBuilder)((ReportWriterUtil.CollectionReportGenerationOptionsBuilder)((ReportWriterUtil.CollectionReportGenerationOptionsBuilder)((ReportWriterUtil.CollectionReportGenerationOptionsBuilder)((ReportWriterUtil.CollectionReportGenerationOptionsBuilder)ReportWriterUtil.CollectionReportGenerationOptionsBuilder.create().collectionLogRecord(tscLogRecord).settings(settings)).projectDir(new File(projectDirLocation))).reportDir(new File(reportLocation))).outputDir(exportLocation)).outputFile(testSuiteCollectionFile)).build());
                return testSuiteCollectionFile;
            }
        }
        return null;
    }
}

