/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.kms.katalon.core.logging.TestSuiteXMLLogParser;
import com.kms.katalon.core.logging.XMLParserException;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.html.JsSuiteModel;
import com.kms.katalon.core.reporting.html.ResourceLoader;
import com.kms.katalon.core.reporting.newreport.NewHTMLReportDataWriter;
import com.kms.katalon.core.reporting.newreport.NewReportModelMapper;
import com.kms.katalon.core.reporting.pdf.TestSuitePdfGenerator;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.reporting.util.ResourceUtil;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ReportWriterUtil {
    public static final String COLLECTION_INFO_FILE_NAME = "collection.json";
    private static final String FAILED_STATUS_BACKGROUND_COLOR = "#f19696";
    private static final String INCOMPLETE_STATUS_BACKGROUND_COLOR = "#f2bc70";
    private static final String DEFAULT_COMPOSITE_BACKGROUND_COLOR = "#f0f0f0";

    private static void appendReportConstantValuesWithWriter(List<String> constantValues, Writer writer) throws IOException {
        int size = constantValues.size();
        int i = 0;
        while (i < size) {
            writer.write(constantValues.get(i));
            if (i < size - 1) {
                writer.write(",");
            }
            ++i;
        }
    }

    private static void generateVarsWithWriter(List<String> strings, TestSuiteLogRecord suiteLogEntity, StringBuilder model, Writer writer) throws IOException {
        List lines = IOUtils.readLines((InputStream)ResourceUtil.getResourceAsInputStream(ResourceLoader.class, "resources/html/html_vars.txt"));
        for (String line : lines) {
            if (line.equals("//JavaScript Suite model for Reporting")) {
                writer.write(model.toString());
                continue;
            }
            if (line.equals("//JavaScript Strings constant for Reporting")) {
                ReportWriterUtil.appendReportConstantValuesWithWriter(strings, writer);
                continue;
            }
            if (line.equals("//JavaScript Test Execution Environment Info")) {
                StringBuilder envInfoSb = new StringBuilder();
                envInfoSb.append("{");
                envInfoSb.append(String.format("\"host\" : \"%s\", ", suiteLogEntity.getHostName()));
                envInfoSb.append(String.format("\"os\" : \"%s\", ", suiteLogEntity.getOs()));
                envInfoSb.append(String.format("\"katalonVersion\" : \"%s\", ", suiteLogEntity.getAppVersion()));
                String mobileDeviceName = suiteLogEntity.getMobileDeviceName();
                envInfoSb.append(String.format("\"deviceName\" : \"%s\", ", mobileDeviceName));
                String browserName = suiteLogEntity.getBrowser();
                envInfoSb.append(String.format("\"browserName\" : \"%s\", ", browserName));
                envInfoSb.append("\"\" : \"\"");
                envInfoSb.append("}");
                writer.write(envInfoSb.toString());
                continue;
            }
            writer.write(line);
            writer.write("\n");
        }
    }

    public static String getOs() {
        return System.getProperty("os.name") + " " + System.getProperty("sun.arch.data.model") + "bit";
    }

    public static String getHostName() {
        String hostName = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases) throws IOException {
        ReportWriterUtil.writeLogRecordToCSVFile(suiteLogEntity, destFile, filteredTestCases, true);
    }

    public static void writeLogRecordToCSVFile(TestSuiteLogRecord suiteLogEntity, File destFile, List<ILogRecord> filteredTestCases, boolean stepsIncluded) throws IOException {
        CsvWriter.writeCsvReport(suiteLogEntity, destFile, filteredTestCases, stepsIncluded);
    }

    public static File writePdfReport(TestSuiteLogRecord suiteLogEntity, File logFolder) throws JasperReportException, IOException {
        List<TestCaseLogRecord> testCases = suiteLogEntity.getAllTestCaseLogRecords();
        ArrayList<String> originalTestCaseNames = new ArrayList<String>();
        for (TestCaseLogRecord testCase : testCases) {
            originalTestCaseNames.add(testCase.getName());
            testCase.setName(testCase.getTestCaseNameWithIteration());
        }
        TestSuitePdfGenerator pdfGenerator = new TestSuitePdfGenerator(suiteLogEntity);
        File exportLocation = new File(logFolder, logFolder.getName() + ".pdf");
        pdfGenerator.exportToPDF(exportLocation.getAbsolutePath());
        int i = 0;
        while (i < originalTestCaseNames.size()) {
            testCases.get(i).setName((String)originalTestCaseNames.get(i));
            ++i;
        }
        return exportLocation;
    }

    public static void writeCollectionHTMLReport(CollectionReportGenerationOptions options) throws IOException, URISyntaxException, XMLParserException, XMLStreamException, DocumentException {
        if (options.getSettings().applyNewReport) {
            ReportWriterUtil.writeNewCollectionHTMLReport(options);
        } else {
            ReportWriterUtil.writeOldCollectionHTMLReport(options);
        }
    }

    private static void writeNewCollectionHTMLReport(CollectionReportGenerationOptions options) throws IOException, URISyntaxException, XMLParserException, XMLStreamException, DocumentException {
        TestSuiteCollectionLogRecord collectionLogRecord = options.getCollectionLogRecord();
        File outputFile = options.getOutputFile();
        ReportSettings settings = options.getSettings();
        File collectionReportFolder = options.getReportDir();
        File projectFolder = options.getProjectDir();
        if (collectionLogRecord == null) {
            collectionLogRecord = ReportWriterUtil.collectCollectionLogRecord(collectionReportFolder, projectFolder);
        }
        String template = ReportWriterUtil.readFileToStringBuilder("resources/html/TestSuiteCollectionTemplate.html");
        String[] parts = template.split("<!-- EXECUTION_DATA_PLACEHOLDER -->");
        String header = parts[0];
        String footer = parts[1];
        List<TestSuiteLogRecord> suiteLogRecords = collectionLogRecord.getTestSuiteRecords();
        if (suiteLogRecords == null) {
            suiteLogRecords = ReportWriterUtil.collectCollectionSuites(collectionReportFolder, projectFolder);
            collectionLogRecord.setTestSuiteRecords(suiteLogRecords);
        }
        for (TestSuiteLogRecord testSuite : suiteLogRecords) {
            ArrayList<ILogRecord> newChildRecords = new ArrayList<ILogRecord>();
            newChildRecords.addAll(testSuite.getBeforeTestSuiteLogRecords());
            newChildRecords.addAll(Arrays.asList(testSuite.getFinalTestCases()));
            newChildRecords.addAll(testSuite.getAfterTestSuiteLogRecords());
            testSuite.setChildRecords(newChildRecords.toArray(new ILogRecord[0]));
        }
        TestSuiteCollectionLogRecord finalCollectionLogRecord = collectionLogRecord;
        ReportWriterUtil.writeReport(outputFile, writer -> writer.write(header), writer -> {
            NewHTMLReportDataWriter newHTMLWriter = new NewHTMLReportDataWriter(writer, outputFile.getParentFile(), false);
            new NewReportModelMapper(settings, collectionReportFolder).toTestExecutionParts(finalCollectionLogRecord, (part, partKey) -> newHTMLWriter.writePart(part, partKey));
        }, writer -> writer.write(footer));
    }

    private static List<TestSuiteLogRecord> collectCollectionSuites(File collectionReportFolder, File projectFolder) throws XMLParserException, IOException, XMLStreamException, DocumentException {
        ArrayList<TestSuiteLogRecord> suiteLogRecords = new ArrayList<TestSuiteLogRecord>();
        List<String> testSuiteReportIds = ReportWriterUtil.collectCollectionSuiteIds(collectionReportFolder);
        for (String reportRelativeLocation : testSuiteReportIds) {
            File suiteReportDir = new File(projectFolder, reportRelativeLocation);
            TestSuiteLogRecord testSuiteLogRecord = ReportWriterUtil.parseCollectionSuiteLog(suiteReportDir.getAbsolutePath());
            suiteLogRecords.add(testSuiteLogRecord);
        }
        return suiteLogRecords;
    }

    private static void writeOldCollectionHTMLReport(CollectionReportGenerationOptions options) throws IOException, URISyntaxException, DocumentException {
        List<Map<String, String>> tsInfoItems = ReportWriterUtil.writeOldCollectionSuiteHTMLReport(options);
        String rawTsReports = JsonUtil.toJson(tsInfoItems, false);
        File colelctionIndexFile = options.getOutputFile();
        File reportDir = options.getReportDir();
        ReportWriterUtil.writeOldCollectionHTMLIndexFile(reportDir, colelctionIndexFile, rawTsReports);
    }

    private static void writeOldCollectionHTMLIndexFile(File reportDir, File colelctionIndexFile, String rawTsReports) throws IOException, URISyntaxException {
        String reportTitle = reportDir.getName();
        File destDir = colelctionIndexFile.getParentFile();
        String template = ReportWriterUtil.readFileToStringBuilder("resources/html/html_collection_index_template.txt");
        template = StringUtils.replace((String)template, (String)"REPORT_TITLE", (String)reportTitle);
        template = StringUtils.replace((String)template, (String)"TEST_SUITE_REPORT_LIST", (String)rawTsReports);
        FileUtils.writeStringToFile((File)colelctionIndexFile, (String)template, (String)"UTF-8");
        template = ReportWriterUtil.readFileToStringBuilder("resources/html/html_collection_frame_template.txt");
        template = StringUtils.replace((String)template, (String)"REPORT_TITLE", (String)reportTitle);
        template = StringUtils.replace((String)template, (String)"TEST_SUITE_REPORT_LIST", (String)rawTsReports);
        FileUtils.writeStringToFile((File)new File(destDir, "index-frame-view.html"), (String)template, (String)"UTF-8");
    }

    private static List<String> collectCollectionSuiteIds(File reportDir) throws DocumentException {
        File reportEntityFile = new File(reportDir, reportDir.getName() + ".rp");
        SAXReader reader = new SAXReader();
        Document document = reader.read(reportEntityFile);
        Element rootElement = document.getRootElement();
        ArrayList<String> testSuiteReportIds = new ArrayList<String>();
        List reportItemDescriptionItems = rootElement.element("reportItemDescriptions").elements("ReportItemDescription");
        reportItemDescriptionItems.stream().forEach(e -> testSuiteReportIds.add(e.elementText("reportLocation")));
        return testSuiteReportIds;
    }

    private static List<Map<String, String>> writeOldCollectionSuiteHTMLReport(CollectionReportGenerationOptions options) throws DocumentException, IOException, URISyntaxException {
        File reportDir = options.getReportDir();
        File exportLocation = options.getOutputDir();
        File outputFile = options.getOutputFile();
        ReportSettings settings = options.getSettings();
        File projectDir = options.getProjectDir();
        List<String> testSuiteReportIds = ReportWriterUtil.collectCollectionSuiteIds(reportDir);
        ArrayList<Map<String, String>> tsInfoItems = new ArrayList<Map<String, String>>();
        for (String reportRelativeLocation : testSuiteReportIds) {
            try {
                File suiteReportDir = new File(projectDir, reportRelativeLocation);
                TestSuiteLogRecord testSuiteLogRecord = ReportWriterUtil.parseCollectionSuiteLog(suiteReportDir.getAbsolutePath());
                String htmlFileName = new File(reportRelativeLocation).getName() + ".html";
                File suiteOutputFile = new File(exportLocation, htmlFileName);
                String testSuiteCollectionId = StringUtils.defaultString((String)testSuiteLogRecord.getTestSuiteCollectionId());
                String testSuiteCollectionName = new File(testSuiteCollectionId).getName();
                testSuiteLogRecord.setTestSuiteCollectionName(testSuiteCollectionName);
                testSuiteLogRecord.setTestSuiteCollectionPath(exportLocation.toPath().relativize(outputFile.toPath()).toString());
                ReportWriterUtil.writeHTMLReport(((SuiteReportGenerationOptionsBuilder)((SuiteReportGenerationOptionsBuilder)((SuiteReportGenerationOptionsBuilder)SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(testSuiteLogRecord).settings(settings)).reportDir(reportDir)).outputFile(suiteOutputFile)).build());
                HashMap<String, Object> tsInfoItem = new HashMap<String, Object>();
                tsInfoItem.put("report_location", reportRelativeLocation);
                tsInfoItem.put("report", htmlFileName);
                tsInfoItem.put("id", ReportWriterUtil.getTestSuiteId(reportRelativeLocation));
                tsInfoItem.put("environment", testSuiteLogRecord.getBrowser());
                String status = ReportWriterUtil.getStatus(testSuiteLogRecord);
                tsInfoItem.put("status", status);
                tsInfoItem.put("fail_on_total", ReportWriterUtil.getFailOnTotal(testSuiteLogRecord));
                tsInfoItem.put("status_color", ReportWriterUtil.getStatusColor(status));
                tsInfoItem.put("fail_color", ReportWriterUtil.getFailColor(testSuiteLogRecord));
                tsInfoItems.add(tsInfoItem);
            }
            catch (XMLParserException | XMLStreamException e) {
                throw new IOException(e);
            }
        }
        return tsInfoItems;
    }

    public static void writeHTMLReport(SuiteReportGenerationOptions options) throws IOException, URISyntaxException {
        if (options.getSettings().applyNewReport) {
            ReportWriterUtil.writeNewTestSuiteHTMLReport(options);
        } else {
            ReportWriterUtil.writeOldTestSuiteHTMLReport(options);
        }
    }

    private static void writeOldTestSuiteHTMLReport(SuiteReportGenerationOptions options) throws IOException, URISyntaxException {
        TestSuiteLogRecord testSuiteLogRecord = options.suiteLogRecord;
        List<ILogRecord> filteredTestCases = options.filteredTestCases;
        File outputFile = options.getOutputFile();
        ArrayList<String> strings = new ArrayList<String>();
        JsSuiteModel jsSuiteModel = filteredTestCases != null ? new JsSuiteModel(testSuiteLogRecord, strings, filteredTestCases) : new JsSuiteModel(testSuiteLogRecord, strings);
        StringBuilder sbModel = jsSuiteModel.toArrayString();
        ReportWriterUtil.writeReport(outputFile, writer -> writer.write(ReportWriterUtil.readFileToStringBuilder("resources/html/html_template.txt")), writer -> ReportWriterUtil.generateVarsWithWriter(strings, testSuiteLogRecord, sbModel, writer), writer -> writer.write(ReportWriterUtil.readFileToStringBuilder("resources/html/html_content.txt")));
    }

    private static void writeNewTestSuiteHTMLReport(SuiteReportGenerationOptions options) throws IOException, URISyntaxException {
        String newHTMLTemplate = ReportWriterUtil.readFileToStringBuilder("resources/html/TestSuiteTemplate.html");
        String[] parts = newHTMLTemplate.split("<!-- EXECUTION_DATA_PLACEHOLDER -->");
        String header = parts[0];
        String footer = parts[1];
        TestSuiteLogRecord testSuiteLogRecord = options.getSuiteLogRecord();
        List<ILogRecord> filteredTestCases = options.getFilteredTestCases();
        List<ILogRecord> finalTestCases = filteredTestCases != null ? filteredTestCases : Arrays.asList(testSuiteLogRecord.getFinalTestCases());
        TestSuiteLogRecord testSuiteLogRecordClone = new TestSuiteLogRecord("", "");
        ObjectUtil.clone(testSuiteLogRecord, testSuiteLogRecordClone);
        ArrayList<ILogRecord> newChildRecords = new ArrayList<ILogRecord>();
        newChildRecords.addAll(testSuiteLogRecordClone.getBeforeTestSuiteLogRecords());
        newChildRecords.addAll(finalTestCases);
        newChildRecords.addAll(testSuiteLogRecordClone.getAfterTestSuiteLogRecords());
        testSuiteLogRecordClone.setChildRecords(newChildRecords.toArray(new ILogRecord[0]));
        File reportDir = options.getReportDir();
        File outputFile = options.getOutputFile();
        ReportSettings settings = options.getSettings();
        ReportWriterUtil.writeReport(outputFile, writer -> writer.write(header), writer -> {
            NewHTMLReportDataWriter newHTMLWriter = new NewHTMLReportDataWriter(writer, outputFile.getParentFile(), reportSettings.useSplitReportData);
            new NewReportModelMapper(settings, reportDir).toTestExecutionParts(testSuiteLogRecordClone, (part, partKey) -> newHTMLWriter.writePart(part, partKey));
        }, writer -> writer.write(footer));
    }

    private static void writeReport(File destFile, ReportWritingPhase ... phases) throws IOException, URISyntaxException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream outputStream = new FileOutputStream(destFile);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
                ReportWritingPhase[] reportWritingPhaseArray = phases;
                int n = phases.length;
                int n2 = 0;
                while (n2 < n) {
                    ReportWritingPhase phase = reportWritingPhaseArray[n2];
                    phase.write(writer);
                    ++n2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static File writeCSVReport(TestSuiteLogRecord suiteLogEntity, File folder) throws IOException {
        File file = new File(folder, folder.getName() + ".csv");
        if (!file.exists()) {
            CsvWriter.writeCsvReport(suiteLogEntity, file, Arrays.asList(suiteLogEntity.filterFinalTestCasesResult()));
        }
        return file;
    }

    public static TestSuiteLogRecord parseTestSuiteLog(String logFolder, IProgressMonitor progressMonitor) throws XMLParserException, IOException, XMLStreamException {
        return new TestSuiteXMLLogParser().readTestSuiteLogFromXMLFiles(logFolder, progressMonitor);
    }

    public static TestSuiteLogRecord parseTestSuiteLog(String logFolder) throws XMLParserException, IOException, XMLStreamException {
        return ReportWriterUtil.parseTestSuiteLog(logFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public static TestSuiteLogRecord parseCollectionSuiteLog(String logFolder, IProgressMonitor progressMonitor) throws XMLParserException, IOException, XMLStreamException {
        TestSuiteLogRecord suiteLogRecord = ReportWriterUtil.parseTestSuiteLog(logFolder, progressMonitor);
        String testSuiteCollectionId = ReportWriterUtil.getTestSuiteCollectionId(new File(logFolder));
        if (StringUtils.isNotBlank((String)testSuiteCollectionId) && suiteLogRecord != null) {
            suiteLogRecord.setTestSuiteCollectionId(testSuiteCollectionId);
        }
        return suiteLogRecord;
    }

    public static TestSuiteLogRecord parseCollectionSuiteLog(String logFolder) throws XMLParserException, IOException, XMLStreamException {
        return ReportWriterUtil.parseCollectionSuiteLog(logFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    private static String getTestSuiteCollectionId(File logFolder) throws IOException {
        File idFile = ReportWriterUtil.getOrCreateTestSuiteCollectionIdFile(logFolder);
        return FileUtils.readFileToString((File)idFile, (String)"UTF-8");
    }

    public static void writeTestSuiteCollectionIdToFile(String testSuiteCollectionId, File logFolder) throws IOException {
        File idFile = ReportWriterUtil.getOrCreateTestSuiteCollectionIdFile(logFolder);
        FileUtils.writeStringToFile((File)idFile, (String)testSuiteCollectionId, (String)"UTF-8");
    }

    private static File getOrCreateTestSuiteCollectionIdFile(File logFolder) throws IOException {
        File idFile = new File(logFolder, "tsc_id.txt");
        if (!idFile.exists()) {
            idFile.createNewFile();
        }
        return idFile;
    }

    private static String readFileToStringBuilder(String filePath) throws IOException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        String path = ResourceLoader.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        File jarFile = new File(path = URLDecoder.decode(path, "utf-8"));
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.endsWith(filePath)) continue;
                StringBuilderWriter sbWriter = new StringBuilderWriter(new StringBuilder());
                IOUtils.copy((InputStream)jar.getInputStream(jarEntry), (Writer)sbWriter);
                sbWriter.flush();
                sbWriter.close();
                sb.append((CharSequence)sbWriter.getBuilder());
                break;
            }
            jar.close();
        } else {
            FileInputStream is = new FileInputStream(new File(jarFile, filePath).getAbsolutePath());
            sb.append(IOUtils.toString((InputStream)is, (String)"UTF-8"));
        }
        return sb.toString();
    }

    public static void saveCollectionLogRecord(TestSuiteCollectionLogRecord collectionLogRecord, File reportFolder) throws IOException {
        List<TestSuiteLogRecord> suiteLogRecords = collectionLogRecord.getTestSuiteRecords();
        collectionLogRecord.setTestSuiteRecords(null);
        FileUtils.writeStringToFile((File)ReportWriterUtil.getCollectionInfoFile(reportFolder), (String)JsonUtil.toJson(collectionLogRecord), (String)"UTF-8");
        collectionLogRecord.setTestSuiteRecords(suiteLogRecords);
    }

    public static TestSuiteCollectionLogRecord collectCollectionLogRecord(File reportFolder, File projectFolder) throws IOException, DocumentException, XMLParserException, XMLStreamException {
        TestSuiteCollectionLogRecord collection;
        File tscInfoFile = ReportWriterUtil.getCollectionInfoFile(reportFolder);
        if (tscInfoFile.exists()) {
            String rawCollectionInfo = FileUtils.readFileToString((File)tscInfoFile, (String)"UTF-8");
            collection = JsonUtil.fromJson(rawCollectionInfo, TestSuiteCollectionLogRecord.class);
        } else {
            collection = ReportWriterUtil.parseCollectionLogRecordFromRPFile(reportFolder);
        }
        if (collection != null) {
            collection.setTestSuiteRecords(ReportWriterUtil.collectCollectionSuites(reportFolder, projectFolder));
            List<TestSuiteLogRecord> suites = collection.getTestSuiteRecords();
            if (suites != null && suites.size() > 0) {
                if (collection.getStartTime() == 0L) {
                    collection.setStartTime(suites.get(0).getStartTime());
                }
                if (collection.getEndTime() == 0L) {
                    collection.setEndTime(suites.get(suites.size() - 1).getEndTime());
                }
            }
        }
        return collection;
    }

    private static TestSuiteCollectionLogRecord parseCollectionLogRecordFromRPFile(File reportFolder) throws DocumentException {
        File reportEntityFile = new File(reportFolder, reportFolder.getName() + ".rp");
        SAXReader reader = new SAXReader();
        Document document = reader.read(reportEntityFile);
        Element rootElement = document.getRootElement();
        TestSuiteCollectionLogRecord tscLogRecord = new TestSuiteCollectionLogRecord();
        String collectionId = rootElement.elementText("testSuiteCollectionId");
        tscLogRecord.setDescription(rootElement.elementText("description"));
        tscLogRecord.setName(new File(collectionId).getName());
        tscLogRecord.setReportFolder(reportFolder.getAbsolutePath());
        tscLogRecord.setId(collectionId);
        return tscLogRecord;
    }

    public static File getCollectionInfoFile(File reportFolder) {
        return new File(reportFolder, COLLECTION_INFO_FILE_NAME);
    }

    private static int getTotalFailedTestCases(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return 0;
        }
        return testSuiteLogRecord.getTotalFailedTestCases() + testSuiteLogRecord.getTotalErrorTestCases();
    }

    private static String getFailOnTotal(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return "";
        }
        return ReportWriterUtil.getTotalFailedTestCases(testSuiteLogRecord) + " / " + testSuiteLogRecord.getTotalTestCases();
    }

    private static String getFailColor(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return "";
        }
        if (ReportWriterUtil.getTotalFailedTestCases(testSuiteLogRecord) > 0) {
            return FAILED_STATUS_BACKGROUND_COLOR;
        }
        return "";
    }

    private static String getTestSuiteId(String reportRelativeLocation) {
        String testSuiteId = reportRelativeLocation.replaceFirst("Reports", "Test Suites");
        testSuiteId = StringUtils.substringBeforeLast((String)testSuiteId, (String)"/");
        return testSuiteId;
    }

    private static String getStatus(TestSuiteLogRecord logRecord) {
        if (logRecord == null) {
            return "NOT_STARTED";
        }
        if (logRecord.getTotalIncompleteTestCases() > 0) {
            return "INCOMPLETE";
        }
        return "COMPLETE";
    }

    private static String getStatusColor(String status) {
        if (StringUtils.equals((String)status, (String)"NOT_STARTED")) {
            return DEFAULT_COMPOSITE_BACKGROUND_COLOR;
        }
        if (StringUtils.equals((String)status, (String)"INCOMPLETE")) {
            return INCOMPLETE_STATUS_BACKGROUND_COLOR;
        }
        return "";
    }

    public static abstract class BaseReportGenerationOptions {
        private ReportSettings settings;
        private File projectDir;
        private File reportDir;
        private File outputFile;
        private File outputDir;

        public ReportSettings getSettings() {
            return this.settings;
        }

        public void setSettings(ReportSettings settings) {
            this.settings = settings;
        }

        public File getProjectDir() {
            return this.projectDir;
        }

        public void setProjectDir(File projectDir) {
            this.projectDir = projectDir;
        }

        public File getReportDir() {
            return this.reportDir;
        }

        public void setReportDir(File reportDir) {
            this.reportDir = reportDir;
        }

        public File getOutputFile() {
            if (this.outputFile != null) {
                return this.outputFile;
            }
            File outputDir = this.getOutputDir();
            return outputDir != null ? new File(outputDir, outputDir.getName() + ".html") : null;
        }

        public void setOutputFile(File outputFile) {
            this.outputFile = outputFile;
        }

        public File getOutputDir() {
            return this.outputDir != null ? this.outputDir : this.getReportDir();
        }

        public void setOutputDir(File outputDir) {
            this.outputDir = outputDir;
        }
    }

    public static abstract class BaseReportGenerationOptionsBuilder<ReportOptionsType extends BaseReportGenerationOptions, BuilderType extends BaseReportGenerationOptionsBuilder<ReportOptionsType, BuilderType>> {
        private ReportSettings settings;
        private File projectDir;
        private File reportDir;
        private File outputFile;
        private File outputDir;

        private BuilderType _this() {
            return (BuilderType)this;
        }

        public BuilderType projectDir(File projectDir) {
            this.projectDir = projectDir;
            return this._this();
        }

        public BuilderType settings(ReportSettings settings) {
            this.settings = settings;
            return this._this();
        }

        public BuilderType reportDir(File reportDir) {
            this.reportDir = reportDir;
            return this._this();
        }

        public BuilderType outputFile(File outputFile) {
            this.outputFile = outputFile;
            return this._this();
        }

        public BuilderType outputDir(File outputDir) {
            this.outputDir = outputDir;
            return this._this();
        }

        protected abstract ReportOptionsType createOptions();

        public ReportOptionsType build() {
            ReportOptionsType options = this.createOptions();
            ((BaseReportGenerationOptions)options).setSettings(this.settings);
            ((BaseReportGenerationOptions)options).setProjectDir(this.projectDir);
            ((BaseReportGenerationOptions)options).setReportDir(this.reportDir);
            ((BaseReportGenerationOptions)options).setOutputFile(this.outputFile);
            ((BaseReportGenerationOptions)options).setOutputDir(this.outputDir);
            return options;
        }
    }

    public static class CollectionReportGenerationOptions
    extends BaseReportGenerationOptions {
        private TestSuiteCollectionLogRecord collectionLogRecord;

        public TestSuiteCollectionLogRecord getCollectionLogRecord() {
            return this.collectionLogRecord;
        }

        public void setCollectionLogRecord(TestSuiteCollectionLogRecord collectionLogRecord) {
            this.collectionLogRecord = collectionLogRecord;
        }
    }

    public static class CollectionReportGenerationOptionsBuilder
    extends BaseReportGenerationOptionsBuilder<CollectionReportGenerationOptions, CollectionReportGenerationOptionsBuilder> {
        private TestSuiteCollectionLogRecord collectionLogRecord;

        public CollectionReportGenerationOptionsBuilder collectionLogRecord(TestSuiteCollectionLogRecord collectionLogRecord) {
            this.collectionLogRecord = collectionLogRecord;
            return this;
        }

        public static CollectionReportGenerationOptionsBuilder create() {
            return new CollectionReportGenerationOptionsBuilder();
        }

        @Override
        protected CollectionReportGenerationOptions createOptions() {
            return new CollectionReportGenerationOptions();
        }

        @Override
        public CollectionReportGenerationOptions build() {
            CollectionReportGenerationOptions options = (CollectionReportGenerationOptions)super.build();
            options.setCollectionLogRecord(this.collectionLogRecord);
            return options;
        }
    }

    private static interface ReportWritingPhase {
        public void write(Writer var1) throws IOException, URISyntaxException;
    }

    public static class SuiteReportGenerationOptions
    extends BaseReportGenerationOptions {
        private TestSuiteLogRecord suiteLogRecord;
        private List<ILogRecord> filteredTestCases;

        public TestSuiteLogRecord getSuiteLogRecord() {
            return this.suiteLogRecord;
        }

        public void setSuiteLogRecord(TestSuiteLogRecord suiteLogRecord) {
            this.suiteLogRecord = suiteLogRecord;
        }

        public List<ILogRecord> getFilteredTestCases() {
            return this.filteredTestCases;
        }

        public void setFilteredTestCases(List<ILogRecord> filteredTestCases) {
            this.filteredTestCases = filteredTestCases;
        }
    }

    public static class SuiteReportGenerationOptionsBuilder
    extends BaseReportGenerationOptionsBuilder<SuiteReportGenerationOptions, SuiteReportGenerationOptionsBuilder> {
        private TestSuiteLogRecord suiteLogRecord;
        private List<ILogRecord> filteredTestCases;

        public SuiteReportGenerationOptionsBuilder suiteLogRecord(TestSuiteLogRecord suiteLogRecord) {
            this.suiteLogRecord = suiteLogRecord;
            return this;
        }

        public SuiteReportGenerationOptionsBuilder filteredTestCases(List<ILogRecord> filteredTestCases) {
            this.filteredTestCases = filteredTestCases;
            return this;
        }

        public static SuiteReportGenerationOptionsBuilder create() {
            return new SuiteReportGenerationOptionsBuilder();
        }

        @Override
        protected SuiteReportGenerationOptions createOptions() {
            return new SuiteReportGenerationOptions();
        }

        @Override
        public SuiteReportGenerationOptions build() {
            SuiteReportGenerationOptions options = (SuiteReportGenerationOptions)super.build();
            options.setSuiteLogRecord(this.suiteLogRecord);
            options.setFilteredTestCases(this.filteredTestCases);
            return options;
        }
    }
}

