/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.selenium.remote.http;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.ProxyUtil;
import java.io.IOException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.jdk.JdkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredHttpClientFactory
implements HttpClient.Factory {
    private static Logger logger = LoggerFactory.getLogger(ConfiguredHttpClientFactory.class);
    private static final String JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES = "jdk.http.auth.tunneling.disabledSchemes";
    private JdkHttpClient.Factory factory = new JdkHttpClient.Factory();
    private Proxy proxy;
    private String proxyUsername;
    private String proxyPassword;
    private Capabilities capabilities;

    public static ConfiguredHttpClientFactory of(ProxyInformation proxyInfo, URL url, Capabilities capabilities) throws URISyntaxException, IOException {
        if (proxyInfo != null) {
            if (proxyInfo.getProxyOption().equals(ProxyOption.MANUAL_CONFIG.name())) {
                return new ConfiguredHttpClientFactory(ProxyUtil.getProxy(proxyInfo, url), proxyInfo.getUsername(), proxyInfo.getPassword(), capabilities);
            }
            return new ConfiguredHttpClientFactory(ProxyUtil.getProxy(proxyInfo, url), capabilities);
        }
        return new ConfiguredHttpClientFactory(null, capabilities);
    }

    public ConfiguredHttpClientFactory(Proxy proxy, Capabilities capabilities) {
        this(proxy, null, null, capabilities);
    }

    public ConfiguredHttpClientFactory(Proxy proxy, String proxyUsername, String proxyPassword, Capabilities capabilities) {
        this.proxy = proxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.capabilities = capabilities;
    }

    public HttpClient createClient(ClientConfig config) {
        if (this.proxy == null) {
            return this.factory.createClient(config);
        }
        ClientConfig proxyInstance = config.proxy(this.proxy);
        Object value = this.capabilities.getCapability("acceptInsecureCerts");
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            try {
                SSLContext sslContext = this.createTrustAllSSLContext();
                proxyInstance = proxyInstance.sslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.error("Failed to bypass SSL validation", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyUsername) && StringUtils.isNotBlank((CharSequence)this.proxyPassword)) {
            String disabledSchemesValue = System.getProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES);
            System.setProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES, "");
            HttpClient client = this.factory.createClient(proxyInstance);
            if (disabledSchemesValue != null) {
                System.setProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES, disabledSchemesValue);
            } else {
                System.clearProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES);
            }
            return client;
        }
        return this.factory.createClient(proxyInstance);
    }

    public void cleanupIdleClients() {
        this.factory.cleanupIdleClients();
    }

    private SSLContext createTrustAllSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext;
    }
}

