/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testcase;

import com.kms.katalon.core.execution.TestExecutionStringUtil;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class BrokenTestCaseSummary {
    private String tc;
    private String to;
    private String rc;
    private String em;
    private String pathTomhtml;

    public BrokenTestCaseSummary(String testCase, String testObject, String rootCause, String errorMessage) {
        this.tc = testCase;
        this.to = testObject;
        this.rc = rootCause;
        this.em = errorMessage;
    }

    public String getTestCase() {
        return this.tc;
    }

    public String getTestObject() {
        return this.to;
    }

    public String getRootCause() {
        return this.rc;
    }

    public String getErrorMessage() {
        return this.em;
    }

    private static String getRawString(String str) {
        return str.replace("'", "");
    }

    public void setMhtml(String pathToMhtml) {
        this.pathTomhtml = pathToMhtml;
    }

    public String getMhtml() {
        return this.pathTomhtml;
    }

    public void searchAndSetMhtmlFile(String logFolder) {
        File f = new File(logFolder);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(Constants.MHTML_EXTENSION);
            }
        });
        if (matchingFiles != null && matchingFiles.length > 0) {
            this.setMhtml(matchingFiles[0].getAbsolutePath());
        }
    }

    public void searchAndSetMhtmlFile(String logFolder, final String testCaseId) {
        File f = new File(logFolder);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (TestExecutionStringUtil.getUnoffensiveTestCaseName(testCaseId) + "." + Constants.MHTML_EXTENSION).equals(name);
            }
        });
        if (matchingFiles.length > 0) {
            this.setMhtml(matchingFiles[0].getAbsolutePath());
        }
    }

    public static class Builder {
        public static BrokenTestCaseSummary buildFrom(ILogRecord element) {
            TestCaseLogRecord tcLogRecord;
            Optional<TestStepLogRecord> optWebElementNotFoundTestStep;
            if (element instanceof TestCaseLogRecord && (optWebElementNotFoundTestStep = Arrays.asList((tcLogRecord = (TestCaseLogRecord)element).getChildRecords()).stream().filter(a -> a instanceof TestStepLogRecord).map(a -> (TestStepLogRecord)a).filter(a -> !a.getStatus().equals((Object)TestStatus.TestStatusValue.PASSED)).filter(a -> !StringUtils.isEmpty((String)a.getMessage()) && a.getMessage().contains("com.kms.katalon.core.webui.exception")).findFirst()).isPresent()) {
                TestStepLogRecord webElementNotFoundTestStep = optWebElementNotFoundTestStep.get();
                String testObject = BrokenTestCaseSummary.getRawString(Utils.extractFirstTestObject(webElementNotFoundTestStep.getMessage()));
                String testCase = BrokenTestCaseSummary.getRawString(tcLogRecord.getName());
                String rootCause = BrokenTestCaseSummary.getRawString(Utils.getCausedBySentence(webElementNotFoundTestStep.getMessage()));
                String errorMessage = BrokenTestCaseSummary.getRawString(webElementNotFoundTestStep.getMessage());
                return new BrokenTestCaseSummary(testCase, testObject, rootCause, errorMessage);
            }
            return null;
        }

        public static BrokenTestCaseSummary buildFrom(XmlLogRecord result, String testCaseId) {
            String tcId = BrokenTestCaseSummary.getRawString(testCaseId);
            String testObject = BrokenTestCaseSummary.getRawString(Utils.extractFirstTestObject(result.getMessage()));
            String rootCause = BrokenTestCaseSummary.getRawString(Utils.getCausedBySentence(result.getMessage()));
            String errorMessage = result.getMessage();
            BrokenTestCaseSummary brokenTestCaseSummary = new BrokenTestCaseSummary(tcId, testObject, rootCause, errorMessage);
            return brokenTestCaseSummary;
        }
    }

    public static class Constants {
        public static String WEB_ELEMENT_NOT_FOUND_EXCEPTION = "WebElementNotFoundException";
        public static String MHTML_EXTENSION = "mhtml";
    }

    public static class Utils {
        public static String getCausedBySentence(String msg) {
            String causedBy = "";
            try {
                causedBy = msg.substring(msg.indexOf("Caused by:"));
                causedBy = causedBy.substring(0, causedBy.indexOf("\n"));
            }
            catch (Exception exception) {
                return "";
            }
            return causedBy;
        }

        public static String extractFirstTestObject(String msg) {
            String testObject = "";
            try {
                testObject = msg.substring(msg.indexOf("'Object Repository"));
                testObject = testObject.substring(0, testObject.indexOf("'", 1) + 1);
            }
            catch (Exception exception) {
                return "";
            }
            return testObject;
        }

        public static String getFolderWithLatestTimeStamp(String logFolder) throws IOException {
            return Files.list(Paths.get(logFolder, new String[0])).filter(f -> Files.isDirectory(f, new LinkOption[0])).max(Comparator.comparingLong(f -> f.toFile().lastModified())).map(f -> f.toFile().getAbsolutePath()).orElse("");
        }
    }
}

