/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

import com.kms.katalon.core.testobject.authorization.AwsSignatureLocation;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AwsSignatureAuthorization
extends BasicRequestAuthorization {
    private static final long serialVersionUID = 1L;
    private static final String ADD_AUTH_DATA_TO = "aws_add_auth_data_to";
    private static final String ACCESS_KEY = "aws_access_key";
    private static final String SECRET_KEY = "aws_secret_key";
    private static final String REGION = "aws_region";
    private static final String SERVICE_NAME = "aws_service_name";
    private static final String SESSION_TOKEN = "aws_session_token";
    public static final String AUTHORIZATION_TYPE_NAME = "AWS Signature";

    public AwsSignatureAuthorization(AwsSignatureLocation signatureLocation, String awsAccessKey, String awsSecretKey, String awsRegion, String awsServiceName, String awsSessionToken) throws UnsupportedEncodingException, GeneralSecurityException {
        HashMap<String, String> authorizationInfo = new HashMap<String, String>();
        authorizationInfo.put(ADD_AUTH_DATA_TO, Objects.isNull((Object)signatureLocation) ? AwsSignatureLocation.REQUEST_HEADER.name() : signatureLocation.name());
        if (StringUtils.isNotBlank((CharSequence)awsAccessKey)) {
            authorizationInfo.put(ACCESS_KEY, awsAccessKey);
        }
        if (StringUtils.isNotBlank((CharSequence)awsSecretKey)) {
            authorizationInfo.put(SECRET_KEY, this.encrypt(awsSecretKey));
        }
        if (StringUtils.isNotBlank((CharSequence)awsRegion)) {
            authorizationInfo.put(REGION, StringUtils.isBlank((CharSequence)awsRegion) ? "us-east-1" : awsRegion);
        }
        if (StringUtils.isNotBlank((CharSequence)awsServiceName)) {
            authorizationInfo.put(SERVICE_NAME, awsServiceName);
        }
        if (StringUtils.isNotBlank((CharSequence)awsSessionToken)) {
            authorizationInfo.put(SESSION_TOKEN, awsSessionToken);
        }
        this.init(authorizationInfo);
    }

    private AwsSignatureAuthorization(Map<String, String> properties) {
        this.init(properties);
    }

    private AwsSignatureAuthorization(RequestAuthorization requestAuthorization) {
        this(requestAuthorization.getAuthorizationInfo());
    }

    public static boolean is(RequestAuthorization requestAuthorization) {
        String at;
        if (Objects.nonNull(requestAuthorization) && StringUtils.isNotBlank((CharSequence)(at = requestAuthorization.getAuthorizationType()))) {
            return at.equals(AUTHORIZATION_TYPE_NAME);
        }
        return false;
    }

    public static AwsSignatureAuthorization adapt(RequestAuthorization requestAuthorization) {
        if (!AwsSignatureAuthorization.is(requestAuthorization)) {
            throw new IllegalArgumentException("The RequestAuthorization parameter isn't the type of AwsSignatureAuthorization");
        }
        return new AwsSignatureAuthorization(requestAuthorization);
    }

    public static AwsSignatureAuthorization adapt(Map<String, String> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("The Map<String, String> parameter is required but null");
        }
        return new AwsSignatureAuthorization(properties);
    }

    public Optional<String> getAwsSecretKey() throws GeneralSecurityException, IOException {
        Optional<String> encryptedKey = this.get(SECRET_KEY);
        if (encryptedKey.isEmpty()) {
            return Optional.empty();
        }
        String vl = encryptedKey.get();
        if (StringUtils.isBlank((CharSequence)vl)) {
            return Optional.empty();
        }
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)vl);
        return Optional.of(CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo));
    }

    public Optional<String> getAwsAccessKey() {
        return this.get(ACCESS_KEY);
    }

    public String getAwsRegion() {
        return this.get(REGION).orElse("us-east-1");
    }

    public Optional<String> getAwsServiceName() {
        return this.get(SERVICE_NAME);
    }

    public Optional<String> getAwsSessionToken() {
        return this.get(SESSION_TOKEN);
    }

    public AwsSignatureLocation getSignatureLocation() {
        Map<String, String> dict = this.getAuthorizationInfo();
        if (dict.containsKey(ADD_AUTH_DATA_TO)) {
            return AwsSignatureLocation.valueOf(dict.get(ADD_AUTH_DATA_TO));
        }
        return AwsSignatureLocation.REQUEST_HEADER;
    }

    public void validate() {
        if (this.getAwsAccessKey().isEmpty()) {
            throw new IllegalArgumentException("AWS Access Key is missing");
        }
        if (this.get(SECRET_KEY).isEmpty()) {
            throw new IllegalArgumentException("AWS Secret Key is missing");
        }
        if (this.getAwsServiceName().isEmpty()) {
            throw new IllegalArgumentException("AWS Service Name is missing");
        }
    }

    private Optional<String> get(String key) {
        Map<String, String> dict = this.getAuthorizationInfo();
        if (dict.containsKey(key)) {
            return Optional.of(dict.get(key));
        }
        return Optional.empty();
    }

    private void init(Map<String, String> authInfo) {
        this.setAuthorizationType(AUTHORIZATION_TYPE_NAME);
        this.setAuthorizationInfo(authInfo);
    }

    private String encrypt(String vl) throws UnsupportedEncodingException, GeneralSecurityException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)(StringUtils.isBlank((CharSequence)vl) ? "" : vl));
        return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
    }
}

