/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

public enum OAuth1SignatureMethod {
    HMAC_SHA1("HMAC-SHA1"),
    RSA_SHA1("RSA-SHA1");

    private final String displayName;

    private OAuth1SignatureMethod(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static OAuth1SignatureMethod fromDisplayName(String displayName) {
        OAuth1SignatureMethod[] oAuth1SignatureMethodArray = OAuth1SignatureMethod.values();
        int n = oAuth1SignatureMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            OAuth1SignatureMethod method = oAuth1SignatureMethodArray[n2];
            if (method.getDisplayName().equals(displayName)) {
                return method;
            }
            ++n2;
        }
        try {
            return OAuth1SignatureMethod.valueOf(displayName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown OAuth1 signature method: " + displayName);
        }
    }
}

