/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.ObjectUtil;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static final long INFINITE_TIMEOUT = 0L;

    public static Timer setInterval(IntervalCallback callback, long interval) {
        return TimeUtil.setInterval(callback, interval, 0L);
    }

    public static Timer setInterval(final IntervalCallback callback, long interval, long duration) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                callback.call(timer);
            }
        }, interval, interval);
        if (duration > 0L) {
            TimeUtil.setTimeout(() -> TimeUtil.cancel(timer), duration);
        }
        return timer;
    }

    public static Timer setTimeout(final TimeoutCallback callback, long timeout) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                callback.call();
            }
        }, timeout);
        return timer;
    }

    public static boolean isCanceled(Timer timer) {
        if (timer == null) {
            return true;
        }
        return (Integer)ObjectUtil.getField(ObjectUtil.getField(timer, "queue"), "size") <= 0;
    }

    public static boolean cancel(Timer timer) {
        if (!TimeUtil.isCanceled(timer)) {
            timer.cancel();
            return true;
        }
        return false;
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static interface IntervalCallback {
        public void call(Timer var1);
    }

    public static interface TimeoutCallback {
        public void call();
    }
}

