/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import java.util.regex.Pattern;

public class GroovyConstants {
    public static final Pattern VARIABLE_NAME_REGEX = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    public static final String[] GROOVY_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "as", "in", "def", "trait"};

    public static boolean isValidVariableName(String variableName) {
        if (variableName == null || variableName.isEmpty()) {
            return false;
        }
        String[] stringArray = GROOVY_KEYWORDS;
        int n = GROOVY_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String groovyKeyword = stringArray[n2];
            if (groovyKeyword.equals(variableName)) {
                return false;
            }
            ++n2;
        }
        return VARIABLE_NAME_REGEX.matcher(variableName).find();
    }
}

