/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.helper.UIEventController;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.UserOrganizationRole;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KatalonTestOpsIntegrationDialog
extends AbstractDialog {
    public static final int REFRESH_ID = 4;
    public static final int GO_TO_PROJECT_ID = 3;
    public static final int OK_ID = 2;
    public static final int NAME_LENGTH_LIMIT = 53;
    private Composite container;
    private Button btnOk;
    private Button btnGoToProject;
    private Button btnRefresh;
    private Button btnNewProject;
    private Text txtOrganization;
    private Combo cbbProjects;
    private Link lnkStatus;
    private List<Organization> organizations = new ArrayList<Organization>();
    private List<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
    private List<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
    private AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore();
    private Organization organization;
    private Combo cbbTeams;
    private GridData gdStatus;
    private Composite subContainer;
    private boolean isOnPremUser;
    @Inject
    private IDiscoveryController discoveryController;
    @Inject
    private ITestOpsController testOpsController;

    public KatalonTestOpsIntegrationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerIntegrationAnalyticsMessageConstants.TITLE_DLG_QUICK_ANALYTICS_INTEGRATION);
    }

    public boolean close() {
        this.updateDataStore(false);
        return super.close();
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 5;
        this.container.setLayout((Layout)glContainer);
        Label lblNote = new Label(this.container, 0);
        lblNote.setImage(ImageManager.getImage((String)"katalon_platform/modern_quality_management.png"));
        Composite recommendComposite = new Composite(this.container, 0);
        recommendComposite.setLayout((Layout)new GridLayout(2, false));
        recommendComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Group grpSelect = new Group(this.container, 0);
        grpSelect.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glGrpSelect = new GridLayout(4, false);
        grpSelect.setLayout((Layout)glGrpSelect);
        grpSelect.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SELECT_GROUP);
        Label lblOrganization = new Label((Composite)grpSelect, 0);
        lblOrganization.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ORGANIZATION);
        this.txtOrganization = new Text((Composite)grpSelect, 8);
        this.txtOrganization.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createTeamComposite(grpSelect);
        Label lblProject = new Label((Composite)grpSelect, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo((Composite)grpSelect, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnNewProject = new Button((Composite)grpSelect, 0);
        this.btnNewProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnNewProject.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.subContainer = new Composite(this.container, 0);
        this.subContainer.setLayout((Layout)new GridLayout());
        this.subContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lnkStatus = new Link(this.subContainer, 64);
        this.gdStatus = new GridData(4, 4, true, false, 1, 1);
        this.gdStatus.heightHint = 0;
        this.lnkStatus.setLayoutData((Object)this.gdStatus);
        this.createPlatformInstructionContent();
        this.initialize();
        return this.container;
    }

    private void createTeamComposite(Group grpSelect) {
        if (this.isOnPremUser) {
            Label lblTeam = new Label((Composite)grpSelect, 0);
            lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
            this.cbbTeams = new Combo((Composite)grpSelect, 8);
            this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        }
    }

    private void initialize() {
        try {
            this.organization = this.testOpsController.getOrganization();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.fillData();
    }

    private void createPlatformInstructionContent() {
        Composite platformInstructionComposite = new Composite(this.subContainer, 0);
        platformInstructionComposite.setLayout((Layout)new GridLayout(1, false));
        platformInstructionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        new Label(platformInstructionComposite, 0).setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_CAN_EXPLORE_PLATFORM_CAPABILITIES);
        Label fistIdea = new Label(platformInstructionComposite, 64);
        fistIdea.setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_START_TEST_SUITE_EXECUTION);
        Label secondLabel = new Label(platformInstructionComposite, 64);
        secondLabel.setText(ComposerIntegrationAnalyticsMessageConstants.INSTRUCTION_START_EXECUTING_WITH_TC);
        Composite exploreComposite = new Composite(platformInstructionComposite, 0);
        exploreComposite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        GridLayout glExplore = new GridLayout(2, false);
        glExplore.marginWidth = 0;
        glExplore.horizontalSpacing = 0;
        glExplore.marginHeight = 0;
        exploreComposite.setLayout((Layout)glExplore);
        CLabel book = new CLabel(exploreComposite, 0);
        book.setImage(this.getBookImage());
        book.setMargins(0, 0, 5, 0);
        StyledText text = new StyledText(exploreComposite, 8);
        text.setEditable(false);
        text.setCaret(null);
        text.setCursor(this.getShell().getDisplay().getSystemCursor(21));
        text.setText(ComposerIntegrationAnalyticsMessageConstants.EXPLORE_FULL_CAPABILITES_OF_PLATFORM);
        text.setBackground(book.getBackground());
        StyleRange style1 = new StyleRange();
        style1.start = 0;
        style1.length = text.getText().length();
        style1.underline = true;
        text.setStyleRange(style1);
        text.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)ComposerIntegrationAnalyticsMessageConstants.EXPLORE_PLATFORM_DOC_LINK);
            }
        });
        text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyledText text = (StyledText)e.widget;
                text.setSelection(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StyledText text = (StyledText)e.widget;
                text.setSelection(0);
            }
        });
    }

    private Image getBookImage() {
        if (ComponentBundleActivator.isDarkTheme((Display)this.getShell().getDisplay())) {
            return ImageManager.getImage((String)"book_dark.png");
        }
        return ImageManager.getImage((String)"book.png");
    }

    private void fillData() {
        this.projects.clear();
        this.organizations.clear();
        this.txtOrganization.setText(StringUtils.abbreviate((String)this.organization.getName(), (int)53));
        this.txtOrganization.setEnabled(false);
        this.enableObject(false);
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            UISynchronizeService.syncExec(() -> {
                boolean isNotEmptyProjects = false;
                this.fetchProjects();
                if (!this.projects.isEmpty()) {
                    isNotEmptyProjects = true;
                } else {
                    this.throwEmptyProjectsOnTheOnCloudOrg();
                }
                if (isNotEmptyProjects) {
                    this.enableObject(true);
                    this.setProjectsBasedOnTeam(this.projects);
                }
            });
        });
    }

    private void throwEmptyProjectsOnTheOnCloudOrg() {
        this.enableObject(false);
        String message = MessageFormat.format(this.getErrorStringPatternWhenReturnEmptyProjects(), Long.toString(this.organization.getId()));
        this.setProgressMessage(message, true);
    }

    private String getErrorStringPatternWhenReturnEmptyProjects() {
        if (this.isOnPremUser) {
            return ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_TEAM;
        }
        return ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECTS_ON_CLOUD_ORG;
    }

    private void enableObject(boolean isEnable) {
        if (this.isOnPremUser) {
            this.cbbTeams.setEnabled(isEnable);
        }
        this.cbbProjects.setEnabled(isEnable);
        if (this.btnOk != null) {
            this.btnOk.setEnabled(isEnable);
        }
    }

    private void fetchProjects() {
        try {
            this.projects.clear();
            List fetchedProjects = this.testOpsController.getProjects();
            if (Objects.nonNull(fetchedProjects) && !fetchedProjects.isEmpty()) {
                this.projects.addAll(fetchedProjects);
            }
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void repackSubContainer(int heightHint) {
        this.gdStatus.heightHint = heightHint;
        this.lnkStatus.setLayoutData((Object)this.gdStatus);
        this.subContainer.layout(true);
    }

    private void setProgressMessage(String message, boolean isError) {
        this.repackSubContainer(message.length() == 0 ? 0 : 30);
        this.lnkStatus.setText(message);
        if (isError) {
            this.lnkStatus.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lnkStatus.setForeground(ColorUtil.getTextSuccessfulColor());
        }
    }

    private void setProjectsBasedOnTeam(List<AnalyticsProject> projects) {
        this.cbbProjects.clearSelection();
        this.cbbProjects.removeAll();
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setEnabled(true);
            if (!projects.isEmpty()) {
                OptionalInt indexOpt;
                String[] names = (String[])projects.stream().map(AnalyticsProject::getName).toArray(String[]::new);
                this.cbbProjects.setItems(names);
                this.cbbProjects.select(0);
                AnalyticsProject project = this.analyticsSettingStore.getProject();
                if (Objects.nonNull(project) && (indexOpt = IntStream.range(0, projects.size()).filter(i -> project.getId().compareTo(((AnalyticsProject)projects.get(i)).getId()) == 0).findFirst()).isPresent()) {
                    this.cbbProjects.select(indexOpt.getAsInt());
                }
            }
            this.setProgressMessage("", false);
        } else {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECT, true);
        }
        this.btnNewProject.setEnabled(!StringUtils.equals((CharSequence)this.organization.getRole(), (CharSequence)UserOrganizationRole.USER.getValue()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnRefresh = this.createButton(parent, 4, "Refresh", true);
        this.btnGoToProject = this.createButton(parent, 3, "Go to Project", false);
        this.btnOk = this.createButton(parent, 2, "OK", true);
    }

    protected void registerControlModifyListeners() {
        this.btnGoToProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverUrl;
                String url = serverUrl = KatalonTestOpsIntegrationDialog.this.discoveryController.getServerUrl(ServerType.TESTOPS);
                if (!KatalonTestOpsIntegrationDialog.this.teams.isEmpty() && !KatalonTestOpsIntegrationDialog.this.teams.isEmpty()) {
                    if (KatalonTestOpsIntegrationDialog.this.projects.isEmpty()) {
                        String patternUrl = serverUrl + "/organization/{0}/home";
                        url = MessageFormat.format(patternUrl, KatalonTestOpsIntegrationDialog.this.organization.getId().toString());
                    } else {
                        AnalyticsProject project = KatalonTestOpsIntegrationDialog.this.projects.get(KatalonTestOpsIntegrationDialog.this.cbbProjects.getSelectionIndex());
                        if (StringUtils.isNotEmpty((CharSequence)project.getTeamId().toString())) {
                            String patternUrl = serverUrl + "/team/{0}/project/{1}";
                            url = MessageFormat.format(patternUrl, project.getTeamId().toString(), project.getId().toString());
                        }
                    }
                }
                Program.launch((String)url);
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KatalonTestOpsIntegrationDialog.this.updateDataStore(true);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/RELOAD_SESSION", (Object)true);
                EventBrokerSingleton.getInstance().getEventBroker().send("START_PAGE/RELOAD", null);
                KatalonTestOpsIntegrationDialog.this.okPressed();
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KatalonTestOpsIntegrationDialog.this.fillData();
            }
        });
        this.btnNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, KatalonTestOpsIntegrationDialog.this.organization.getId().toString());
                Program.launch((String)url);
            }
        });
        this.lnkStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
    }

    private boolean updateDataStore(boolean enableIntegration) {
        block4: {
            try {
                if (this.cbbProjects.getSelectionIndex() != -1) break block4;
                return false;
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
                return false;
            }
        }
        if (enableIntegration) {
            this.analyticsSettingStore.enableIntegration(enableIntegration);
        }
        AnalyticsProject project = this.projects.get(this.cbbProjects.getSelectionIndex());
        this.analyticsSettingStore.setProject(project);
        this.analyticsSettingStore.setTeam(project.getTeam());
        this.analyticsSettingStore.setAutoSubmit(true);
        this.analyticsSettingStore.enableTestCloudIntegration(true);
        this.analyticsSettingStore.enableAutoUploadReport(true);
        UIEventController.getInstance().emitSettingsChange(UIEventController.SettingPage.TESTOPS);
        return true;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(500, initialSize.x), initialSize.y + 20);
    }

    protected void setInput() {
    }

    protected int getShellStyle() {
        return super.getShellStyle() & 0xFFFFFFEF;
    }
}

