/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.UserOrganizationRole;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UploadSelectionDialog
extends Dialog {
    public static final int UPLOAD_ID = 2;
    public static final int CANCEL_ID = 3;
    private Button btnUpload;
    private Button btnCancel;
    private Button btnCreate;
    private Combo cbbProjects;
    private Label lblStatus;
    private List<AnalyticsProject> projects;
    private AnalyticsSettingStore analyticsSettingStore;
    private Organization organization;
    private boolean isOnPremUser;
    private Combo cbbTeams;
    private List<AnalyticsTeam> teams;
    @Inject
    private ITestOpsController testOpsController;

    public UploadSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.analyticsSettingStore = AnalyticsSettingStore.getStore();
        try {
            this.organization = this.testOpsController.getOrganization();
        }
        catch (Exception exception) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData bodyGridData = new GridData(4, 4, true, true);
        body.setLayoutData((Object)bodyGridData);
        GridLayout bodyGridLayout = new GridLayout(1, false);
        bodyGridLayout.marginWidth = 10;
        bodyGridLayout.marginHeight = 10;
        body.setLayout((Layout)bodyGridLayout);
        CLabel lblInformation = new CLabel(body, 64);
        lblInformation.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        lblInformation.setBottomMargin(2);
        String selectionInfo = this.isOnPremUser ? ComposerTestcaseMessageConstants.LBL_SELECTION_INFORMATION_FOR_ON_PREM_USER : ComposerTestcaseMessageConstants.LBL_SELECTION_INFORMATION_FOR_ON_CLOUD_USER;
        lblInformation.setText(selectionInfo);
        GridData gdLabel = new GridData(16384, 0x1000000, false, false);
        gdLabel.widthHint = 50;
        this.createTeamComposite(body, gdLabel);
        Composite projectComposite = new Composite(body, 0);
        projectComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout projectGridLayout = new GridLayout(3, false);
        projectGridLayout.marginWidth = 0;
        projectGridLayout.marginHeight = 0;
        projectComposite.setLayout((Layout)projectGridLayout);
        Label lblProject = new Label(projectComposite, 0);
        lblProject.setLayoutData((Object)gdLabel);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo(projectComposite, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbProjects.setEnabled(false);
        this.btnCreate = new Button(projectComposite, 0);
        this.btnCreate.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.btnCreate.setEnabled(false);
        this.lblStatus = new Label(body, 0);
        this.connect();
        return body;
    }

    private void createTeamComposite(Composite body, GridData gdLabel) {
        if (this.isOnPremUser) {
            Composite teamComposite = new Composite(body, 0);
            teamComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            GridLayout teamGridLayout = new GridLayout(2, false);
            teamGridLayout.marginWidth = 0;
            teamGridLayout.marginHeight = 0;
            teamComposite.setLayout((Layout)teamGridLayout);
            Label lblTeam = new Label(teamComposite, 0);
            lblTeam.setLayoutData((Object)gdLabel);
            lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
            this.cbbTeams = new Combo(teamComposite, 8);
            this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.cbbTeams.setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnUpload = this.createButton(parent, 2, ComposerTestcaseMessageConstants.BTN_UPLOAD, true);
        this.btnUpload.setEnabled(false);
        this.btnCancel = this.createButton(parent, 3, ComposerTestcaseMessageConstants.BTN_CANCEL, false);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.handleUpload();
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, UploadSelectionDialog.this.organization.getId().toString());
                Program.launch((String)url);
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.cancelPressed();
            }
        });
    }

    private void enableCreateProject() {
        this.btnCreate.setEnabled(!StringUtils.equals((CharSequence)this.organization.getRole(), (CharSequence)UserOrganizationRole.USER.getValue()));
    }

    private void setProjectsBasedOnTeam(List<AnalyticsProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(projects).toArray(new String[projects.size()]));
            AnalyticsProject selectedProject = this.analyticsSettingStore.getManualProject();
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getProjectIndex((AnalyticsProject)selectedProject, projects));
        }
    }

    private void fetchProjects() {
        this.projects = AnalyticsAuthorizationHandler.getProjects((ITestOpsController)this.testOpsController);
    }

    private void connect() {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            UISynchronizeService.syncExec(() -> {
                this.fetchProjects();
                this.fillData();
                this.enableObject(true);
                this.enableCreateProject();
                this.setProgressMessage("", false);
            });
        });
    }

    private void enableObject(boolean isEnable) {
        this.cbbProjects.setEnabled(isEnable);
        this.btnUpload.setEnabled(isEnable);
    }

    private void fillData() {
        try {
            this.setProjectsBasedOnTeam(this.projects);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void setProgressMessage(String message, boolean isError) {
        this.lblStatus.setText(message);
        if (isError) {
            this.lblStatus.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblStatus.setForeground(ColorUtil.getTextSuccessfulColor());
        }
        this.lblStatus.getParent().layout();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComposerTestcaseMessageConstants.SELECTION_DIALOG_TITLE);
    }

    private void closeDialog() {
        this.close();
    }

    protected boolean isResizable() {
        return true;
    }

    private void handleUpload() {
        try {
            this.analyticsSettingStore.setManualProject(this.cbbProjects.getSelectionIndex() != -1 ? this.projects.get(this.cbbProjects.getSelectionIndex()) : null);
        }
        catch (IOException e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        this.setReturnCode(2);
        this.closeDialog();
    }
}

