/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.whitelist.rule;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.whitelist.StatusType;
import com.atlassian.oai.validator.whitelist.rule.AndWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.IsEntityWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.OrWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.PrintableWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.RequestOrResponseWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.WhitelistRule;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.models.PathItem;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class WhitelistRules {
    private WhitelistRules() {
    }

    public static WhitelistRule allOf(WhitelistRule ... rules) {
        return new AndWhitelistRule((List<WhitelistRule>)ImmutableList.copyOf((Object[])rules));
    }

    public static WhitelistRule anyOf(WhitelistRule ... rules) {
        return new OrWhitelistRule((List<WhitelistRule>)ImmutableList.copyOf((Object[])rules));
    }

    public static WhitelistRule entityIs(String entityName) {
        return new IsEntityWhitelistRule(entityName);
    }

    public static WhitelistRule messageHasKey(String key) {
        return new PrintableWhitelistRule("Message with key: '" + key + "'", (message, operation, request, response) -> key.equalsIgnoreCase(message.getKey()));
    }

    @Deprecated
    public static WhitelistRule messageContains(String regexp) {
        return WhitelistRules.messageContainsRegexp(regexp);
    }

    public static WhitelistRule messageContainsRegexp(String regexp) {
        return new PrintableWhitelistRule("Message contains match: '" + regexp + "'", (message, operation, request, response) -> WhitelistRules.regexpContain(message.getMessage(), regexp));
    }

    public static WhitelistRule messageContainsSubstring(String substring) {
        return new PrintableWhitelistRule("Message contains substring: '" + substring + "'", (message, operation, request, response) -> WhitelistRules.stringContains(message.getMessage(), substring));
    }

    @Deprecated
    public static WhitelistRule pathContains(String regexp) {
        return WhitelistRules.pathContainsRegexp(regexp);
    }

    public static WhitelistRule pathContainsRegexp(String regexp) {
        return new PrintableWhitelistRule("Api path contains match: '" + regexp + "'", (message, operation, request, response) -> operation != null && WhitelistRules.regexpContain(operation.getApiPath().normalised(), regexp));
    }

    public static WhitelistRule pathContainsSubstring(String substring) {
        return new PrintableWhitelistRule("Api path contains substring: '" + substring + "'", (message, operation, request, response) -> operation != null && WhitelistRules.stringContains(operation.getApiPath().normalised(), substring));
    }

    public static WhitelistRule isRequest() {
        return new PrintableWhitelistRule("Is request", (message, operation, request, response) -> request != null);
    }

    public static WhitelistRule isResponse() {
        return new PrintableWhitelistRule("Is response", (message, operation, request, response) -> response != null);
    }

    public static WhitelistRule responseStatusIs(int status) {
        return new PrintableWhitelistRule("Response status is " + status, (message, operation, request, response) -> response != null && response.getStatus() == status);
    }

    public static WhitelistRule responseStatusTypeIs(StatusType statusType) {
        return new PrintableWhitelistRule("Response status is " + (Object)((Object)statusType), (message, operation, request, response) -> response != null && statusType.matches(response.getStatus()));
    }

    public static WhitelistRule methodIs(PathItem.HttpMethod method) {
        return new PrintableWhitelistRule("Method is " + method, (message, operation, request, response) -> operation != null && operation.getMethod() == method);
    }

    @Deprecated
    public static WhitelistRule headerContains(String header, String regexp) {
        return WhitelistRules.headerContainsRegexp(header, regexp);
    }

    public static WhitelistRule headerContainsRegexp(final String header, final String regexp) {
        return new PrintableWhitelistRule("Header '" + header + "' contains match '" + regexp + "'", new RequestOrResponseWhitelistRule(){

            @Override
            public boolean matches(ValidationReport.Message message, ApiOperation operation, Request request) {
                return ((Collection)request.getHeaders().getOrDefault(header, Collections.emptyList())).stream().anyMatch(value -> WhitelistRules.regexpContain(value, regexp));
            }

            @Override
            public boolean matches(ValidationReport.Message message, ApiOperation operation, Response response) {
                return response.getHeaderValues(header).stream().anyMatch(value -> WhitelistRules.regexpContain(value, regexp));
            }
        });
    }

    public static WhitelistRule headerContainsSubstring(final String header, final String substring) {
        return new PrintableWhitelistRule("Header '" + header + "' contains substring '" + substring + "'", new RequestOrResponseWhitelistRule(){

            @Override
            public boolean matches(ValidationReport.Message message, ApiOperation operation, Request request) {
                return ((Collection)request.getHeaders().getOrDefault(header, Collections.emptyList())).stream().anyMatch(value -> WhitelistRules.stringContains(value, substring));
            }

            @Override
            public boolean matches(ValidationReport.Message message, ApiOperation operation, Response response) {
                return response.getHeaderValues(header).stream().anyMatch(value -> WhitelistRules.stringContains(value, substring));
            }
        });
    }

    private static boolean regexpContain(String value, String regexp) {
        return Pattern.compile(regexp, 2).matcher(value).find();
    }

    private static boolean stringContains(String value, String substring) {
        return value.contains(substring);
    }
}

