/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.util;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.workspace.ApplicationWorkspaceInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationWorkspaceInfoUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationWorkspaceInfoUtil.class);
    private static final String WORKSPACE_PATH = GlobalStringConstants.APP_USER_DIR_LOCATION + File.separator + "workspace.json";

    public static void saveWorkspaceInfo(ApplicationWorkspaceInfo workspaceInfo) {
        File file = new File(WORKSPACE_PATH);
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try {
            String jsonContent = JsonUtil.toJson((Object)workspaceInfo);
            FileUtils.writeStringToFile((File)new File(WORKSPACE_PATH), (String)jsonContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Failed to save application workspace information", (Throwable)e);
        }
    }

    public static ApplicationWorkspaceInfo loadWorkspaceInfo() {
        File file = new File(WORKSPACE_PATH);
        if (!file.exists()) {
            return null;
        }
        try {
            String jsonContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            return (ApplicationWorkspaceInfo)JsonUtil.fromJson((String)jsonContent, ApplicationWorkspaceInfo.class);
        }
        catch (IOException e) {
            logger.error("Failed to load application workspace information", (Throwable)e);
            return null;
        }
    }
}

