/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.EngineLogger;
import com.kms.katalon.core.webui.common.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;

public class EBrowser {
    protected WebDriver driver;

    public EBrowser(WebDriver driver) {
        this.driver = driver;
    }

    public Result navigateToURL(String url) {
        Result result = new Result();
        try {
            if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
                this.driver.navigate().to(url);
            } else {
                this.driver.navigate().to("http://" + url);
            }
        }
        catch (TimeoutException timeoutException) {
            this.handleTimeoutLoading();
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT047"), url, e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result back() {
        Result result = new Result();
        try {
            this.driver.navigate().back();
        }
        catch (TimeoutException timeoutException) {
            this.handleTimeoutLoading();
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT048"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result forward() {
        Result result = new Result();
        try {
            this.driver.navigate().forward();
        }
        catch (TimeoutException timeoutException) {
            this.handleTimeoutLoading();
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT049"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result refresh() {
        Result result = new Result();
        try {
            this.driver.navigate().refresh();
        }
        catch (TimeoutException timeoutException) {
            this.handleTimeoutLoading();
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT050"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result deleteCookies() {
        Result result = new Result();
        try {
            this.driver.manage().deleteAllCookies();
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT051"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    public Result delay(int second) {
        Result result = new Result();
        if (second >= 0) {
            try {
                Thread.sleep(second * 1000);
                result.setReturnValue(second * 1000);
            }
            catch (InterruptedException e) {
                result.setReturnValue(false);
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT052"), e.getMessage()));
                result.setNeedReNewDriver(true);
            }
            return result;
        }
        result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT053"), second));
        result.setReturnValue(false);
        return result;
    }

    public Result waitForPageLoaded(int timeOut) {
        return Result.reportHappyCase(true);
    }

    protected void handleTimeoutLoading() {
        System.out.println("Time's up");
        try {
            this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{Keys.ESCAPE});
        }
        catch (Exception exception) {
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            executor.executeScript("return window.stop()", new Object[0]);
        }
        System.out.println("Stop loading");
    }

    protected boolean isCertificatedBlock() {
        try {
            if (this.driver.getTitle().contains("Certificate")) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Result navigateToCertificatedPage() {
        try {
            while (this.isCertificatedBlock()) {
                this.driver.navigate().to("javascript:document.getElementById('overridelink').click()");
            }
        }
        catch (Exception exception) {}
        return Result.reportHappyCase(true);
    }
}

