/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.common.XPathBuilder;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webui.common.CssLocatorBuilder;
import com.kms.katalon.core.webui.common.FindElementsResult;
import com.kms.katalon.core.webui.common.WebUICommonScripts;
import com.kms.katalon.core.webui.common.internal.ImageLocatorController;
import com.kms.katalon.core.webui.common.internal.SelfHealingController;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.exception.WebElementNotFoundException;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.selenium.driver.ISmartExtensionWebDriver;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Select;

public class WebUiCommonHelper
extends KeywordHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebUiCommonHelper.class);
    private static final int EXECUTION_DEFAULT_TIMEOUT_VALUE = 10;
    public static final String CSS_LOCATOR_PROPERTY_NAME = "css";
    public static final String XPATH_LOCATOR_PROPERTY_NAME = "xpath";
    public static final String WEB_ELEMENT_TAG = "tag";
    public static final String WEB_ELEMENT_ATTRIBUTE_LINK_TEXT = "link_text";
    public static final String WEB_ELEMENT_ATTRIBUTE_TEXT = "text";
    public static final String WEB_ELEMENT_XPATH = "xpath";

    public static int checkTimeout(int timeout) {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_TIMEOUT);
        if (timeout <= 0) {
            int defaultPageLoadTimeout = RunConfiguration.getElementTimeoutForWeb();
            defaultPageLoadTimeout = defaultPageLoadTimeout <= 0 ? 10 : defaultPageLoadTimeout;
            logger.logWarning(MessageFormat.format(StringConstants.COMM_LOG_WARNING_INVALID_TIMEOUT, timeout, defaultPageLoadTimeout));
            return defaultPageLoadTimeout;
        }
        return timeout;
    }

    public static boolean isTextPresent(WebDriver webDriver, String text, boolean isRegex) throws WebDriverException, IllegalArgumentException {
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_EXC_CHECKING_TEXT_PRESENT, regularExpressionLog));
        if (text == null) {
            throw new IllegalArgumentException(StringConstants.COMM_EXC_TEXT_IS_NULL);
        }
        boolean isContained = false;
        WebElement bodyElement = webDriver.findElement(By.tagName((String)"body"));
        String pageText = bodyElement.getText();
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_FINDING_TEXT_ON_PAGE, text, regularExpressionLog));
        if (pageText != null && !pageText.isEmpty()) {
            if (isRegex) {
                Pattern pattern = Pattern.compile(text);
                Matcher matcher = pattern.matcher(pageText);
                if (matcher.find()) {
                    isContained = true;
                }
            } else {
                isContained = pageText.contains(text);
            }
        }
        return isContained;
    }

    public static boolean switchToWindowUsingTitle(WebDriver webDriver, String title, int timeOutInSeconds) throws WebDriverException, InterruptedException {
        long timeoutAt = System.currentTimeMillis() + (long)timeOutInSeconds * 1000L;
        while (System.currentTimeMillis() < timeoutAt) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!(webDriver = webDriver.switchTo().window(windowId)).getTitle().equals(title)) continue;
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    public static boolean closeWindowUsingTitle(WebDriver webDriver, String title) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getElementTimeoutForWeb()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!(webDriver = webDriver.switchTo().window(windowId)).getTitle().equals(title)) continue;
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean switchToWindowUsingUrl(WebDriver webDriver, String url) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getElementTimeoutForWeb()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!webDriver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean closeWindowUsingUrl(WebDriver webDriver, String url) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getElementTimeoutForWeb()) {
            Set availableWindows = webDriver.getWindowHandles();
            for (String windowId : availableWindows) {
                if (!webDriver.switchTo().window(windowId).getCurrentUrl().equals(url)) continue;
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean switchToWindowUsingIndex(WebDriver webDriver, int index) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getElementTimeoutForWeb()) {
            ArrayList availableWindows = new ArrayList(webDriver.getWindowHandles());
            if (index >= 0 && index < availableWindows.size()) {
                webDriver.switchTo().window((String)availableWindows.get(index));
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static boolean closeWindowUsingIndex(WebDriver webDriver, int index) throws InterruptedException {
        float timeCount = 0.0f;
        while (timeCount < (float)RunConfiguration.getElementTimeoutForWeb()) {
            ArrayList availableWindows = new ArrayList(webDriver.getWindowHandles());
            if (index >= 0 && index < availableWindows.size()) {
                webDriver.switchTo().window((String)availableWindows.get(index));
                webDriver.close();
                return true;
            }
            Thread.sleep(200L);
            timeCount = (float)((double)timeCount + 0.2);
        }
        return false;
    }

    public static void checkSelectIndex(Integer[] indexes, Select select) throws IllegalArgumentException {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_INDEX_PARAMS);
        List allSelectOptions = select.getOptions();
        if (allSelectOptions.size() > 0) {
            Integer[] integerArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = integerArray[n2];
                if (index < 0 || index >= allSelectOptions.size()) {
                    throw new IllegalArgumentException(MessageFormat.format(StringConstants.COMM_EXC_INVALID_INDEX, index, allSelectOptions.size() - 1));
                }
                ++n2;
            }
        }
    }

    public static void selectOrDeselectAllOptions(Select select, boolean isSelect, TestObject to) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_ALL_OPT_ON_OBJ, to.getObjectId()));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_ALL_OPTS_ON_OBJ, to.getObjectId()));
        }
        int index = 0;
        while (index < select.getOptions().size()) {
            if (isSelect) {
                select.selectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_W_INDEX_X_IS_SELECTED, index));
            } else {
                select.deselectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTED_OPT_IDX_X, index));
            }
            ++index;
        }
    }

    public static void selectOrDeselectOptionsByIndex(Select select, Integer[] indexes, boolean isSelect, TestObject to) {
        WebUiCommonHelper.checkSelectIndex(indexes, select);
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OBJ_OPTS_W_INDEX_IN, to.getObjectId(), WebUiCommonHelper.integerArrayToString((Integer[])indexes)));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_W_IDX, to.getObjectId(), WebUiCommonHelper.integerArrayToString((Integer[])indexes)));
        }
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (isSelect) {
                select.selectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_W_INDEX_X_IS_SELECTED, index));
            } else {
                select.deselectByIndex(index);
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTED_OPT_IDX_X, index));
            }
            ++n2;
        }
    }

    public static boolean selectOrDeselectOptionsByValue(Select select, String value, boolean isRegex, boolean isSelect, TestObject to, String regularExpressionLog) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OPTS_ON_OBJ_X_W_VAL_Y, to.getObjectId(), value, regularExpressionLog));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_W_VAL, to.getObjectId(), value, regularExpressionLog));
        }
        if (isRegex) {
            return WebUiCommonHelper.selectOrDeselectOptionsByValueByRegularExpression(select, value, isSelect, regularExpressionLog);
        }
        if (isSelect) {
            select.selectByValue(value);
        } else {
            select.deselectByValue(value);
        }
        return true;
    }

    private static boolean selectOrDeselectOptionsByValueByRegularExpression(Select select, String value, boolean isSelect, String regularExpressionLog) {
        List allOptions = select.getOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && WebUiCommonHelper.match((String)optionValue, (String)value, (boolean)true)) {
                if (isSelect) {
                    select.selectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTED_OPT_AT_INDEX_W_VAL, index, optionValue, regularExpressionLog));
                } else {
                    select.deselectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_VAL_Y_IS_SELECTED, index, optionValue, regularExpressionLog));
                }
                return true;
            }
            ++index;
        }
        return false;
    }

    public static boolean selectOrDeselectOptionsByLabel(Select select, String label, boolean isRegex, boolean isSelect, TestObject to, String regularExpressionLog) {
        if (isSelect) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SELECTING_OPTS_ON_OBJ_X_W_LBL_Y, to.getObjectId(), label, regularExpressionLog));
        } else {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_DESELECTING_OPTS_ON_OBJ_X_W_LBL_Y, to.getObjectId(), label, regularExpressionLog));
        }
        if (isRegex) {
            return WebUiCommonHelper.selectOrDeselectOptionsByLabelWithRegularExpression(select, label, isSelect, regularExpressionLog);
        }
        if (isSelect) {
            select.selectByVisibleText(label);
        } else {
            select.deselectByVisibleText(label);
        }
        return true;
    }

    private static boolean selectOrDeselectOptionsByLabelWithRegularExpression(Select select, String label, boolean isSelect, String regularExpressionLog) {
        List allOptions = select.getOptions();
        boolean isMatched = false;
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getText();
            if (optionValue != null && WebUiCommonHelper.match((String)optionValue, (String)label, (boolean)true)) {
                if (isSelect) {
                    select.selectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_LBL_TXT_Y_IS_SELECTED, index, optionValue, regularExpressionLog));
                } else {
                    select.deselectByIndex(index);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OPT_AT_IDX_X_W_LBL_TXT_Y_IS_DESELECTED, index, optionValue, regularExpressionLog));
                }
                isMatched = true;
            }
            ++index;
        }
        return isMatched;
    }

    public static int getNumberOfOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_PRESENT_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex)) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_PRESENT, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_PRESENT_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex)) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_PRESENT, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_SELECTED_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex) && allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_SELECTED, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByLabel(Select select, String label, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_LBL_NOT_SELECTED_ON_OBJ, label, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionLabel = ((WebElement)allOptions.get(index)).getText();
            if (optionLabel != null && KeywordHelper.match((String)optionLabel, (String)label, (boolean)isRegex) && !allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_LBL_IS_NOT_SELECTED, index, optionLabel, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_SELECTED_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex) && allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_SELECTED, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByValue(Select select, String value, boolean isRegex, String objectId) {
        int count = 0;
        String regularExpressionLog = isRegex ? " using regular expression" : "";
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_VAL_NOT_SELECTED_ON_OBJ, value, objectId, regularExpressionLog));
        List allOptions = select.getOptions();
        List allSelectedOptions = select.getAllSelectedOptions();
        int index = 0;
        while (index < allOptions.size()) {
            String optionValue = ((WebElement)allOptions.get(index)).getAttribute("value");
            if (optionValue != null && KeywordHelper.match((String)optionValue, (String)value, (boolean)isRegex) && !allSelectedOptions.contains(allOptions.get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_W_VAL_IS_NOT_SELECTED, index, optionValue, regularExpressionLog));
            }
            ++index;
        }
        return count;
    }

    public static int getNumberOfSelectedOptionByIndex(Select select, Integer[] indexes, String objectId) throws IllegalArgumentException {
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_INDEX_RANGE_SELECTED_ON_OBJ, WebUiCommonHelper.integerArrayToString((Integer[])indexes), objectId));
        int count = 0;
        List allSelectedOptions = select.getAllSelectedOptions();
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (allSelectedOptions.contains(select.getOptions().get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_IS_SELECTED, index));
            }
            ++n2;
        }
        return count;
    }

    public static int getNumberOfNotSelectedOptionByIndex(Select select, Integer[] indexes, String objectId) {
        logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_COUNTING_NUM_OPTS_W_INDEX_RANGE_NOT_SELECTED_ON_OBJ, WebUiCommonHelper.integerArrayToString((Integer[])indexes), objectId));
        int count = 0;
        List allSelectedOptions = select.getAllSelectedOptions();
        Integer[] integerArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = integerArray[n2];
            if (!allSelectedOptions.contains(select.getOptions().get(index))) {
                ++count;
                logger.logDebug(MessageFormat.format(StringConstants.COMM_LOG_INFO_OPT_AT_INDEX_IS_NOT_SELECTED, index));
            }
            ++n2;
        }
        return count;
    }

    public static void focusOnBrowser() throws WebDriverException, StepFailedException {
        ((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("window.focus()", new Object[0]);
    }

    public static By buildLocator(TestObject testObject) {
        return WebUiCommonHelper.buildLocator(testObject, testObject.getSelectorMethod());
    }

    public static By buildLocator(TestObject testObject, SelectorMethod locatorMethod) {
        switch (locatorMethod) {
            case BASIC: {
                String cssLocatorValue = WebUiCommonHelper.findActiveEqualsObjectProperty(testObject, CSS_LOCATOR_PROPERTY_NAME);
                if (cssLocatorValue != null) {
                    return By.cssSelector((String)cssLocatorValue);
                }
                return WebUiCommonHelper.buildXpath(testObject);
            }
            case CSS: {
                return By.cssSelector((String)((String)testObject.getSelectorCollection().get(locatorMethod)));
            }
            case XPATH: {
                if (testObject.getSelectorCollection().isEmpty()) {
                    testObject.setSelectorValue(locatorMethod, ((TestObjectXpath)testObject.getXpaths().get(0)).getValue());
                }
                return By.xpath((String)((String)testObject.getSelectorCollection().get(locatorMethod)));
            }
            case SMART_LOCATOR: {
                return By.id((String)((String)testObject.getSmartSelectorCollection().get(locatorMethod)));
            }
        }
        return null;
    }

    public static By buildUnionXpath(TestObject to) {
        return WebUiCommonHelper.buildXpath(to, XPathBuilder.AggregationType.UNION, to.getProperties());
    }

    public static String getSelectorValue(TestObject testObject) {
        return WebUiCommonHelper.getSelectorValue(testObject, testObject.getSelectorMethod());
    }

    public static String getSelectorValue(TestObject to, SelectorMethod selectorMethod) {
        switch (selectorMethod) {
            case BASIC: {
                String cssLocatorValue = WebUiCommonHelper.findActiveEqualsObjectProperty(to, CSS_LOCATOR_PROPERTY_NAME);
                if (cssLocatorValue != null) {
                    return cssLocatorValue;
                }
                XPathBuilder xpathBuilder = new XPathBuilder(to.getActiveProperties());
                return xpathBuilder.build();
            }
            case XPATH: {
                String ret = (String)to.getSelectorCollection().get(selectorMethod);
                if (ret == null && to.getXpaths() != null && !to.getXpaths().isEmpty()) {
                    ret = ((TestObjectXpath)to.getXpaths().get(0)).getValue();
                    to.setSelectorValue(selectorMethod, ret);
                }
                return ret;
            }
            case CSS: {
                return (String)to.getSelectorCollection().get(selectorMethod);
            }
            case SMART_LOCATOR: {
                return (String)to.getSmartSelectorCollection().get(selectorMethod);
            }
        }
        return (String)to.getSelectorCollection().get(selectorMethod);
    }

    public static String findActiveEqualsObjectProperty(TestObject to, String propertyName) {
        for (TestObjectProperty property : to.getActiveProperties()) {
            if (!property.getName().equals(propertyName) || property.getCondition() != ConditionType.EQUALS) continue;
            return property.getValue();
        }
        return null;
    }

    private static By buildXpath(TestObject to) {
        return WebUiCommonHelper.buildXpath(to, XPathBuilder.AggregationType.INTERSECT, to.getActiveProperties());
    }

    private static By buildXpath(TestObject to, XPathBuilder.AggregationType aggregationType, List<TestObjectProperty> properties) {
        XPathBuilder xpathBuilder = new XPathBuilder(properties);
        return By.xpath((String)xpathBuilder.build(aggregationType));
    }

    private static List<Map.Entry<String, By>> buildXpathsFromXpathBasedConditions(TestObject to) {
        XPathBuilder xpathBuilder = new XPathBuilder(to.getProperties());
        return xpathBuilder.buildXpathBasedLocators().stream().map(entry -> new AbstractMap.SimpleEntry<String, By>((String)entry.getKey(), By.xpath((String)((String)entry.getValue())))).collect(Collectors.toList());
    }

    public static String getBrowserAndVersion(WebDriver webDriver) {
        return WebUiCommonHelper.getBrowserName(webDriver) + " " + WebUiCommonHelper.getBrowserVersion(webDriver);
    }

    public static String getBrowserName(WebDriver webDriver) {
        Capabilities capabilities = ((RemoteWebDriver)webDriver).getCapabilities();
        String browserName = capabilities.getBrowserName();
        if (browserName.equalsIgnoreCase("MicrosoftEdge")) {
            return "Edge Chromium";
        }
        return browserName.substring(0, 1).toUpperCase() + browserName.substring(1);
    }

    public static String getBrowserVersion(WebDriver webDriver) {
        Capabilities capabilities = ((RemoteWebDriver)webDriver).getCapabilities();
        String browserVersion = capabilities.getBrowserVersion();
        if (browserVersion == null || browserVersion.isEmpty() || browserVersion.equalsIgnoreCase("latest")) {
            browserVersion = WebUiCommonHelper.getBrowserVersionFromUserAgent(webDriver);
        }
        return browserVersion;
    }

    private static String getBrowserVersionFromUserAgent(WebDriver webDriver) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)webDriver;
        String userAgent = (String)jsExecutor.executeScript("return navigator.userAgent;", new Object[0]);
        if (userAgent.contains("Chrome")) {
            return userAgent.split("Chrome/")[1].split(" ")[0];
        }
        if (userAgent.contains("Version/")) {
            return userAgent.split("Version/")[1].split(" ")[0];
        }
        return "";
    }

    public static int getViewportWidth(WebDriver webDriver) {
        Long longValue = (Long)((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("return Math.max(document.documentElement.clientWidth, window.innerWidth || 0);", new Object[0]);
        return longValue.intValue();
    }

    public static int getViewportHeight(WebDriver webDriver) {
        Long longValue = (Long)((JavascriptExecutor)DriverFactory.getWebDriver()).executeScript("return Math.max(document.documentElement.clientHeight, window.innerHeight || 0);", new Object[0]);
        return longValue.intValue();
    }

    public static Rectangle getElementRect(WebDriver webDriver, WebElement element) {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
        Number left = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().left", new Object[]{element});
        Number right = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().right", new Object[]{element});
        Number top = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().top", new Object[]{element});
        Number bottom = (Number)javascriptExecutor.executeScript("return arguments[0].getBoundingClientRect().bottom", new Object[]{element});
        return new Rectangle(left.intValue(), top.intValue(), right.intValue() - left.intValue(), bottom.intValue() - top.intValue());
    }

    public static boolean isElementVisibleInViewport(WebDriver driver, TestObject testObject, int timeOut) throws Exception {
        WebUiCommonHelper.checkTestObjectParameter((TestObject)testObject);
        TestObject parentObject = testObject != null ? testObject.getParentObject() : null;
        ArrayList<TestObject> frames = new ArrayList<TestObject>();
        while (parentObject != null) {
            frames.add(parentObject);
            parentObject = parentObject.getParentObject();
        }
        boolean isSwitchIntoFrame = false;
        double xOffset = 0.0;
        double yOffset = 0.0;
        try {
            if (frames.size() > 0) {
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OBJ_X_HAS_PARENT_FRAME, testObject.getObjectId()));
                int i = frames.size() - 1;
                while (i >= 0) {
                    TestObject frameObject = (TestObject)frames.get(i);
                    logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHING_TO_IFRAME_X, frameObject.getObjectId()));
                    WebElement frameElement = WebUiCommonHelper.findWebElement(frameObject, timeOut);
                    if (frameElement != null) {
                        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_CHECKING_TO_IFRAME_X_IN_VIEWPORT, frameObject.getObjectId()));
                        Rectangle elementRect = WebUiCommonHelper.getElementRect(driver, frameElement);
                        elementRect.setRect(elementRect.getX() + xOffset, elementRect.getY() + yOffset, elementRect.getWidth(), elementRect.getHeight());
                        logger.logDebug(MessageFormat.format("Element position in viewport: x = {0}, y = {1}, width = {2}, height = {3}", elementRect.getX(), elementRect.getY(), elementRect.getWidth(), elementRect.getHeight()));
                        Rectangle documentRect = new Rectangle(0, 0, WebUiCommonHelper.getViewportWidth(driver), WebUiCommonHelper.getViewportHeight(driver));
                        logger.logDebug(MessageFormat.format("Viewport infomation: width = {0}, height = {1}", documentRect.getWidth(), documentRect.getHeight()));
                        if (!documentRect.intersects(elementRect)) {
                            logger.logDebug(MessageFormat.format(StringConstants.KW_MSG_PARENT_OBJECT_IS_NOT_VISIBLE_IN_VIEWPORT, frameObject.getObjectId()));
                            return false;
                        }
                        xOffset += (double)frameElement.getLocation().getX();
                        yOffset += (double)frameElement.getLocation().getY();
                        driver.switchTo().frame(frameElement);
                        isSwitchIntoFrame = true;
                        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHED_TO_IFRAME_X, frameObject.getObjectId()));
                    }
                    --i;
                }
            }
            WebElement foundElement = WebUiCommonHelper.findWebElement(testObject, timeOut);
            boolean bl = WebUiCommonHelper.isElementVisibleInViewport(driver, foundElement);
            return bl;
        }
        finally {
            if (isSwitchIntoFrame) {
                WebUiCommonHelper.switchToDefaultContent();
            }
        }
    }

    public static boolean isElementVisibleInViewport(WebDriver driver, WebElement element) {
        Rectangle elementRect = WebUiCommonHelper.getElementRect(driver, element);
        logger.logDebug(MessageFormat.format("Element position in viewport: x = {0}, y = {1}, width = {2}, height = {3}", elementRect.getX(), elementRect.getY(), elementRect.getWidth(), elementRect.getHeight()));
        Rectangle documentRect = new Rectangle(0, 0, WebUiCommonHelper.getViewportWidth(driver), WebUiCommonHelper.getViewportHeight(driver));
        logger.logDebug(MessageFormat.format("Viewport infomation: width = {0}, height = {1}", documentRect.getWidth(), documentRect.getHeight()));
        return documentRect.intersects(elementRect);
    }

    public static List<WebElement> findWebElements(TestObject testObject, int timeout) throws Exception {
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealing();
        timeout = WebUiCommonHelper.checkTimeout(timeout);
        if (shouldApplySelfHealing) {
            return WebUiCommonHelper.findElementsWithSelfHealing(testObject, timeout);
        }
        return WebUiCommonHelper.findElementsByDefault(testObject, timeout);
    }

    private static List<WebElement> findElementsWithSelfHealingEnhanced(TestObject testObject) throws Exception {
        SelfHealingController.setLogger(logger);
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealing();
        if (!shouldApplySelfHealing) {
            return null;
        }
        try {
            boolean isWebPlatform = KeywordExecutionContext.isRunningWebUI();
            String runningKeyword = KeywordExecutionContext.getRunningKeyword();
            List excludeKeywords = RunConfiguration.getExcludedWebUIKeywordsFromSelfHealing();
            if (!isWebPlatform || excludeKeywords.contains(runningKeyword)) {
                return Collections.emptyList();
            }
            SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_DEFAULT_LOCATOR_FAILED_TRY_SELF_HEALING, testObject.getObjectId()));
            String dataFileAtReportFolder = SelfHealingController.getSelfHealingDataFilePath(RunConfiguration.getReportFolder());
            SelfHealingController.prepareDataFile(dataFileAtReportFolder);
            Set<BrokenTestObject> healingCandidates = SelfHealingController.findBrokenTestObjects(testObject);
            if (healingCandidates != null && !healingCandidates.isEmpty()) {
                for (BrokenTestObject healingCandidate : healingCandidates) {
                    TestObject healedTestObject = SelfHealingController.healTestObject(testObject, healingCandidate);
                    List<WebElement> foundElements = WebUiCommonHelper.findElementsByDefault(healedTestObject, 0);
                    if (foundElements == null || foundElements.isEmpty()) continue;
                    String proposedLocator = (String)healedTestObject.getSelectorCollection().get(healedTestObject.getSelectorMethod());
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, testObject.getObjectId(), proposedLocator));
                    KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
                    FindElementsResult findResultForReport = FindElementsResult.from(foundElements, healedTestObject);
                    String screenshotPath = SelfHealingController.getScreenshotAbsolutePath(healingCandidate.getPathToScreenshot());
                    findResultForReport.setScreenshot(screenshotPath);
                    WebUiCommonHelper.registerBrokenTestObject(findResultForReport, testObject, RunConfiguration.getReportFolder());
                    return foundElements;
                }
            }
            List methodsPriorityOrder = RunConfiguration.getMethodsPriorityOrder();
            SelectorMethod elementMethod = testObject.getSelectorMethod();
            for (Pair rawMethod : methodsPriorityOrder) {
                boolean shouldFindWithSelectedMethod;
                boolean isMethodEnabled = (Boolean)rawMethod.getRight();
                if (!isMethodEnabled) continue;
                SelectorMethod currentMethod = (SelectorMethod)rawMethod.getLeft();
                boolean bl = shouldFindWithSelectedMethod = currentMethod != elementMethod || currentMethod == SelectorMethod.XPATH;
                if (!shouldFindWithSelectedMethod) continue;
                try {
                    boolean hasFindWithDefaultXPath;
                    FindElementsResult findResult = null;
                    boolean bl2 = hasFindWithDefaultXPath = elementMethod == SelectorMethod.XPATH;
                    if (currentMethod == SelectorMethod.XPATH && !hasFindWithDefaultXPath) {
                        findResult = WebUiCommonHelper.findElementsBySelectedMethod(testObject, 0, currentMethod, false);
                    }
                    if (findResult == null || findResult.isEmpty()) {
                        findResult = WebUiCommonHelper.findElementsBySelectedMethod(testObject, 0, currentMethod, true);
                    }
                    if (findResult == null || findResult.isEmpty()) continue;
                    BrokenTestObject brokenTestObject = WebUiCommonHelper.registerBrokenTestObject(findResult, testObject);
                    WebUiCommonHelper.registerBrokenTestObject(findResult, testObject, RunConfiguration.getReportFolder());
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, testObject.getObjectId(), brokenTestObject.getProposedLocator()));
                    KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
                    return findResult.getElements();
                }
                catch (Exception exception) {
                    SelfHealingController.logWarning(exception.getMessage(), exception);
                }
            }
        }
        catch (Exception exception) {
            SelfHealingController.logWarning(exception.getMessage(), exception);
        }
        return Collections.emptyList();
    }

    private static List<WebElement> findElementsWithSelfHealing(TestObject testObject, int timeout) throws Exception {
        SelfHealingController.setLogger(logger);
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealing();
        if (!shouldApplySelfHealing) {
            return WebUiCommonHelper.findElementsByDefault(testObject, timeout);
        }
        Exception defaultException = null;
        try {
            List<Object> foundElements = new ArrayList();
            foundElements = WebUiCommonHelper.findElementsByDefault(testObject, timeout);
            if (foundElements != null && !foundElements.isEmpty()) {
                return foundElements;
            }
        }
        catch (Exception exception) {
            defaultException = exception;
        }
        try {
            boolean isWebPlatform = KeywordExecutionContext.isRunningWebUI();
            String runningKeyword = KeywordExecutionContext.getRunningKeyword();
            List excludeKeywords = RunConfiguration.getExcludedWebUIKeywordsFromSelfHealing();
            if (!isWebPlatform || excludeKeywords.contains(runningKeyword)) {
                return Collections.emptyList();
            }
            SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_DEFAULT_LOCATOR_FAILED_TRY_SELF_HEALING, testObject.getObjectId()));
            String dataFileAtReportFolder = SelfHealingController.getSelfHealingDataFilePath(RunConfiguration.getReportFolder());
            SelfHealingController.prepareDataFile(dataFileAtReportFolder);
            Set<BrokenTestObject> healingCandidates = SelfHealingController.findBrokenTestObjects(testObject);
            if (healingCandidates != null && !healingCandidates.isEmpty()) {
                for (BrokenTestObject healingCandidate : healingCandidates) {
                    TestObject healedTestObject = SelfHealingController.healTestObject(testObject, healingCandidate);
                    List<WebElement> foundElements = WebUiCommonHelper.findElementsByDefault(healedTestObject, 0);
                    if (foundElements == null || foundElements.isEmpty()) continue;
                    String proposedLocator = (String)healedTestObject.getSelectorCollection().get(healedTestObject.getSelectorMethod());
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, testObject.getObjectId(), proposedLocator));
                    KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
                    FindElementsResult findResultForReport = FindElementsResult.from(foundElements, healedTestObject);
                    String screenshotPath = SelfHealingController.getScreenshotAbsolutePath(healingCandidate.getPathToScreenshot());
                    findResultForReport.setScreenshot(screenshotPath);
                    WebUiCommonHelper.registerBrokenTestObject(findResultForReport, testObject, RunConfiguration.getReportFolder());
                    return foundElements;
                }
            }
            List methodsPriorityOrder = RunConfiguration.getMethodsPriorityOrder();
            SelectorMethod elementMethod = testObject.getSelectorMethod();
            for (Pair rawMethod : methodsPriorityOrder) {
                boolean shouldFindWithSelectedMethod;
                boolean isMethodEnabled = (Boolean)rawMethod.getRight();
                if (!isMethodEnabled) continue;
                SelectorMethod currentMethod = (SelectorMethod)rawMethod.getLeft();
                boolean bl = shouldFindWithSelectedMethod = currentMethod != elementMethod || currentMethod == SelectorMethod.XPATH;
                if (!shouldFindWithSelectedMethod) continue;
                try {
                    boolean hasFindWithDefaultXPath;
                    FindElementsResult findResult = null;
                    boolean bl2 = hasFindWithDefaultXPath = elementMethod == SelectorMethod.XPATH;
                    if (currentMethod == SelectorMethod.XPATH && !hasFindWithDefaultXPath) {
                        findResult = WebUiCommonHelper.findElementsBySelectedMethod(testObject, 0, currentMethod, false);
                    }
                    if (findResult == null || findResult.isEmpty()) {
                        findResult = WebUiCommonHelper.findElementsBySelectedMethod(testObject, 0, currentMethod, true);
                    }
                    if (findResult == null || findResult.isEmpty()) continue;
                    BrokenTestObject brokenTestObject = WebUiCommonHelper.registerBrokenTestObject(findResult, testObject);
                    WebUiCommonHelper.registerBrokenTestObject(findResult, testObject, RunConfiguration.getReportFolder());
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, testObject.getObjectId(), brokenTestObject.getProposedLocator()));
                    KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
                    return findResult.getElements();
                }
                catch (Exception exception) {
                    SelfHealingController.logWarning(exception.getMessage(), exception);
                }
            }
        }
        catch (Exception exception) {
            SelfHealingController.logWarning(exception.getMessage(), exception);
        }
        if (defaultException != null && !(defaultException instanceof NoSuchElementException)) {
            throw defaultException;
        }
        return Collections.emptyList();
    }

    private static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject testObject) {
        return WebUiCommonHelper.registerBrokenTestObject(findResult, testObject, SelfHealingController.getSelfHealingFolderPath());
    }

    private static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject brokenTestObject, String dataFolder) {
        String projectDir;
        List<WebElement> foundElements = findResult.getElements();
        WebElement foundElement = foundElements.get(0);
        SelectorMethod recoveryMethod = findResult.getLocatorMethod();
        SelectorMethod proposedMethod = recoveryMethod == SelectorMethod.IMAGE ? SelectorMethod.XPATH : recoveryMethod;
        String proposedLocator = recoveryMethod == SelectorMethod.IMAGE ? WebUiCommonHelper.generateNewXPath(foundElement) : findResult.getLocator();
        String elementScreenshot = findResult.getScreenshot();
        if (StringUtils.isBlank((CharSequence)elementScreenshot)) {
            WebDriver webDriver = DriverFactory.getWebDriver();
            elementScreenshot = SelfHealingController.takeScreenShot(webDriver, foundElement, brokenTestObject, recoveryMethod.name());
            findResult.setScreenshot(elementScreenshot);
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot)) {
            try {
                String screenshotRelativePath = SelfHealingController.getRelativePathToSelfHealindDir(elementScreenshot);
                String destScreenshotPath = FilenameUtils.concat((String)dataFolder, (String)screenshotRelativePath);
                File destScreenshot = new File(destScreenshotPath);
                if (!destScreenshot.exists()) {
                    FileUtils.copyFile((File)new File(elementScreenshot), (File)destScreenshot);
                }
                elementScreenshot = destScreenshotPath;
            }
            catch (IOException exception) {
                SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_SAVE_SCREENSHOT, dataFolder, exception.getMessage()), exception);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot) && FileUtil.isInBaseFolder(elementScreenshot, projectDir = RunConfiguration.getProjectDir())) {
            elementScreenshot = FileUtil.getRelativePath(elementScreenshot, projectDir);
        }
        return SelfHealingController.registerBrokenTestObject(brokenTestObject, proposedLocator, proposedMethod, recoveryMethod, elementScreenshot, dataFolder);
    }

    private static List<WebElement> findElementsByDefault(TestObject testObject, int timeout) throws Exception {
        return WebUiCommonHelper.findElementsBySelectedMethod(testObject, timeout).getElements();
    }

    private static FindElementsResult findElementsBySelectedMethod(TestObject testObject, int timeout) throws Exception {
        return WebUiCommonHelper.findElementsBySelectedMethod(testObject, timeout, testObject.getSelectorMethod());
    }

    private static FindElementsResult findElementsBySelectedMethod(TestObject testObject, int timeout, SelectorMethod method) throws Exception {
        return WebUiCommonHelper.findElementsBySelectedMethod(testObject, timeout, method, false);
    }

    private static FindElementsResult findElementsBySelectedMethod(TestObject testObject, int timeout, SelectorMethod method, boolean useSmartXPath) throws Exception {
        if (WebUiCommonHelper.isElementInsideShadowDOM(testObject) && method != SelectorMethod.SMART_LOCATOR) {
            testObject.setSelectorMethod(SelectorMethod.CSS);
            return WebUiCommonHelper.findElementsInsideShadowDOM(testObject, timeout);
        }
        switch (method) {
            case BASIC: {
                return WebUiCommonHelper.findElementByNormalMethods(testObject, method, timeout);
            }
            case CSS: {
                return WebUiCommonHelper.findElementByNormalMethods(testObject, method, timeout);
            }
            case XPATH: {
                return useSmartXPath ? WebUiCommonHelper.findWebElementsWithSmartXPath(testObject, timeout) : WebUiCommonHelper.findElementByNormalMethods(testObject, method, timeout);
            }
            case IMAGE: {
                return WebUiCommonHelper.findElementsByImage(testObject, timeout);
            }
            case SMART_LOCATOR: {
                if (WebUiCommonHelper.ableExecuteWithSmartLocator()) {
                    return WebUiCommonHelper.findElementBySmartLocator(testObject, timeout);
                }
                return WebUiCommonHelper.findElementByNormalMethods(testObject, SelectorMethod.XPATH, timeout);
            }
        }
        return WebUiCommonHelper.findElementByNormalMethods(testObject, SelectorMethod.XPATH, timeout);
    }

    private static FindElementsResult findElementsInsideShadowDOM(TestObject testObject, int timeout) throws Exception {
        String cssLocator = CssLocatorBuilder.buildCssSelectorLocator(testObject);
        List<Object> foundElements = Collections.emptyList();
        if (!WebUiCommonHelper.isElementInsideShadowDOM(testObject)) {
            return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
        }
        WebDriver webDriver = DriverFactory.getWebDriver();
        boolean isSwitchToParentFrame = false;
        TestObject parentObject = testObject.getParentObject();
        WebElement shadowRootElement = null;
        if (cssLocator == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_EXC_WEB_ELEMENT_W_ID_DOES_NOT_HAVE_SATISFY_PROP, testObject.getObjectId()));
        }
        logger.logDebug(MessageFormat.format(CoreWebuiMessageConstants.MSG_INFO_WEB_ELEMENT_HAVE_PARENT_SHADOW_ROOT, testObject.getObjectId(), testObject.getParentObject().getObjectId()));
        long startTime = System.currentTimeMillis();
        do {
            try {
                isSwitchToParentFrame = WebUiCommonHelper.switchToParentFrame(parentObject);
                shadowRootElement = WebUiCommonHelper.findWebElement(parentObject, timeout);
            }
            catch (WebElementNotFoundException webElementNotFoundException) {
                return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
            }
            if (shadowRootElement == null) {
                return FindElementsResult.from(cssLocator, SelectorMethod.CSS);
            }
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID, testObject.getObjectId(), cssLocator, timeout));
            try {
                foundElements = WebUiCommonHelper.doFindElementsInsideShadowDom(testObject, timeout, webDriver, cssLocator, parentObject, shadowRootElement);
                if (foundElements == null || foundElements.isEmpty()) {
                    logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_CANNOT_FIND_WEB_ELEMENT_BY_LOCATOR, cssLocator));
                    continue;
                }
                if (!isSwitchToParentFrame) break;
                WebUiCommonHelper.switchToDefaultContent();
                break;
            }
            catch (WebElementNotFoundException webElementNotFoundException) {
            }
            finally {
                if (isSwitchToParentFrame) {
                    WebUiCommonHelper.switchToDefaultContent();
                }
            }
        } while ((System.currentTimeMillis() - startTime) / 1000L <= (long)timeout);
        return FindElementsResult.from(foundElements, cssLocator, SelectorMethod.CSS, "");
    }

    private static List<WebElement> doFindElementsInsideShadowDom(TestObject testObject, int timeOut, WebDriver webDriver, String cssLocator, TestObject parentObject, WebElement shadowRootElement) throws WebElementNotFoundException {
        String filteredCssSelector = StringUtils.defaultString((String)cssLocator).replace("'", "\\'");
        List webElements = (List)((JavascriptExecutor)webDriver).executeScript("return arguments[0].shadowRoot.querySelectorAll('" + filteredCssSelector + "');", new Object[]{shadowRootElement});
        if (webElements != null && webElements.size() > 0) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, webElements.size(), testObject.getObjectId(), cssLocator, timeOut));
        }
        return webElements;
    }

    private static FindElementsResult findElementByNormalMethods(TestObject testObject, SelectorMethod locatorMethod, int timeout) {
        WebDriver webDriver = DriverFactory.getWebDriver();
        By defaultLocator = WebUiCommonHelper.buildLocator(testObject, locatorMethod);
        if (defaultLocator == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_EXC_WEB_ELEMENT_W_ID_DOES_NOT_HAVE_SATISFY_PROP, testObject.getObjectId()));
        }
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID, testObject.getObjectId(), defaultLocator.toString(), timeout));
        List foundElements = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        do {
            try {
                foundElements = webDriver.findElements(defaultLocator);
                if (foundElements == null || foundElements.isEmpty()) continue;
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, foundElements.size(), testObject.getObjectId(), defaultLocator.toString(), timeout));
                break;
            }
            catch (NoSuchElementException noSuchElementException) {}
        } while ((System.currentTimeMillis() - startTime) / 1000L <= (long)timeout);
        if (foundElements == null || foundElements.isEmpty()) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_CANNOT_FIND_WEB_ELEMENT_BY_LOCATOR, defaultLocator.toString()));
            return FindElementsResult.from(WebUiCommonHelper.getSelectorValue(testObject, locatorMethod), locatorMethod);
        }
        return FindElementsResult.from(foundElements, WebUiCommonHelper.getSelectorValue(testObject, locatorMethod), locatorMethod);
    }

    private static FindElementsResult findElementBySmartLocator(TestObject testObject, int timeout) {
        WebDriver webDriver = DriverFactory.getWebDriver();
        List<WebElement> foundElements = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        String smartLocator = "";
        do {
            try {
                smartLocator = (String)testObject.getSmartSelectorCollection().get(SelectorMethod.SMART_LOCATOR);
                if (StringUtils.isBlank((CharSequence)smartLocator)) break;
                JavascriptExecutor js = (JavascriptExecutor)webDriver;
                foundElements = new ArrayList<WebElement>();
                String jsLocator = String.format("return katalonSmartLocator.find_element_by_smart_locator(`%s`)", smartLocator);
                WebElement element = (WebElement)js.executeScript(jsLocator, new Object[0]);
                if (element != null) {
                    foundElements.add(element);
                }
                if (foundElements == null || foundElements.isEmpty()) continue;
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, foundElements.size(), testObject.getObjectId(), smartLocator, timeout));
                break;
            }
            catch (Exception exception) {}
        } while ((System.currentTimeMillis() - startTime) / 1000L <= (long)timeout);
        FindElementsResult result = FindElementsResult.from(foundElements, smartLocator, SelectorMethod.SMART_LOCATOR);
        return result;
    }

    private static FindElementsResult findWebElementsWithSmartXPath(TestObject testObject, int timeout) {
        if (WebUiCommonHelper.isElementInsideShadowDOM(testObject)) {
            return FindElementsResult.from(SelectorMethod.XPATH);
        }
        WebDriver webDriver = DriverFactory.getWebDriver();
        SelfHealingController.setLogger(logger);
        List allXPaths = testObject.getXpaths();
        TestObjectXpath selectedXPath = null;
        List foundElements = null;
        String screenshotPath = "";
        boolean hasFound = false;
        long startTime = System.currentTimeMillis();
        do {
            int i = 0;
            while (i < allXPaths.size()) {
                selectedXPath = (TestObjectXpath)allXPaths.get(i);
                String xpathValue = selectedXPath.getValue();
                if (!StringUtils.isBlank((CharSequence)xpathValue)) {
                    By bySelectedXPath = By.xpath((String)selectedXPath.getValue());
                    try {
                        foundElements = webDriver.findElements(bySelectedXPath);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    if (foundElements != null && !foundElements.isEmpty()) {
                        SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_WEB_ELEMENT_WITH_THIS_SMART_XPATH, selectedXPath.getValue()));
                        String screenshotName = selectedXPath.getName().split(":")[1];
                        screenshotPath = SelfHealingController.takeScreenShot(webDriver, (WebElement)foundElements.get(0), testObject, screenshotName);
                        break;
                    }
                    SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_FIND_WEB_ELEMENT_WITH_THIS_SMART_XPATH, xpathValue));
                }
                ++i;
            }
            boolean bl = hasFound = foundElements != null && !foundElements.isEmpty();
        } while (!hasFound && (System.currentTimeMillis() - startTime) / 1000L <= (long)timeout);
        if (selectedXPath == null) {
            SelfHealingController.logInfo(StringConstants.KW_LOG_INFO_COULD_NOT_FIND_ANY_WEB_ELEMENT_WITH_SMART_XPATHS);
            return FindElementsResult.from(SelectorMethod.XPATH);
        }
        return FindElementsResult.from(foundElements, selectedXPath.getValue(), SelectorMethod.XPATH, screenshotPath);
    }

    private static FindElementsResult findElementsByImage(TestObject testObject, int timeout) {
        WebDriver webDriver = DriverFactory.getWebDriver();
        String screenshot = (String)testObject.getSelectorCollection().get(SelectorMethod.IMAGE);
        if (StringUtils.isBlank((CharSequence)screenshot)) {
            screenshot = testObject.getProperties().stream().filter(prop -> prop.getName().equals("screenshot")).findAny().map(screenshotProp -> screenshotProp.getValue()).orElse("");
        }
        if (StringUtils.isBlank((CharSequence)screenshot)) {
            return FindElementsResult.from(SelectorMethod.IMAGE);
        }
        List<WebElement> foundElements = ImageLocatorController.findElementByScreenShot(webDriver, screenshot, timeout);
        return FindElementsResult.from(foundElements, screenshot, SelectorMethod.IMAGE);
    }

    private static String generateNewXPath(WebElement element) {
        WebDriver webDriver = DriverFactory.getWebDriver();
        Map<String, List<String>> generatedXPaths = WebUICommonScripts.generateXPaths(webDriver, element);
        List xpathsPriority = RunConfiguration.getXPathsPriority();
        for (Pair xpath : xpathsPriority) {
            if (!generatedXPaths.containsKey(xpath.getLeft()) || generatedXPaths.get(xpath.getLeft()).isEmpty()) continue;
            return generatedXPaths.get(xpath.getLeft()).get(0);
        }
        return WebUICommonScripts.generateXPath(webDriver, element);
    }

    public static String saveWebElementScreenshotAndResize(WebDriver driver, WebElement ele, String name, String path) throws IOException {
        return ImageLocatorController.saveWebElementScreenshot(driver, ele, name, path);
    }

    public static String saveWebElementScreenshot(WebDriver driver, WebElement element, String name, String path) throws IOException {
        File screenshot = (File)element.getScreenshotAs(OutputType.FILE);
        BufferedImage screenshotBeforeResized = ImageIO.read(screenshot);
        int eleWidth = element.getRect().getWidth();
        int eleHeight = element.getRect().getHeight();
        BufferedImage screenshotAfterResized = WebUiCommonHelper.resize(screenshotBeforeResized, eleHeight, eleWidth);
        ImageIO.write((RenderedImage)screenshotAfterResized, "png", screenshot);
        Object screenshotPath = path;
        screenshotPath = ((String)screenshotPath).replaceAll("\\\\", "/");
        screenshotPath = ((String)screenshotPath).endsWith("/") ? (String)screenshotPath + name : (String)screenshotPath + "/" + name;
        if (!((String)screenshotPath).endsWith(".png")) {
            screenshotPath = (String)screenshotPath + ".png";
        }
        File fileScreenshot = new File((String)screenshotPath);
        FileUtils.copyFile((File)screenshot, (File)fileScreenshot);
        screenshot.deleteOnExit();
        return screenshotPath;
    }

    private static BufferedImage resize(BufferedImage img, int height, int width) {
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }

    public static double getDevicePixelRatio(WebDriver driver) {
        JavascriptExecutor js = (JavascriptExecutor)driver;
        Object executeScriptValue = js.executeScript("return window.devicePixelRatio;", new Object[0]);
        double devicePixelRatio = 1.0;
        try {
            if (executeScriptValue != null) {
                devicePixelRatio = Double.valueOf(executeScriptValue.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            devicePixelRatio = 1.0;
        }
        return devicePixelRatio;
    }

    private static List<WebElement> findWebElementsUsingHeuristicMethod(WebDriver webDriver, boolean objectInsideShadowDom, TestObject testObject) {
        if (objectInsideShadowDom) {
            return Collections.emptyList();
        }
        By unionLocator = WebUiCommonHelper.buildUnionXpath(testObject);
        List webElements = webDriver.findElements(unionLocator);
        if (webElements == null || webElements.isEmpty()) {
            return Collections.emptyList();
        }
        WebElement bestMatchElement = WebUiCommonHelper.findBestMatchElement(webDriver, testObject, webElements);
        return Arrays.asList(bestMatchElement);
    }

    private static WebElement findBestMatchElement(WebDriver webDriver, TestObject testObject, List<WebElement> webElements) {
        Map matchesLookup = webElements.stream().collect(Collectors.toMap(Function.identity(), webElement -> WebUiCommonHelper.getSatisfiedConditions(testObject, webElement)));
        List<Map.Entry<String, By>> xpaths = WebUiCommonHelper.buildXpathsFromXpathBasedConditions(testObject);
        for (Map.Entry<String, By> entry : xpaths) {
            String propertyName = entry.getKey();
            By locator = entry.getValue();
            List webElementsMatchingTextCondition = webDriver.findElements(locator);
            for (WebElement webElement2 : webElementsMatchingTextCondition) {
                List matches = matchesLookup.get(webElement2);
                if (matches == null) continue;
                matches.add(propertyName);
            }
        }
        Map.Entry bestMatchEntry = Collections.max(matchesLookup.entrySet(), (left, right) -> ((List)left.getValue()).size() - ((List)right.getValue()).size());
        WebElement bestMatchElement = (WebElement)bestMatchEntry.getKey();
        List matchingAttributes = bestMatchEntry.getValue();
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_USING_HEURISTIC_METHOD, matchingAttributes));
        return bestMatchElement;
    }

    private static List<String> getSatisfiedConditions(TestObject testObject, WebElement webElement) {
        List expectedProperties = testObject.getProperties();
        ArrayList<String> satisfiedConditions = new ArrayList<String>();
        for (TestObjectProperty expectedProperty : expectedProperties) {
            String propertyName = expectedProperty.getName();
            XPathBuilder.PropertyType propertyType = XPathBuilder.PropertyType.nameOf((String)propertyName);
            if (!(switch (propertyType) {
                case XPathBuilder.PropertyType.TAG -> {
                    String expectedTag = expectedProperty.getValue();
                    String actualTag = webElement.getTagName();
                    yield expectedTag.equalsIgnoreCase(actualTag);
                }
                case XPathBuilder.PropertyType.ATTRIBUTE -> {
                    String expectedPropertyValue = expectedProperty.getValue();
                    String actualPropertyValue = webElement.getAttribute(propertyName);
                    switch (expectedProperty.getCondition()) {
                        case EQUALS: {
                            yield expectedPropertyValue.equals(actualPropertyValue);
                        }
                        case NOT_EQUAL: {
                            yield !expectedPropertyValue.equals(actualPropertyValue);
                        }
                        case CONTAINS: {
                            yield expectedPropertyValue.contains(actualPropertyValue);
                        }
                        case NOT_CONTAIN: {
                            yield !expectedPropertyValue.contains(actualPropertyValue);
                        }
                        case STARTS_WITH: {
                            yield expectedPropertyValue.startsWith(actualPropertyValue);
                        }
                        case ENDS_WITH: {
                            yield expectedPropertyValue.endsWith(actualPropertyValue);
                        }
                        case MATCHES_REGEX: {
                            yield expectedPropertyValue.matches(actualPropertyValue);
                        }
                        case NOT_MATCH_REGEX: {
                            yield !expectedPropertyValue.matches(actualPropertyValue);
                        }
                    }
                    yield false;
                }
                default -> false;
            })) continue;
            satisfiedConditions.add(propertyName);
        }
        return satisfiedConditions;
    }

    private static List<WebElement> doFindElementsDefault(TestObject testObject, int timeOut, WebDriver webDriver, By locator) throws WebElementNotFoundException {
        List webElements = webDriver.findElements(locator);
        if (webElements != null && webElements.size() > 0) {
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID_SUCCESS, webElements.size(), testObject.getObjectId(), locator.toString(), timeOut));
        }
        return webElements;
    }

    public static WebElement findWebElement(TestObject testObject, int timeOut) throws Exception {
        WebElement cachedWebElement = testObject.getCachedWebElement();
        if (cachedWebElement != null) {
            return cachedWebElement;
        }
        List<WebElement> elements = WebUiCommonHelper.findWebElements(testObject, timeOut);
        if (elements != null && elements.size() > 0) {
            return elements.get(0);
        }
        String locator = "";
        locator = testObject.getSelectorMethod() == SelectorMethod.SMART_LOCATOR && !WebUiCommonHelper.ableExecuteWithSmartLocator() ? WebUiCommonHelper.getSelectorValue(testObject, SelectorMethod.XPATH) : WebUiCommonHelper.getSelectorValue(testObject);
        throw new WebElementNotFoundException(testObject.getObjectId(), locator);
    }

    public static void switchToDefaultContent() throws StepFailedException {
        try {
            if (DriverFactory.getAlert() != null) {
                logger.logWarning(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_ALERT_ON_PAGE);
                return;
            }
            logger.logDebug(StringConstants.KW_LOG_INFO_SWITCHING_TO_DEFAULT_CONTENT);
            DriverFactory.getWebDriver().switchTo().defaultContent();
        }
        catch (NoSuchWindowException noSuchWindowException) {
        }
        catch (WebDriverException e) {
            logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_OF_X, ExceptionsUtil.getMessageForThrowable((Throwable)e)), null, (Throwable)e);
        }
    }

    public static void switchToDefaultContent(WebDriver driver) throws StepFailedException {
        try {
            if (DriverFactory.getAlert(driver) != null) {
                logger.logWarning(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_ALERT_ON_PAGE);
                return;
            }
            logger.logDebug(StringConstants.KW_LOG_INFO_SWITCHING_TO_DEFAULT_CONTENT);
            driver.switchTo().defaultContent();
        }
        catch (NoSuchWindowException noSuchWindowException) {
        }
        catch (WebDriverException e) {
            logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_WARNING_SWITCHING_TO_DEFAULT_CONTENT_FAILED_BC_OF_X, ExceptionsUtil.getMessageForThrowable((Throwable)e)), null, (Throwable)e);
        }
    }

    public static boolean switchToParentFrame(TestObject testObject, int timeOut) throws Exception {
        return WebUiCommonHelper.switchToParentFrame(DriverFactory.getWebDriver(), testObject, timeOut);
    }

    public static boolean switchToParentFrame(WebDriver driver, TestObject testObject, int timeOut) throws Exception {
        TestObject parentObject = testObject != null ? testObject.getParentObject() : null;
        boolean isParentShadowRoot = testObject.isParentObjectShadowRoot();
        ArrayList<TestObject> parentObjects = new ArrayList<TestObject>();
        while (parentObject != null) {
            if (!isParentShadowRoot) {
                parentObjects.add(parentObject);
            }
            isParentShadowRoot = parentObject.isParentObjectShadowRoot();
            parentObject = parentObject.getParentObject();
        }
        if (parentObjects.size() <= 0) {
            return false;
        }
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_OBJ_X_HAS_PARENT_FRAME, testObject.getObjectId()));
        int i = parentObjects.size() - 1;
        while (i >= 0) {
            TestObject currentParentObject = (TestObject)parentObjects.get(i);
            if (!WebUiCommonHelper.switchToParentFrame(timeOut, driver, currentParentObject)) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static boolean switchToParentFrame(int timeOut, WebDriver webDriver, TestObject currentParentObject) throws Exception {
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHING_TO_IFRAME_X, currentParentObject.getObjectId()));
        WebElement frameElement = WebUiCommonHelper.findWebElement(currentParentObject, timeOut);
        if (frameElement == null) {
            return false;
        }
        webDriver.switchTo().frame(frameElement);
        logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SWITCHED_TO_IFRAME_X, currentParentObject.getObjectId()));
        return true;
    }

    public static boolean switchToParentFrame(TestObject testObject) throws Exception {
        return WebUiCommonHelper.switchToParentFrame(testObject, RunConfiguration.getElementTimeoutForWeb());
    }

    public static boolean switchToParentFrame(WebDriver driver, TestObject testObject) throws Exception {
        return WebUiCommonHelper.switchToParentFrame(driver, testObject, RunConfiguration.getElementTimeoutForWeb());
    }

    private static boolean isElementInsideShadowDOM(TestObject testObject) {
        return testObject.getParentObject() != null && testObject.isParentObjectShadowRoot();
    }

    public static boolean ableExecuteWithSmartLocator() {
        if (!WebUiCommonHelper.smartLocatorEnabled()) {
            return false;
        }
        WebDriver driver = DriverFactory.getWebDriver();
        boolean supportedBiDi = driver instanceof HasBiDi;
        return supportedBiDi;
    }

    public static boolean ableExecuteWithSmartLocator(WebDriver driver) {
        if (!WebUiCommonHelper.smartLocatorEnabled()) {
            return false;
        }
        boolean supportedBiDi = driver instanceof HasBiDi;
        return supportedBiDi;
    }

    public static boolean smartWaitEnabled() {
        boolean configurationEnabled;
        boolean localSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("localSmartWaitEnabled")).orElse(false);
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        boolean bl = configurationEnabled = localSmartWaitEnabled || globalSmartWaitEnabled;
        if (!configurationEnabled) {
            return false;
        }
        try {
            ISmartExtensionWebDriver smartDriver;
            boolean isSmartDriver;
            WebDriver driver = DriverFactory.getWebDriver();
            boolean bl2 = isSmartDriver = driver instanceof ISmartExtensionWebDriver && (smartDriver = (ISmartExtensionWebDriver)driver).isSmartWaitInjected();
            return configurationEnabled && isSmartDriver;
        }
        catch (Exception exception) {
            return configurationEnabled;
        }
    }

    public static boolean smartLocatorEnabled() {
        boolean defaultSmartLocatorSettingEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("smartLocatorSettingDefaultEnabled")).orElse(false);
        boolean allowExecuteWithSmartLocator = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("smartLocatorEnabled")).orElse(false);
        return allowExecuteWithSmartLocator && defaultSmartLocatorSettingEnabled;
    }

    public static void setViewPortSize(WebDriver driver, int width, int height) throws InterruptedException {
        WebUiCommonHelper.initViewPort(driver, width, height, false);
        if (!WebUiCommonHelper.isValidViewportSize(driver, width, height)) {
            int actualWidth = WebUiCommonHelper.getViewportWidth(driver);
            int actualHeight = WebUiCommonHelper.getViewportHeight(driver);
            logger.logInfo(MessageFormat.format("Viewport size mismatch ({0}x{1}). Trying to set it again.", actualWidth, actualHeight));
            Thread.sleep(300L);
            WebUiCommonHelper.initViewPort(driver, width, height, false);
            if (!WebUiCommonHelper.isValidViewportSize(driver, width, height)) {
                WebUiCommonHelper.initViewPort(driver, width, height, true);
            }
        }
    }

    private static WebDriver initViewPort(WebDriver driver, int width, int height, boolean isAdjust) {
        Dimension browserSize = driver.manage().window().getSize();
        int currentBrowserWidth = browserSize.getWidth();
        int currentBrowserHeight = browserSize.getHeight();
        int currentViewportWidth = WebUiCommonHelper.getViewportWidth(driver);
        int currentViewportHeight = WebUiCommonHelper.getViewportHeight(driver);
        if (currentViewportWidth == width && currentViewportHeight == height) {
            return driver;
        }
        int gapX = currentBrowserWidth - currentViewportWidth;
        int gapY = currentBrowserHeight - currentViewportHeight;
        int adjustX = isAdjust ? width - currentViewportWidth : 0;
        int adjustY = isAdjust ? height - currentViewportHeight : 0;
        int newBrowserWidth = width + gapX + adjustX;
        int newBrowserHeight = height + gapY + adjustY;
        boolean needToChangeWidth = currentViewportWidth != width;
        boolean needToChangeHeight = currentViewportHeight != height;
        int finalBrowserWidth = needToChangeWidth ? newBrowserWidth : currentBrowserWidth;
        int finalBrowserHeight = needToChangeHeight ? newBrowserHeight : currentBrowserHeight;
        driver.manage().window().setSize(new Dimension(finalBrowserWidth, finalBrowserHeight));
        return driver;
    }

    public static boolean isValidViewportSize(WebDriver driver, int width, int height) {
        int actualViewportWidth = WebUiCommonHelper.getViewportWidth(driver);
        int actualViewportHeight = WebUiCommonHelper.getViewportHeight(driver);
        boolean isValidViewportSize = actualViewportWidth == width && actualViewportHeight == height;
        return isValidViewportSize;
    }

    public static String getAttributeValue(WebElement element, String attributeName) {
        return element.getAttribute(attributeName);
    }
}

