/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.model;

import com.kms.katalon.core.keyword.internal.KeywordExecutor;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.model.FindElementWithTimeoutParams;
import com.kms.katalon.core.webui.model.SeleniumActionRetryController;
import com.kms.katalon.core.webui.model.SeleniumElementFinder;
import com.kms.katalon.core.webui.model.WebUiElementFinder;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class WebUiElementFinderWithTimeout
implements SeleniumElementFinder<FindElementWithTimeoutParams> {
    private WebUiElementFinder basicElementFinder = new WebUiElementFinder();
    private KeywordLogger logger = KeywordLogger.getInstance(WebUiElementFinderWithTimeout.class);

    @Override
    public WebElement findElement(FindElementWithTimeoutParams params) throws Exception {
        KeywordExecutor.setCurrentKeywordTimeout((long)params.getTimeoutInMillis());
        if (params.getTimeoutInMillis() <= 0L) {
            return this.basicFindElement(params);
        }
        return new SeleniumActionRetryController().performAction(retryContext -> this.basicFindElement(params), 0L, retryContext -> retryContext.getElapsedTime() <= params.getTimeoutInMillis());
    }

    @Override
    public List<WebElement> findElements(FindElementWithTimeoutParams params) throws Exception {
        TestObject testObject = params.getTestObject();
        if (params.getTimeoutInMillis() <= 0L) {
            return this.basicFindElements(params);
        }
        return new SeleniumActionRetryController().performAction(retryContext -> {
            if (retryContext.retryCount == 0) {
                this.logger.logDebug(MessageFormat.format("Finding web element with id: ''{0}'' located by ''{1}''", testObject.getObjectId(), WebUiCommonHelper.buildLocator(testObject, testObject.getSelectorMethod())));
            }
            return this.basicFindElements(params);
        }, 0L, retryContext -> retryContext.getElapsedTime() <= params.getTimeoutInMillis());
    }

    private WebElement basicFindElement(FindElementWithTimeoutParams params) throws Exception {
        WebElement element = this.basicElementFinder.findElement(params);
        if (element == null) {
            throw new NoSuchElementException("No elements found for TestObject: " + params.getTestObject().getObjectId());
        }
        return element;
    }

    private List<WebElement> basicFindElements(FindElementWithTimeoutParams params) throws Exception {
        List<WebElement> elements = this.basicElementFinder.findElements(params);
        if (CollectionUtils.isEmpty(elements)) {
            throw new NoSuchElementException("No elements found for TestObject: " + params.getTestObject().getObjectId());
        }
        return elements;
    }
}

