/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    public static List<String> wrap(String str, FontMetrics fm, int maxWidth) {
        List<String> lines = StringUtils.splitIntoLines(str);
        if (lines.isEmpty()) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            StringUtils.wrapLineInto(iter.next(), strings, fm, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, FontMetrics fm, int maxWidth) {
        int width;
        int len = line.length();
        while (len > 0 && (width = fm.stringWidth(line)) > maxWidth) {
            int pos;
            int guess = len * maxWidth / width;
            String before = line.substring(0, guess).trim();
            if ((width = fm.stringWidth(before)) > maxWidth) {
                pos = StringUtils.findBreakBefore(line, guess);
            } else {
                pos = StringUtils.findBreakAfter(line, guess);
                if (pos != -1 && fm.stringWidth(before = line.substring(0, pos).trim()) > maxWidth) {
                    pos = StringUtils.findBreakBefore(line, guess);
                }
            }
            if (pos == -1) {
                pos = guess;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static int findBreakBefore(String line, int start) {
        int i = start;
        while (i >= 0) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBreakAfter(String line, int start) {
        int len = line.length();
        int i = start;
        while (i < len) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int len = str.length();
        if (len == 0) {
            strings.add("");
            return strings;
        }
        int lineStart = 0;
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\r') {
                int newlineLength = 1;
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    newlineLength = 2;
                }
                strings.add(str.substring(lineStart, i));
                lineStart = i + newlineLength;
                if (newlineLength == 2) {
                    ++i;
                }
            } else if (c == '\n') {
                strings.add(str.substring(lineStart, i));
                lineStart = i + 1;
            }
            ++i;
        }
        if (lineStart < len) {
            strings.add(str.substring(lineStart));
        }
        return strings;
    }

    public static Graphics2D drawSplittedText(List<String> splittedText, FontMetrics fontMetrics, Graphics2D graphics, int startX, int startY) {
        int drawingX = startX;
        int drawingY = startY;
        for (String line : splittedText) {
            graphics.drawString(line, drawingX, drawingY);
            drawingY += fontMetrics.getHeight() + fontMetrics.getAscent();
        }
        return graphics;
    }
}

