/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.appium.util.AppiumDriverUtil;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.selenium.remote.http.ConfiguredHttpClientFactory;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.selenium.constant.SeleniumConstants;
import com.kms.katalon.selenium.driver.CRemoteWebDriver;
import com.kms.katalon.selenium.filter.SeleniumAcceptEncodingFilter;
import com.kms.katalon.selenium.filter.SeleniumBasicAuthorizationFilter;
import com.kms.katalon.selenium.filter.SeleniumCreateSessionPayloadFilter;
import com.kms.katalon.selenium.filter.SeleniumCreateSessionResponseFilter;
import com.kms.katalon.selenium.filter.SeleniumProxyBasicAuthorizationFilter;
import com.kms.katalon.selenium.filter.SeleniumResponseContentEncodingDecompressionFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;

public class WebDriverUtil {
    public static CommandExecutor createCommandExecutorWithRunningSession(String remoteServerUrl, String sessionId, String webSocketUrl) throws MalformedURLException {
        return WebDriverUtil.createCommandExecutorWithRunningSession(new URL(remoteServerUrl), sessionId, webSocketUrl);
    }

    public static CommandExecutor createCommandExecutorWithRunningSession(URL remoteServerUrl, final String sessionId, final String webSocketUrl) throws MalformedURLException {
        return new HttpCommandExecutor(remoteServerUrl){

            public Response execute(Command command) throws IOException {
                Response response = null;
                if (StringUtils.equals((CharSequence)"newSession", (CharSequence)command.getName())) {
                    response = new Response();
                    response.setSessionId(sessionId);
                    response.setState("success");
                    if (StringUtils.isBlank((CharSequence)webSocketUrl)) {
                        response.setValue(Collections.emptyMap());
                    } else {
                        response.setValue(Collections.singletonMap("webSocketUrl", webSocketUrl));
                    }
                    try {
                        Field commandCodec = null;
                        commandCodec = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("commandCodec");
                        commandCodec.setAccessible(true);
                        commandCodec.set((Object)this, new W3CHttpCommandCodec());
                        Field responseCodec = null;
                        responseCodec = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("responseCodec");
                        responseCodec.setAccessible(true);
                        responseCodec.set((Object)this, new W3CHttpResponseCodec());
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e, (String)"Exception while custom execute command");
                    }
                } else {
                    response = super.execute(command);
                }
                return response;
            }
        };
    }

    public static RemoteWebDriver createDriverFromRunningSession(String remoteServerUrl, String sessionId, String webSocketUrl) throws MalformedURLException {
        CommandExecutor executor = WebDriverUtil.createCommandExecutorWithRunningSession(remoteServerUrl, sessionId, webSocketUrl);
        if (StringUtils.isBlank((CharSequence)webSocketUrl)) {
            return new RemoteWebDriver(executor, (Capabilities)new MutableCapabilities());
        }
        return new CRemoteWebDriver(executor, (Capabilities)new MutableCapabilities(), 0);
    }

    public static HttpCommandExecutor getHttpCommandExecutorForRemoteDriver(URL remoteWebServerUrl, MutableCapabilities capabilities) throws URISyntaxException, IOException {
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        URL cleanRemoteWebServerUrl = AppiumDriverUtil.removeUserInfoPart((URL)remoteWebServerUrl);
        ConfiguredHttpClientFactory clientFactory = ConfiguredHttpClientFactory.of((ProxyInformation)proxyInfo, (URL)cleanRemoteWebServerUrl, (Capabilities)capabilities);
        ClientConfig clientConfig = ClientConfig.defaultConfig().readTimeout(Duration.ofSeconds(SeleniumConstants.DEFAULT_READ_TIMEOUT_SECONDS)).baseUrl(Objects.requireNonNull(cleanRemoteWebServerUrl)).withFilter(new SeleniumProxyBasicAuthorizationFilter(proxyInfo.getUsername(), proxyInfo.getPassword()).andThen((Filter)new SeleniumAcceptEncodingFilter()).andThen((Filter)new SeleniumResponseContentEncodingDecompressionFilter()).andThen((Filter)new SeleniumBasicAuthorizationFilter(remoteWebServerUrl)).andThen((Filter)new SeleniumCreateSessionPayloadFilter(capabilities)).andThen((Filter)new SeleniumCreateSessionResponseFilter()));
        return new HttpCommandExecutor(new HashMap(), clientConfig, (HttpClient.Factory)clientFactory);
    }

    public static String getBrowserName(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            RemoteWebDriver remoteDriver = (RemoteWebDriver)driver;
            return remoteDriver.getCapabilities().getBrowserName();
        }
        return null;
    }
}

