/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.configuration;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.configuration.contributor.WebUIRunConfigurationContributor;
import com.kms.katalon.integration.kobiton.configuration.KobitonRunConfiguration;
import com.kms.katalon.integration.kobiton.constants.IntegrationKobitonMessages;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class KobitonRunConfigurationContributor
extends WebUIRunConfigurationContributor {
    private static final int PREFERRED_ORDER = 11;
    private KobitonDevice selectedDevice;

    public String getId() {
        return WebUIDriverType.KOBITON_WEB_DRIVER.toString();
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException {
        if (this.selectedDevice != null) {
            return this.getKobitonConfiguration(projectDir, null, this.selectedDevice);
        }
        return new KobitonRunConfiguration(projectDir);
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException, URISyntaxException, TestCloudException {
        IRunConfiguration runConfiguration = super.getRunConfiguration(projectDir, runConfigurationDescription);
        if (this.selectedDevice != null) {
            return this.getKobitonConfiguration(projectDir, runConfiguration, this.selectedDevice);
        }
        Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
        if (runConfigurationData == null) {
            return null;
        }
        String rawDeviceInfo = (String)runConfigurationData.get("kobitonDevice");
        KobitonDevice device = (KobitonDevice)JsonUtil.fromJson((String)rawDeviceInfo, KobitonDevice.class);
        return this.getKobitonConfiguration(projectDir, runConfiguration, device);
    }

    private IRunConfiguration getKobitonConfiguration(String projectDir, IRunConfiguration runConfiguration, KobitonDevice device) throws IOException {
        KobitonRunConfiguration kobitonRunConfiguration = runConfiguration != null ? (KobitonRunConfiguration)runConfiguration : new KobitonRunConfiguration(projectDir);
        kobitonRunConfiguration.setServerUrl(KobitonPreferencesProvider.getKobitonServerUrl());
        kobitonRunConfiguration.setApiKey(KobitonPreferencesProvider.getKobitonApiKey());
        kobitonRunConfiguration.setUserName(KobitonPreferencesProvider.getKobitonUserName());
        kobitonRunConfiguration.setKobitonDevice(device);
        return kobitonRunConfiguration;
    }

    public int getPreferredOrder() {
        return 11;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Arrays.asList(this.getKobitonTokenConsoleOpt(""), this.getKobitonUserNameConsoleOpt(""), this.getKobitonDeviceIdConsoleOpt(""));
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (consoleOption.getOption().equals("kobitonDeviceId")) {
            int kobitonDeviceId = Integer.valueOf(argumentValue);
            List<KobitonDevice> availableDevices = KobitonApiProvider.getKobitonFavoriteDevices(KobitonPreferencesProvider.getKobitonServerUrl(), KobitonPreferencesProvider.getKobitonToken());
            Optional<KobitonDevice> selectedDeviceOpt = availableDevices.stream().filter(device -> device.getId() == kobitonDeviceId).findAny();
            if (!selectedDeviceOpt.isPresent()) {
                throw new ExecutionException(MessageFormat.format(IntegrationKobitonMessages.MSG_ERR_KOBITON_DEVICE_NOT_FOUND, kobitonDeviceId));
            }
            this.selectedDevice = selectedDeviceOpt.get();
        } else if (consoleOption.getOption().equals("kobitonToken")) {
            ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton");
            if (consoleOption instanceof StringConsoleOption) {
                store.setValue("kobiton.authentication.token", argumentValue);
                String token = argumentValue.toString();
                String plainToken = Base64.decode((String)token);
                String[] parts = StringUtils.defaultString((String)plainToken).split(":");
                if (parts != null && parts.length == 2) {
                    String username = parts[0];
                    String apiKey = parts[1];
                    store.setValue("kobiton.apiKey", apiKey);
                    store.setValue("kobiton.authentication.username", username);
                }
            }
        } else {
            ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton");
            if (consoleOption instanceof StringConsoleOption) {
                store.setValue("kobiton.authentication.username", argumentValue);
            }
        }
    }

    public List<ConsoleOption<?>> getConsoleOptions(RunConfigurationDescription description) {
        KobitonDevice device = (KobitonDevice)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("kobitonDevice")), KobitonDevice.class);
        return Arrays.asList(this.getKobitonDeviceIdConsoleOpt(Integer.toString(device.getId())));
    }

    private ConsoleOption<?> getKobitonDeviceIdConsoleOpt(final String rawValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return "kobitonDeviceId";
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return rawValue;
            }
        };
    }

    private ConsoleOption<?> getKobitonTokenConsoleOpt(final String rawValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return "kobitonToken";
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return rawValue;
            }
        };
    }

    private ConsoleOption<?> getKobitonUserNameConsoleOpt(final String rawValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return "kobitonUserName";
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return rawValue;
            }
        };
    }
}

