/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.search;

import java.beans.Introspector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.eclipse.core.search.ISearchRequestor;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class SyntheticAccessorSearchRequestor {
    public void findSyntheticMatches(IJavaElement element, ISearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findSyntheticMatches(element, 2, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), requestor, monitor);
    }

    public void findSyntheticMatches(IJavaElement element, int limitTo, SearchParticipant[] participants, IJavaSearchScope scope, final ISearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (!(element instanceof IMember) || !GroovyNature.hasGroovyNature((IProject)element.getJavaProject().getProject())) {
            return;
        }
        SearchPattern pattern = this.createPattern(element, limitTo & 0xFFFFFFEF);
        if (pattern == null) {
            return;
        }
        final boolean checkFlags = element.getElementType() == 9 && element.getElementName().startsWith("set");
        new SearchEngine().search(pattern, participants, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() != 0 && ((IMember)match.getElement()).isBinary()) {
                    return;
                }
                if (!checkFlags || !Flags.isFinal((int)((IMember)match.getElement()).getFlags())) {
                    requestor.acceptMatch(match);
                }
            }
        }, monitor);
    }

    private SearchPattern createPattern(IJavaElement element, int limitTo) throws JavaModelException {
        IMember[] toSearch = new IMember[]{this.findSyntheticProperty(element), this.findSyntheticMethod(element, "is"), this.findSyntheticMethod(element, "get"), this.findSyntheticMethod(element, "set")};
        switch (limitTo & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                toSearch[3] = null;
                break;
            }
            case 5: {
                toSearch[2] = null;
                toSearch[1] = null;
            }
        }
        SearchPattern pattern = null;
        IMember[] iMemberArray = toSearch;
        int n = toSearch.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member != null) {
                SearchPattern newPattern = SearchPattern.createPattern((IJavaElement)member, (int)limitTo);
                pattern = pattern == null ? newPattern : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)newPattern);
            }
            ++n2;
        }
        return pattern;
    }

    private IMethod findSyntheticMethod(IJavaElement element, String prefix) throws JavaModelException {
        String[] stringArray;
        if (element.getElementType() != 8) {
            return null;
        }
        IField field = (IField)element;
        boolean isser = "is".equals(prefix);
        boolean setter = "set".equals(prefix);
        if (setter && Flags.isFinal((int)field.getFlags())) {
            return null;
        }
        if (isser && !field.getTypeSignature().equals("Z")) {
            return null;
        }
        String name = prefix + BeanUtils.capitalize((String)field.getElementName());
        if (!setter) {
            stringArray = CharOperation.NO_STRINGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = field.getTypeSignature();
        }
        String[] params = stringArray;
        IMethod method = ((IType)field.getParent()).getMethod(name, params);
        return method.exists() ? null : SyntheticAccessorSearchRequestor.syntheticMemberProxy(IMethod.class, (IMember)method, setter ? "V" : field.getTypeSignature());
    }

    private IField findSyntheticProperty(IJavaElement element) throws JavaModelException {
        int prefixLength;
        if (element.getElementType() != 9) {
            return null;
        }
        String name = element.getElementName();
        if (name.length() <= 2) {
            return null;
        }
        if (name.startsWith("is")) {
            prefixLength = 2;
        } else {
            if (name.length() == 3) {
                return null;
            }
            prefixLength = 3;
        }
        name = Introspector.decapitalize(name.substring(prefixLength));
        IField field = ((IType)element.getParent()).getField(name);
        return field.exists() ? null : SyntheticAccessorSearchRequestor.syntheticMemberProxy(IField.class, (IMember)field, "Z");
    }

    public static <T extends IMember> T syntheticMemberProxy(Class<T> face, final IMember delegate, final String signature) {
        return (T)((IMember)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{face}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getReturnType") || method.getName().equals("getTypeSignature")) {
                    return signature;
                }
                if (method.getName().equals("getTypeParameters")) {
                    return new ITypeParameter[0];
                }
                if (method.getName().equals("getFlags")) {
                    return 1;
                }
                if (method.getName().equals("exists")) {
                    return Boolean.TRUE;
                }
                try {
                    return method.invoke((Object)delegate, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        }));
    }
}

