/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.tools.Utilities;

public class MethodCallExpression
extends Expression
implements MethodCall {
    private Expression objectExpression;
    private Expression method;
    private Expression arguments;
    private boolean implicitThis = true;
    private boolean spreadSafe;
    private boolean safe;
    private GenericsType[] genericsTypes;
    private MethodNode target;
    public static final Expression NO_ARGUMENTS = new TupleExpression(){

        public List<Expression> getExpressions() {
            return Collections.unmodifiableList(super.getExpressions());
        }

        public TupleExpression addExpression(Expression e) {
            throw new UnsupportedOperationException();
        }
    };

    public MethodCallExpression(Expression objectExpression, String method, Expression arguments) {
        this(objectExpression, new ConstantExpression(method), arguments);
    }

    public MethodCallExpression(Expression objectExpression, Expression method, Expression arguments) {
        this.setMethod(method);
        this.setArguments(arguments);
        this.setObjectExpression(objectExpression);
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        MethodCallExpression answer = new MethodCallExpression(transformer.transform(this.objectExpression), transformer.transform(this.method), transformer.transform(this.arguments));
        answer.setSafe(this.safe);
        answer.setSpreadSafe(this.spreadSafe);
        answer.setImplicitThis(this.implicitThis);
        answer.setGenericsTypes(this.genericsTypes);
        answer.setSourcePosition((ASTNode)((Object)this));
        answer.setMethodTarget(this.target);
        answer.copyNodeMetaData((ASTNode)((Object)this));
        return answer;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public void setArguments(Expression arguments) {
        if (!(arguments instanceof TupleExpression)) {
            this.arguments = new TupleExpression(arguments);
            this.arguments.setSourcePosition((ASTNode)arguments);
        } else {
            this.arguments = arguments;
        }
    }

    public Expression getMethod() {
        return this.method;
    }

    public void setMethod(Expression method) {
        this.method = method;
    }

    public String getMethodAsString() {
        return this.method instanceof ConstantExpression ? this.method.getText() : null;
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public void setObjectExpression(Expression objectExpression) {
        this.objectExpression = objectExpression;
    }

    public ASTNode getReceiver() {
        return this.getObjectExpression();
    }

    public String getText() {
        Expression method;
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getObjectExpression().getText());
        if (this.isSpreadSafe()) {
            builder.append('*');
        }
        if (this.isSafe()) {
            builder.append('?');
        }
        builder.append('.');
        if (this.isUsingGenerics()) {
            builder.append('<');
            boolean first = true;
            GenericsType[] genericsTypeArray = this.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType t = genericsTypeArray[n2];
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(t);
                ++n2;
            }
            builder.append('>');
        }
        if ((method = this.getMethod()) instanceof GStringExpression) {
            builder.append('\"').append(method.getText()).append('\"');
        } else if (!(method instanceof ConstantExpression)) {
            builder.append('(').append(method.getText()).append(')');
        } else {
            Object value = ((ConstantExpression)method).getValue();
            if (!(value instanceof String) || !Utilities.isJavaIdentifier((String)((String)value))) {
                builder.append("'").append(value).append("'");
            } else {
                builder.append((String)value);
            }
        }
        builder.append(this.getArguments().getText());
        return builder.toString();
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean isSpreadSafe() {
        return this.spreadSafe;
    }

    public void setSpreadSafe(boolean value) {
        this.spreadSafe = value;
    }

    public boolean isImplicitThis() {
        return this.implicitThis;
    }

    public void setImplicitThis(boolean implicitThis) {
        this.implicitThis = implicitThis;
    }

    public GenericsType[] getGenericsTypes() {
        return this.genericsTypes;
    }

    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.genericsTypes = genericsTypes;
    }

    public boolean isUsingGenerics() {
        return this.genericsTypes != null && this.genericsTypes.length > 0;
    }

    public MethodNode getMethodTarget() {
        return this.target;
    }

    public void setMethodTarget(MethodNode mn) {
        this.target = mn;
        if (mn != null) {
            this.setType(this.target.getReturnType());
        } else {
            this.setType(ClassHelper.OBJECT_TYPE);
        }
    }

    public void setSourcePosition(ASTNode node) {
        super.setSourcePosition(node);
        if (node instanceof MethodCall) {
            if (node instanceof MethodCallExpression) {
                this.method.setSourcePosition((ASTNode)((MethodCallExpression)((Object)node)).getMethod());
            } else if (node.getLineNumber() > 0) {
                this.method.setLineNumber(-1);
                this.method.setColumnNumber(-1);
                this.method.setLastLineNumber(-1);
                this.method.setLastColumnNumber(-1);
                this.method.setStart(((AnnotatedNode)node).getNameStart());
                this.method.setEnd(((AnnotatedNode)node).getNameEnd() + 1);
            }
            if (this.arguments != null) {
                this.arguments.setSourcePosition((ASTNode)((MethodCall)node).getArguments());
            }
        } else if (node instanceof PropertyExpression) {
            this.method.setSourcePosition((ASTNode)((PropertyExpression)node).getProperty());
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[object: " + this.objectExpression + " method: " + this.method + " arguments: " + this.arguments + "]";
    }
}

