/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.m12n;

import groovy.lang.GroovyRuntimeException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.runtime.m12n.SimpleExtensionModule;

public class MetaInfExtensionModule
extends SimpleExtensionModule {
    public static final String MODULE_INSTANCE_CLASSES_KEY = "extensionClasses";
    public static final String MODULE_STATIC_CLASSES_KEY = "staticExtensionClasses";
    private final List<Class> instanceExtensionClasses;
    private final List<Class> staticExtensionClasses;

    public List<Class> getInstanceMethodsExtensionClasses() {
        return this.instanceExtensionClasses;
    }

    public List<Class> getStaticMethodsExtensionClasses() {
        return this.staticExtensionClasses;
    }

    private MetaInfExtensionModule(String moduleName, String moduleVersion, List<Class> instanceExtensionClasses, List<Class> staticExtensionClasses) {
        super(moduleName, moduleVersion);
        this.instanceExtensionClasses = instanceExtensionClasses;
        this.staticExtensionClasses = staticExtensionClasses;
    }

    public static MetaInfExtensionModule newModule(Properties properties, ClassLoader loader) {
        String name = properties.getProperty("moduleName");
        if (name == null) {
            throw new GroovyRuntimeException("Module file hasn't set the module name using key [moduleName]");
        }
        String version = properties.getProperty("moduleVersion");
        if (version == null) {
            throw new GroovyRuntimeException("Module file hasn't set the module version using key [moduleVersion]");
        }
        String[] extensionClasses = properties.getProperty(MODULE_INSTANCE_CLASSES_KEY, "").trim().split("[,; ]");
        String[] staticExtensionClasses = properties.getProperty(MODULE_STATIC_CLASSES_KEY, "").trim().split("[,; ]");
        ArrayList<Class> instanceClasses = new ArrayList<Class>(extensionClasses.length);
        ArrayList<Class> staticClasses = new ArrayList<Class>(staticExtensionClasses.length);
        LinkedList<String> errors = new LinkedList<String>();
        MetaInfExtensionModule.loadExtensionClass(loader, extensionClasses, instanceClasses, errors);
        MetaInfExtensionModule.loadExtensionClass(loader, staticExtensionClasses, staticClasses, errors);
        if (!errors.isEmpty()) {
            GroovyLogManager.manager.log(TraceCategory.CLASSPATH, "Module [" + name + "] - Unable to load extension class" + (errors.size() > 1 ? "es" : "") + " " + errors);
        }
        return new MetaInfExtensionModule(name, version, instanceClasses, staticClasses);
    }

    private static void loadExtensionClass(ClassLoader loader, String[] extensionClasses, List<Class> instanceClasses, List<String> errors) {
        String[] stringArray = extensionClasses;
        int n = extensionClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionClass = stringArray[n2];
            try {
                extensionClass = extensionClass.trim();
                if (extensionClass.length() > 0) {
                    instanceClasses.add(loader.loadClass(extensionClass));
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError throwable) {
                errors.add(extensionClass);
            }
            ++n2;
        }
    }
}

