/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.NamedDelegate;
import groovy.transform.NamedParam;
import groovy.transform.NamedVariant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.VisibilityUtils;
import org.codehaus.groovy.antlr.PrimitiveHelper;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class NamedVariantASTTransformation
extends AbstractASTTransformation {
    private static final ClassNode NAMED_VARIANT_TYPE = ClassHelper.make(NamedVariant.class);
    private static final String NAMED_VARIANT = "@" + NAMED_VARIANT_TYPE.getNameWithoutPackage();
    private static final ClassNode NAMED_PARAM_TYPE = ClassHelper.makeWithoutCaching(NamedParam.class, false);
    private static final ClassNode NAMED_DELEGATE_TYPE = ClassHelper.makeWithoutCaching(NamedDelegate.class, false);
    private static final ClassNode ILLEGAL_ARGUMENT_TYPE = ClassHelper.makeWithoutCaching(IllegalArgumentException.class);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        Parameter fromParam;
        this.init(nodes, source);
        MethodNode mNode = (MethodNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!NAMED_VARIANT_TYPE.equals(anno.getClassNode())) {
            return;
        }
        Parameter[] fromParams = mNode.getParameters();
        if (fromParams.length == 0) {
            this.addError("Error during " + NAMED_VARIANT + " processing. No-args method not supported.", mNode);
            return;
        }
        boolean autoDelegate = this.memberHasValue(anno, "autoDelegate", true);
        boolean coerce = this.memberHasValue(anno, "coerce", true);
        Parameter mapParam = GeneralUtils.param((ClassNode)GenericsUtils.nonGeneric(ClassHelper.MAP_TYPE), (String)"namedArgs");
        ArrayList<Parameter> genParams = new ArrayList<Parameter>();
        genParams.add(mapParam);
        ClassNode cNode = mNode.getDeclaringClass();
        BlockStatement inner = new BlockStatement();
        ArgumentListExpression args = new ArgumentListExpression();
        ArrayList<String> propNames = new ArrayList<String>();
        boolean annoFound = false;
        Parameter[] parameterArray = fromParams;
        int n = fromParams.length;
        int n2 = 0;
        while (n2 < n) {
            fromParam = parameterArray[n2];
            if (AnnotatedNodeUtils.hasAnnotation((AnnotatedNode)fromParam, (ClassNode)NAMED_PARAM_TYPE) || AnnotatedNodeUtils.hasAnnotation((AnnotatedNode)fromParam, (ClassNode)NAMED_DELEGATE_TYPE)) {
                annoFound = true;
                break;
            }
            ++n2;
        }
        if (!annoFound && autoDelegate) {
            this.processDelegateParam(mNode, mapParam, args, propNames, fromParams[0], coerce);
        } else {
            parameterArray = fromParams;
            n = fromParams.length;
            n2 = 0;
            while (n2 < n) {
                fromParam = parameterArray[n2];
                if (!annoFound) {
                    if (!this.processImplicitNamedParam(mNode, mapParam, inner, args, propNames, fromParam, coerce)) {
                        return;
                    }
                } else if (AnnotatedNodeUtils.hasAnnotation((AnnotatedNode)fromParam, (ClassNode)NAMED_PARAM_TYPE)) {
                    if (!this.processExplicitNamedParam(mNode, mapParam, inner, args, propNames, fromParam, coerce)) {
                        return;
                    }
                } else if (AnnotatedNodeUtils.hasAnnotation((AnnotatedNode)fromParam, (ClassNode)NAMED_DELEGATE_TYPE)) {
                    if (!this.processDelegateParam(mNode, mapParam, args, propNames, fromParam, coerce)) {
                        return;
                    }
                } else {
                    VariableExpression arg = GeneralUtils.varX((Variable)fromParam);
                    VariableExpression argOrDefault = fromParam.hasInitialExpression() ? GeneralUtils.elvisX((Expression)arg, (Expression)fromParam.getDefaultValue()) : arg;
                    args.addExpression(NamedVariantASTTransformation.asType((Expression)argOrDefault, fromParam.getType(), coerce));
                    if (this.hasDuplicates(mNode, propNames, fromParam.getName())) {
                        return;
                    }
                    genParams.add(fromParam);
                }
                ++n2;
            }
        }
        this.createMapVariant(mNode, anno, mapParam, genParams, cNode, inner, args, propNames);
    }

    private boolean processImplicitNamedParam(MethodNode mNode, Parameter mapParam, BlockStatement inner, ArgumentListExpression args, List<String> propNames, Parameter fromParam, boolean coerce) {
        boolean required;
        String name = fromParam.getName();
        ClassNode type = fromParam.getType();
        boolean bl = required = !fromParam.hasInitialExpression();
        if (this.hasDuplicates(mNode, propNames, name)) {
            return false;
        }
        AnnotationNode namedParam = new AnnotationNode(NAMED_PARAM_TYPE);
        namedParam.addMember("value", (Expression)GeneralUtils.constX((Object)name));
        namedParam.addMember("type", (Expression)GeneralUtils.classX((ClassNode)type));
        namedParam.addMember("required", (Expression)GeneralUtils.constX((Object)required, (boolean)true));
        mapParam.addAnnotation(namedParam);
        if (required) {
            inner.addStatement((Statement)new AssertStatement(GeneralUtils.boolX((Expression)NamedVariantASTTransformation.containsKey(mapParam, name)), (Expression)GeneralUtils.plusX((Expression)GeneralUtils.constX((Object)("Missing required named argument '" + name + "'. Keys found: ")), (Expression)GeneralUtils.callX((Expression)GeneralUtils.varX((Variable)mapParam), (String)"keySet"))));
        }
        args.addExpression(NamedVariantASTTransformation.namedParamValue(mapParam, name, type, coerce, fromParam.getInitialExpression()));
        return true;
    }

    private boolean processExplicitNamedParam(MethodNode mNode, Parameter mapParam, BlockStatement inner, ArgumentListExpression args, List<String> propNames, Parameter fromParam, boolean coerce) {
        boolean required;
        AnnotationNode namedParam = fromParam.getAnnotations(NAMED_PARAM_TYPE).get(0);
        String name = NamedVariantASTTransformation.getMemberStringValue((AnnotationNode)namedParam, (String)"value");
        if (name == null) {
            name = fromParam.getName();
            namedParam.addMember("value", (Expression)GeneralUtils.constX((Object)name));
        }
        if (this.hasDuplicates(mNode, propNames, name)) {
            return false;
        }
        ClassNode type = this.getMemberClassValue(namedParam, "type");
        if (type == null) {
            type = fromParam.getType();
            namedParam.addMember("type", (Expression)GeneralUtils.classX((ClassNode)type));
        }
        if (required = this.memberHasValue(namedParam, "required", true)) {
            if (fromParam.hasInitialExpression()) {
                this.addError("Error during " + NAMED_VARIANT + " processing. A required parameter can't have an initial value.", fromParam);
                return false;
            }
            inner.addStatement((Statement)new AssertStatement(GeneralUtils.boolX((Expression)NamedVariantASTTransformation.containsKey(mapParam, name)), (Expression)GeneralUtils.plusX((Expression)GeneralUtils.constX((Object)("Missing required named argument '" + name + "'. Keys found: ")), (Expression)GeneralUtils.callX((Expression)GeneralUtils.varX((Variable)mapParam), (String)"keySet"))));
        }
        args.addExpression(NamedVariantASTTransformation.namedParamValue(mapParam, name, type, coerce, fromParam.getInitialExpression()));
        mapParam.addAnnotation(namedParam);
        fromParam.putNodeMetaData("met@", namedParam);
        fromParam.getAnnotations().remove(namedParam);
        return true;
    }

    private boolean processDelegateParam(MethodNode mNode, Parameter mapParam, ArgumentListExpression args, List<String> propNames, Parameter fromParam, boolean coerce) {
        if (ClassNodeUtils.isInnerClass((ClassNode)fromParam.getType()) && mNode.isStatic()) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Delegate type '" + fromParam.getType().getNameWithoutPackage() + "' is an inner class which is not supported.", mNode);
            return false;
        }
        HashSet names = new HashSet();
        List props = GeneralUtils.getAllProperties(names, (ClassNode)fromParam.getType(), (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
        for (String name2 : names) {
            if (!this.hasDuplicates(mNode, propNames, name2)) continue;
            return false;
        }
        for (PropertyNode prop : props) {
            AnnotationNode namedParam = new AnnotationNode(NAMED_PARAM_TYPE);
            namedParam.addMember("value", (Expression)GeneralUtils.constX((Object)prop.getName()));
            namedParam.addMember("type", (Expression)GeneralUtils.classX((ClassNode)prop.getType()));
            mapParam.addAnnotation(namedParam);
        }
        Expression[] subMapArgs = (Expression[])names.stream().map(name -> GeneralUtils.constX((Object)name)).toArray(Expression[]::new);
        MethodCallExpression delegateMap = GeneralUtils.callX((Expression)GeneralUtils.varX((Variable)mapParam), (String)"subMap", (Expression)GeneralUtils.args((Expression[])subMapArgs));
        args.addExpression((Expression)GeneralUtils.castX((ClassNode)fromParam.getType(), (Expression)delegateMap));
        return true;
    }

    private boolean hasDuplicates(MethodNode mNode, List<String> propNames, String next) {
        if (propNames.contains(next)) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Duplicate property '" + next + "' found.", mNode);
            return true;
        }
        propNames.add(next);
        return false;
    }

    private void createMapVariant(MethodNode mNode, AnnotationNode anno, Parameter mapParam, List<Parameter> genParams, ClassNode cNode, BlockStatement inner, ArgumentListExpression args, List<String> propNames) {
        Parameter namedArgKey = GeneralUtils.param((ClassNode)ClassHelper.STRING_TYPE, (String)"namedArgKey");
        if (!(mNode instanceof ConstructorNode)) {
            inner.getStatements().add(0, GeneralUtils.ifS((Expression)GeneralUtils.isNullX((Expression)GeneralUtils.varX((Variable)mapParam)), (Statement)GeneralUtils.throwS((Expression)GeneralUtils.ctorX((ClassNode)ILLEGAL_ARGUMENT_TYPE, (Expression)GeneralUtils.constX((Object)"Named parameter map cannot be null")))));
        }
        inner.addStatement((Statement)new ForStatement(namedArgKey, (Expression)GeneralUtils.callX((Expression)GeneralUtils.varX((Variable)mapParam), (String)"keySet"), (Statement)new AssertStatement(GeneralUtils.boolX((Expression)GeneralUtils.callX((Expression)GeneralUtils.list2args(propNames), (String)"contains", (Expression)GeneralUtils.varX((Variable)namedArgKey))), (Expression)GeneralUtils.plusX((Expression)GeneralUtils.constX((Object)"Unrecognized namedArgKey: "), (Expression)GeneralUtils.varX((Variable)namedArgKey)))));
        Parameter[] genParamsArray = genParams.toArray(Parameter.EMPTY_ARRAY);
        if (cNode.hasMethod(mNode.getName(), genParamsArray)) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Class " + cNode.getNameWithoutPackage() + " already has a named-arg " + (mNode instanceof ConstructorNode ? "constructor" : "method") + " of type " + genParams, mNode);
            return;
        }
        BlockStatement body = new BlockStatement();
        int modifiers = VisibilityUtils.getVisibility((AnnotationNode)anno, (AnnotatedNode)mNode, mNode.getClass(), (int)mNode.getModifiers());
        if (mNode instanceof ConstructorNode) {
            body.addStatement(GeneralUtils.stmt((Expression)GeneralUtils.ctorX((ClassNode)ClassNode.THIS, (Expression)args)));
            body.addStatement((Statement)inner);
            ClassNodeUtils.addGeneratedConstructor((ClassNode)cNode, (int)modifiers, (Parameter[])genParamsArray, (ClassNode[])mNode.getExceptions(), (Statement)body);
        } else {
            body.addStatement((Statement)inner);
            body.addStatement(GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)mNode.getName(), (Expression)args)));
            ClassNodeUtils.addGeneratedMethod((ClassNode)cNode, (String)mNode.getName(), (int)modifiers, (ClassNode)mNode.getReturnType(), (Parameter[])genParamsArray, (ClassNode[])mNode.getExceptions(), (Statement)body);
        }
    }

    private static Expression namedParamValue(Parameter mapParam, String name, ClassNode type, boolean coerce, Expression defaultValue) {
        PropertyExpression value = GeneralUtils.propX((Expression)GeneralUtils.varX((Variable)mapParam), (String)name);
        if (defaultValue == null && ClassHelper.isPrimitiveType(type)) {
            defaultValue = NamedVariantASTTransformation.defaultValueX(type);
        }
        if (defaultValue != null) {
            value = GeneralUtils.ternaryX((Expression)NamedVariantASTTransformation.containsKey(mapParam, name), (Expression)value, (Expression)defaultValue);
        }
        return NamedVariantASTTransformation.asType((Expression)value, type, coerce);
    }

    private static Expression defaultValueX(ClassNode type) {
        return Optional.ofNullable(PrimitiveHelper.getDefaultValueForPrimitive((ClassNode)type)).orElse(GeneralUtils.nullX());
    }

    private static Expression containsKey(Parameter mapParam, String name) {
        MethodCallExpression call = GeneralUtils.callX((Expression)GeneralUtils.varX((Variable)mapParam), (String)"containsKey", (Expression)GeneralUtils.constX((Object)name));
        call.setImplicitThis(false);
        call.setMethodTarget(ClassHelper.MAP_TYPE.getMethods("containsKey").get(0));
        return call;
    }

    private static Expression asType(Expression value, ClassNode type, boolean coerce) {
        return coerce ? GeneralUtils.asX((ClassNode)type, (Expression)value) : value;
    }
}

