/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import com.kms.katalon.core.logging.ErrorCollector;
import cucumber.api.Pending;
import cucumber.api.Result;
import cucumber.api.Scenario;
import cucumber.api.event.Event;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.runner.EventBus;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepDefinitionException;
import java.util.Arrays;
import java.util.List;

abstract class TestStep
implements cucumber.api.TestStep {
    private ErrorCollector errorCollector = ErrorCollector.getCollector();
    private List<Throwable> oldErrors;
    private static final String[] ASSUMPTION_VIOLATED_EXCEPTIONS = new String[]{"org.junit.AssumptionViolatedException", "org.junit.internal.AssumptionViolatedException", "org.testng.SkipException"};
    private final StepDefinitionMatch stepDefinitionMatch;

    static {
        Arrays.sort(ASSUMPTION_VIOLATED_EXCEPTIONS);
    }

    TestStep(StepDefinitionMatch stepDefinitionMatch) {
        this.stepDefinitionMatch = stepDefinitionMatch;
        this.errorCollector.setStopLauncher(false);
        this.errorCollector.setIsNextStepSkipped(false);
    }

    public String getCodeLocation() {
        return this.stepDefinitionMatch.getCodeLocation();
    }

    Result run(EventBus bus, String language, Scenario scenario, boolean skipSteps) {
        Result.Type status;
        this.oldErrors = this.errorCollector.getCoppiedErrors();
        this.errorCollector.clearErrors();
        Long startTime = bus.getTime();
        bus.send((Event)new TestStepStarted(startTime, (cucumber.api.TestStep)this));
        Throwable error = null;
        if (this.errorCollector.isNextStepSkipped() && !this.errorCollector.isStopLauncher()) {
            skipSteps = !this.errorCollector.isNextStepSkipped();
        }
        try {
            status = this.executeStep(language, scenario, skipSteps);
        }
        catch (Throwable t) {
            error = t;
            status = this.mapThrowableToStatus(t);
        }
        Long stopTime = bus.getTime();
        Result result = this.mapStatusToResult(status, error, stopTime - startTime);
        if (result.is(Result.Type.PASSED) && this.errorCollector.containsErrors()) {
            result = new Result(Result.Type.FAILED, result.getDuration(), this.errorCollector.getFirstError());
        }
        bus.send((Event)new TestStepFinished(stopTime, (cucumber.api.TestStep)this, result));
        this.errorCollector.clearErrors();
        this.errorCollector.getErrors().addAll(0, this.oldErrors);
        return result;
    }

    private Result.Type executeStep(String language, Scenario scenario, boolean skipSteps) throws Throwable {
        if (!skipSteps) {
            this.stepDefinitionMatch.runStep(language, scenario);
            return Result.Type.PASSED;
        }
        this.stepDefinitionMatch.dryRunStep(language, scenario);
        return Result.Type.SKIPPED;
    }

    private Result.Type mapThrowableToStatus(Throwable t) {
        if (t.getClass().isAnnotationPresent(Pending.class)) {
            return Result.Type.PENDING;
        }
        if (Arrays.binarySearch(ASSUMPTION_VIOLATED_EXCEPTIONS, t.getClass().getName()) >= 0) {
            return Result.Type.SKIPPED;
        }
        if (t.getClass() == UndefinedStepDefinitionException.class) {
            return Result.Type.UNDEFINED;
        }
        if (t.getClass() == AmbiguousStepDefinitionsException.class) {
            return Result.Type.AMBIGUOUS;
        }
        return Result.Type.FAILED;
    }

    private Result mapStatusToResult(Result.Type status, Throwable error, long duration) {
        Long resultDuration = duration;
        if (status == Result.Type.SKIPPED && error == null) {
            return Result.SKIPPED;
        }
        if (status == Result.Type.UNDEFINED) {
            return Result.UNDEFINED;
        }
        return new Result(status, resultDuration, error);
    }
}

