/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseTextElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.TextAdjustEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseTextField
extends JRBaseTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_STRETCH_WITH_OVERFLOW = "isStretchWithOverflow";
    public static final String PROPERTY_TEXT_ADJUST = "textAdjust";
    protected TextAdjustEnum textAdjust = TextAdjustEnum.CUT_TEXT;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String pattern;
    protected Boolean isBlankWhenNull;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression patternExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 61100;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;
    private boolean isStretchWithOverflow;

    protected JRBaseTextField(JRTextField textField, JRBaseObjectFactory factory) {
        super(textField, factory);
        this.textAdjust = textField.getTextAdjust();
        this.evaluationTimeValue = textField.getEvaluationTimeValue();
        this.pattern = textField.getOwnPattern();
        this.isBlankWhenNull = textField.isOwnBlankWhenNull();
        this.linkType = textField.getLinkType();
        this.linkTarget = textField.getLinkTarget();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(textField, factory);
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
        this.expression = factory.getExpression(textField.getExpression());
        this.patternExpression = factory.getExpression(textField.getPatternExpression());
        this.anchorNameExpression = factory.getExpression(textField.getAnchorNameExpression());
        this.bookmarkLevelExpression = factory.getExpression(textField.getBookmarkLevelExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(textField.getHyperlinkReferenceExpression());
        this.hyperlinkWhenExpression = factory.getExpression(textField.getHyperlinkWhenExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(textField.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(textField.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(textField.getHyperlinkTooltipExpression());
        this.bookmarkLevel = textField.getBookmarkLevel();
    }

    @Override
    public boolean isStretchWithOverflow() {
        return this.getTextAdjust() == TextAdjustEnum.STRETCH_HEIGHT;
    }

    @Override
    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
        boolean old = this.textAdjust == TextAdjustEnum.STRETCH_HEIGHT;
        this.setTextAdjust(isStretchWithOverflow ? TextAdjustEnum.STRETCH_HEIGHT : TextAdjustEnum.CUT_TEXT);
        this.getEventSupport().firePropertyChange(PROPERTY_STRETCH_WITH_OVERFLOW, old, isStretchWithOverflow);
    }

    @Override
    public TextAdjustEnum getTextAdjust() {
        return this.textAdjust;
    }

    @Override
    public void setTextAdjust(TextAdjustEnum textAdjust) {
        TextAdjustEnum old = this.textAdjust;
        this.textAdjust = textAdjust;
        this.getEventSupport().firePropertyChange(PROPERTY_TEXT_ADJUST, old, this.textAdjust);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public String getPattern() {
        return this.getStyleResolver().getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange("pattern", old, this.pattern);
    }

    @Override
    public boolean isBlankWhenNull() {
        return this.getStyleResolver().isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public void setBlankWhenNull(Boolean isBlank) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlank;
        this.getEventSupport().firePropertyChange("isBlankWhenNull", old, this.isBlankWhenNull);
    }

    @Override
    public void setBlankWhenNull(boolean isBlank) {
        this.setBlankWhenNull((Boolean)isBlank);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getPatternExpression() {
        return this.patternExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitTextField(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Object clone() {
        JRBaseTextField clone = (JRBaseTextField)super.clone();
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.patternExpression = JRCloneUtils.nullSafeClone(this.patternExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.bookmarkLevelExpression = JRCloneUtils.nullSafeClone(this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 61100) {
            this.textAdjust = this.isStretchWithOverflow ? TextAdjustEnum.STRETCH_HEIGHT : TextAdjustEnum.CUT_TEXT;
        }
    }
}

