/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.controller;

import com.katalon.platform.api.controller.TestExecutionController;
import com.katalon.platform.api.exception.PlatformException;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.console.ConsoleExecutor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.LauncherProviderFactory;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionLauncher;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;

public class TestExecutionControllerImpl
implements TestExecutionController {
    public void run(String[] args) throws PlatformException {
        try {
            ConsoleExecutor consoleExecutor = new ConsoleExecutor();
            OptionParser parser = new OptionParser(false);
            parser.allowsUnrecognizedOptions();
            TestExecutionControllerImpl.acceptConsoleOptionList(parser, consoleExecutor.getAllConsoleOptions());
            OptionSet optionSet = parser.parse(args);
            ILauncher launcher = consoleExecutor.getUILauncher(ProjectController.getInstance().getCurrentProject(), optionSet);
            LauncherProviderFactory.getInstance().getIdeLauncherProvider().launch(launcher);
        }
        catch (Exception e) {
            throw new PlatformException(e);
        }
    }

    private static void acceptConsoleOptionList(OptionParser parser, List<ConsoleOption<?>> consoleOptionList) {
        for (ConsoleOption<?> consoleOption : consoleOptionList) {
            OptionSpecBuilder optionSpecBuilder = parser.accepts(consoleOption.getOption());
            if (!consoleOption.hasArgument()) continue;
            optionSpecBuilder.withRequiredArg().ofType(consoleOption.getArgumentType());
        }
    }

    public void run(String[] args, TestExecutionController.TestSuiteInstanceConfiguration testSuiteInstanceConfiguration) throws PlatformException {
        try {
            ConsoleExecutor consoleExecutor = new ConsoleExecutor();
            OptionParser parser = new OptionParser(false);
            parser.allowsUnrecognizedOptions();
            TestExecutionControllerImpl.acceptConsoleOptionList(parser, consoleExecutor.getAllConsoleOptions());
            OptionSet optionSet = parser.parse(args);
            ILauncher launcher = consoleExecutor.getUILauncher(ProjectController.getInstance().getCurrentProject(), optionSet);
            if (testSuiteInstanceConfiguration != null) {
                if (launcher instanceof ReportableLauncher) {
                    ReportableLauncher reportableLauncher = (ReportableLauncher)launcher;
                    IRunConfiguration runConfig = reportableLauncher.getRunConfig();
                    this.addRunConfiguration(runConfig, testSuiteInstanceConfiguration);
                } else if (launcher instanceof TestSuiteCollectionLauncher) {
                    TestSuiteCollectionLauncher tscLauncher = (TestSuiteCollectionLauncher)launcher;
                    tscLauncher.getSubLaunchers().stream().forEach(subLauncher -> {
                        IRunConfiguration runConfig = subLauncher.getRunConfig();
                        this.addRunConfiguration(runConfig, testSuiteInstanceConfiguration);
                    });
                }
            }
            LauncherProviderFactory.getInstance().getIdeLauncherProvider().launch(launcher);
        }
        catch (Exception e) {
            throw new PlatformException(e);
        }
    }

    private void addRunConfiguration(IRunConfiguration runConfig, TestExecutionController.TestSuiteInstanceConfiguration testSuiteInstanceConfiguration) {
        runConfig.setVmArgs(testSuiteInstanceConfiguration.getVmArgs());
        runConfig.setAdditionalEnvironmentVariables(testSuiteInstanceConfiguration.getAdditionEnvironmentVariables());
        runConfig.setTestSuiteAdditionalData(testSuiteInstanceConfiguration.getAdditionalData());
    }
}

