/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.entity.testobject;

import com.katalon.platform.api.model.testobject.SoapRequestEntity;
import com.katalon.platform.api.model.testobject.WebServiceProperty;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.platform.internal.entity.VariableEntityImpl;
import com.kms.katalon.platform.internal.entity.testobject.WebServicePropertyImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SoapRequestEntityImpl
implements SoapRequestEntity {
    private WebServiceRequestEntity source;

    public SoapRequestEntityImpl(WebServiceRequestEntity source) {
        this.source = source;
    }

    public String getSoapBodyContent() {
        return this.source.getHttpBodyContent();
    }

    public String getSoapServiceFunction() {
        return this.source.getSoapServiceFunction();
    }

    public List<WebServiceProperty> getHttpHeaders() {
        if (this.source.getHttpHeaderProperties() == null) {
            return Collections.emptyList();
        }
        return this.source.getHttpHeaderProperties().stream().map(header -> new WebServicePropertyImpl((WebElementPropertyEntity)header)).collect(Collectors.toList());
    }

    public String getRequestMethod() {
        return this.source.getSoapRequestMethod();
    }

    public List<WebServiceProperty> getRequestParameters() {
        if (this.source.getSoapParameters() == null) {
            return Collections.emptyList();
        }
        return this.source.getSoapParameters().stream().map(header -> new WebServicePropertyImpl((WebElementPropertyEntity)header)).collect(Collectors.toList());
    }

    public String getRequestUrl() {
        return this.source.getWsdlAddress();
    }

    public String getServiceType() {
        return this.source.getServiceType();
    }

    public List<com.katalon.platform.api.model.VariableEntity> getVariables() {
        if (this.source.getVariables() == null) {
            return Collections.emptyList();
        }
        return this.source.getVariables().stream().map(variable -> new VariableEntityImpl((VariableEntity)variable)).collect(Collectors.toList());
    }

    public String getVerificationScript() {
        return this.source.getVerificationScript();
    }

    public String getFileLocation() {
        return this.source.getId();
    }

    public String getFolderLocation() {
        return this.source.getParentFolder().getLocation();
    }

    public String getId() {
        return this.source.getIdForDisplay();
    }

    public String getName() {
        return this.source.getName();
    }

    public String getDescription() {
        return this.source.getDescription();
    }
}

