/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.genai.ApiClient;
import com.google.genai.AsyncLive;
import com.google.genai.AsyncModels;
import com.google.genai.AsyncOperations;
import com.google.genai.ChatSession;
import com.google.genai.DebugConfig;
import com.google.genai.HttpApiClient;
import com.google.genai.Models;
import com.google.genai.Operations;
import com.google.genai.ReplayApiClient;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Optional;

public final class Client
implements AutoCloseable {
    private final DebugConfig debugConfig;
    private final ApiClient apiClient;
    public final Models models;
    public final Operations operations;
    public final ChatSession chats;
    public final Async async;

    public static Builder builder() {
        return new Builder();
    }

    public Client() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private Client(Optional<String> apiKey, Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions, Optional<Boolean> vertexAI, Optional<DebugConfig> debugConfig) {
        boolean useVertexAI;
        Preconditions.checkNotNull(vertexAI, (Object)"vertexAI cannot be null");
        Preconditions.checkNotNull(debugConfig, (Object)"debugConfig cannot be null");
        if (vertexAI.isPresent()) {
            useVertexAI = vertexAI.get();
        } else {
            String envVar = System.getenv("GOOGLE_GENAI_USE_VERTEXAI");
            boolean bl = useVertexAI = envVar != null && envVar.equalsIgnoreCase("true");
        }
        if (project.isPresent() || location.isPresent()) {
            if (apiKey.isPresent()) {
                throw new IllegalArgumentException("Project/location and API key are mutually exclusive in the client initializer.");
            }
            if (!useVertexAI) {
                throw new IllegalArgumentException("Google AI APIs do not support project/location.");
            }
        }
        if (apiKey.isPresent() && useVertexAI) {
            throw new IllegalArgumentException("Vertex AI APIs do not support API key.");
        }
        this.debugConfig = debugConfig.orElse(new DebugConfig());
        if (this.debugConfig.clientMode().equals("replay") || this.debugConfig.clientMode().equals("auto")) {
            System.out.println("Instantialing a client that will use Replay mode...");
            if (!useVertexAI) {
                System.out.println("Instantialing a replay client that will use Google AI APIs...");
                this.apiClient = new ReplayApiClient(apiKey, httpOptions, this.debugConfig.replaysDirectory(), this.debugConfig.replayId(), this.debugConfig.clientMode());
            } else {
                System.out.println("Instantialing a replay client that will use Vertex AI APIs...");
                this.apiClient = new ReplayApiClient(project, location, credentials, httpOptions, this.debugConfig.replaysDirectory(), this.debugConfig.replayId(), this.debugConfig.clientMode());
            }
        } else {
            this.apiClient = !useVertexAI ? new HttpApiClient(apiKey, httpOptions) : new HttpApiClient(project, location, credentials, httpOptions);
        }
        this.models = new Models(this.apiClient);
        this.operations = new Operations(this.apiClient);
        this.chats = new ChatSession(this.apiClient);
        this.async = new Async(this.apiClient);
    }

    public boolean vertexAI() {
        return this.apiClient.vertexAI();
    }

    public String project() {
        return this.apiClient.project();
    }

    public String location() {
        return this.apiClient.location();
    }

    public String apiKey() {
        return this.apiClient.apiKey();
    }

    protected void setReplayId(String replayId) {
        if (this.apiClient instanceof ReplayApiClient) {
            ((ReplayApiClient)this.apiClient).initializeReplaySession(replayId);
        }
    }

    String clientMode() {
        return this.debugConfig.clientMode();
    }

    @Override
    public void close() {
        try {
            this.apiClient.httpClient().close();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to close the HTTP client.", e);
        }
    }

    public static class Builder {
        private Optional<String> apiKey = Optional.empty();
        private Optional<String> project = Optional.empty();
        private Optional<String> location = Optional.empty();
        private Optional<GoogleCredentials> credentials = Optional.empty();
        private Optional<HttpOptions> httpOptions = Optional.empty();
        private Optional<Boolean> vertexAI = Optional.empty();
        private Optional<DebugConfig> debugConfig = Optional.empty();

        public Client build() {
            return new Client(this.apiKey, this.project, this.location, this.credentials, this.httpOptions, this.vertexAI, this.debugConfig);
        }

        public Builder apiKey(String apiKey) {
            Preconditions.checkNotNull((Object)apiKey, (Object)"apiKey cannot be null");
            this.apiKey = Optional.of(apiKey);
            return this;
        }

        public Builder project(String project) {
            Preconditions.checkNotNull((Object)project, (Object)"project cannot be null");
            this.project = Optional.of(project);
            return this;
        }

        public Builder location(String location) {
            Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
            this.location = Optional.of(location);
            return this;
        }

        public Builder credentials(GoogleCredentials credentials) {
            Preconditions.checkNotNull((Object)credentials, (Object)"credentials cannot be null");
            this.credentials = Optional.of(credentials);
            return this;
        }

        public Builder httpOptions(HttpOptions httpOptions) {
            Preconditions.checkNotNull((Object)httpOptions, (Object)"httpOptions cannot be null");
            this.httpOptions = Optional.of(httpOptions);
            return this;
        }

        public Builder vertexAI(boolean vertexAI) {
            this.vertexAI = Optional.of(vertexAI);
            return this;
        }

        Builder debugConfig(DebugConfig debugConfig) {
            Preconditions.checkNotNull((Object)debugConfig, (Object)"debugConfig cannot be null");
            this.debugConfig = Optional.of(debugConfig);
            return this;
        }
    }

    public final class Async {
        public final AsyncModels models;
        public final AsyncOperations operations;
        public final AsyncLive live;

        public Async(ApiClient apiClient) {
            this.models = new AsyncModels(apiClient);
            this.operations = new AsyncOperations(apiClient);
            this.live = new AsyncLive(apiClient);
        }
    }
}

