/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Preconditions;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.JsonSerializable;
import com.google.genai.ReplayApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicStatusLine;

final class ReplayApiClient
extends ApiClient {
    private final String replaysDirectory;
    private String replayId;
    private final String clientMode;
    private Map<String, Object> replaySession = null;
    private int replayIndex = -1;

    ReplayApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions, String replaysDirectory, String replayId, String clientMode) {
        super(apiKey, httpOptions);
        Preconditions.checkNotNull((Object)replaysDirectory, (Object)"replaysDirectory cannot be null");
        Preconditions.checkNotNull((Object)replayId, (Object)"replayId cannot be null");
        Preconditions.checkNotNull((Object)clientMode, (Object)"clientMode cannot be null");
        this.replaysDirectory = replaysDirectory;
        this.replayId = replayId;
        this.clientMode = clientMode;
    }

    ReplayApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions, String replaysDirectory, String replayId, String clientMode) {
        super(project, location, credentials, httpOptions);
        Preconditions.checkNotNull((Object)replaysDirectory, (Object)"replaysDirectory cannot be null");
        Preconditions.checkNotNull((Object)replayId, (Object)"replayId cannot be null");
        Preconditions.checkNotNull((Object)clientMode, (Object)"clientMode cannot be null");
        this.replaysDirectory = replaysDirectory;
        this.replayId = replayId;
        this.clientMode = clientMode;
    }

    static String readString(Path path) {
        String string;
        block8: {
            Stream<String> stream = Files.lines(path);
            try {
                string = stream.collect(Collectors.joining(System.lineSeparator()));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GenAiIOException("Failed to read replay file. ", e);
                }
            }
            stream.close();
        }
        return string;
    }

    void initializeReplaySession(String replayId) {
        this.replayId = replayId;
        String replayPath = this.replaysDirectory + "/" + this.replayId;
        try {
            Map map;
            String replayData = ReplayApiClient.readString(Paths.get(replayPath, new String[0]));
            this.replaySession = map = (Map)JsonSerializable.objectMapper.readValue(replayData, (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.replayIndex = 0;
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read replay file: " + e, e);
        }
    }

    @Override
    public ApiResponse request(String httpMethod, String path, String requestJson) {
        if (this.clientMode.equals("replay") || this.clientMode.equals("auto")) {
            System.out.println("    === Using replay for ID: " + this.replayId);
            List<Object> interactions = Arrays.asList(this.replaySession.get("interactions"));
            Object currentInteraction = Arrays.asList(interactions.get(this.replayIndex)).get(0);
            LinkedHashMap currentMember = (LinkedHashMap)((ArrayList)currentInteraction).get(0);
            Map responseMap = (Map)currentMember.get("response");
            Integer statusCode = (Integer)responseMap.get("status_code");
            List bodySegments = (List)responseMap.get("body_segments");
            StringBuilder responseBody = new StringBuilder();
            for (Object bodySegment : bodySegments) {
                responseBody.append(bodySegment.toString());
            }
            String responseString = responseBody.toString();
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent((InputStream)new ByteArrayInputStream(responseString.getBytes(StandardCharsets.UTF_8)));
            entity.setContentLength((long)responseString.length());
            BasicStatusLine statusLine = new BasicStatusLine(new ProtocolVersion("HTTP", 1, 1), statusCode.intValue(), "OK");
            return new ReplayApiResponse((HttpEntity)entity, (StatusLine)statusLine);
        }
        throw new IllegalArgumentException("Invalid client mode: " + this.clientMode);
    }
}

