/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.session.core.model.KatalonPackage;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.tracking.model.TrackingActivationInfo;
import com.kms.katalon.tracking.model.TrackingUsageInfo;
import java.util.Objects;

public class PayloadBuilder {
    public String buildUsageTrackingPayload(TrackingUsageInfo trackInfo) {
        JsonObject properties;
        String eventName;
        JsonObject payload = new JsonObject();
        String userId = trackInfo.getUserId();
        if (Objects.nonNull(userId)) {
            payload.addProperty("userId", userId);
        }
        if (Objects.nonNull(eventName = trackInfo.getEventName())) {
            payload.addProperty("event", eventName);
        }
        if (Objects.nonNull(properties = trackInfo.getEventProperties())) {
            payload.add("properties", (JsonElement)properties);
        }
        return payload.toString();
    }

    public String buildActivationTrackingPayload(TrackingActivationInfo trackInfo) {
        JsonObject properties;
        LicenseType licenseType;
        JsonObject payload = new JsonObject();
        String userId = trackInfo.getUserId();
        if (Objects.nonNull(userId)) {
            payload.addProperty("userId", userId);
        }
        String errorMessage = trackInfo.getErrorMessage();
        payload.addProperty("errorMessage", errorMessage);
        KatalonPackage katalonPackage = trackInfo.getKatalonPackage();
        if (Objects.nonNull(katalonPackage)) {
            payload.addProperty("katalonPackage", katalonPackage.toString());
        }
        if (Objects.nonNull(licenseType = trackInfo.getLicenseType())) {
            payload.addProperty("licenseType", licenseType.toString());
        }
        if (Objects.nonNull(properties = trackInfo.getProperties())) {
            payload.add("traits", (JsonElement)properties);
        }
        return payload.toString();
    }
}

