/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.model;

import com.google.gson.JsonObject;
import com.kms.katalon.core.util.internal.JsonUtil;

public class TrackingUsageInfo {
    private String eventName;
    private JsonObject eventProperties = new JsonObject();
    private boolean isAnonymous;
    private String userId;

    private TrackingUsageInfo(Builder builder) {
        this.eventName = builder.eventName;
        this.eventProperties = builder.eventProperties != null ? builder.eventProperties : new JsonObject();
        this.isAnonymous = builder.isAnonymous;
        this.userId = builder.userId;
    }

    public void addProperty(JsonObject newProperty) {
        JsonUtil.mergeJsonObject((JsonObject)newProperty, (JsonObject)this.eventProperties);
    }

    public void addProperty(String key, String value) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(key, value);
        this.addProperty(jsonObject);
    }

    public String getEventName() {
        return this.eventName;
    }

    public JsonObject getEventProperties() {
        return this.eventProperties;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setEventProperties(JsonObject eventProperties) {
        this.eventProperties = eventProperties;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class Builder {
        private String eventName;
        private JsonObject eventProperties;
        private boolean isAnonymous;
        private String userId;

        public TrackingUsageInfo build() {
            return new TrackingUsageInfo(this);
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder eventProperties(JsonObject eventProperties) {
            this.eventProperties = eventProperties;
            return this;
        }

        public Builder isAnonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

