/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.core.logging.CustomXmlFormatter;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XMLParserException;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.core.util.MediaUtils;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestDefect;
import com.kms.katalon.integration.qtest.entity.QTestDefectField;
import com.kms.katalon.integration.qtest.entity.QTestLog;
import com.kms.katalon.integration.qtest.entity.QTestLogUploadedPreview;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestReport;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestStepLog;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.model.ExecutionStatusMapping;
import com.kms.katalon.integration.qtest.setting.QTestAttachmentSendingType;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.integration.qtest.util.ZipUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class QTestIntegrationReportManager {
    private QTestIntegrationReportManager() {
    }

    public static URL getTestLogURL(String projectDir, QTestProject qTestProject, QTestRun qTestRun, QTestLog qTestLog) throws IOException {
        String url = QTestSettingStore.getServerUrl(QTestSettingStore.isEncryptionEnabled(projectDir), projectDir);
        return new URL(url + "/p/" + Long.toString(qTestProject.getId()) + "/portal/project#tab=testexecution&object=" + QTestRun.getType() + "&id=" + Long.toString(qTestRun.getId()));
    }

    public static QTestReport getQTestReportByIntegratedEntity(IntegratedEntity reportIntegratedEntity) throws QTestInvalidFormatException {
        if (reportIntegratedEntity == null) {
            return null;
        }
        try {
            TreeMap properties = new TreeMap(reportIntegratedEntity.getProperties());
            QTestReport qTestReport = new QTestReport();
            for (Map.Entry entry : properties.entrySet()) {
                String value = (String)entry.getValue();
                JsonObject testLogJsonObject = new JsonObject(value.replace("'", "\"").replace("},\n", "},"));
                QTestLog qTestLog = new QTestLog();
                qTestLog.setId(testLogJsonObject.getLong("id"));
                qTestLog.setName(testLogJsonObject.getString("name"));
                qTestLog.setAttachmentIncluded(testLogJsonObject.getBoolean("attachmentIncluded"));
                qTestReport.getTestLogMap().put(Integer.parseInt((String)entry.getKey()), qTestLog);
            }
            return qTestReport;
        }
        catch (JsonException ex) {
            throw new QTestInvalidFormatException(ex.getMessage());
        }
    }

    public static IntegratedEntity getIntegratedEntityByQTestReport(QTestReport qTestReport) {
        if (qTestReport == null) {
            return null;
        }
        IntegratedEntity integratedEntity = new IntegratedEntity();
        integratedEntity.setProductName("qTest");
        integratedEntity.setType(IntegratedType.REPORT);
        for (Map.Entry<Integer, QTestLog> entry : qTestReport.getTestLogMap().entrySet()) {
            String key = Integer.toString(entry.getKey());
            StringBuilder valueBuilder = new StringBuilder(new JsonObject(entry.getValue().getProperties()).toString());
            String value = valueBuilder.toString().replace("\"", "'").replace("},", "},\n");
            integratedEntity.getProperties().put(key, value);
        }
        return integratedEntity;
    }

    public static QTestLog uploadTestLog(String projectDir, QTestLogUploadedPreview preparedTestCaseResult, String tempDir, TestSuiteLogRecord testSuiteLogRecord) throws QTestException, IOException, URISyntaxException, ZipUtil.FileCompressionException {
        Object message;
        QTestProject qTestProject = preparedTestCaseResult.getQTestProject();
        QTestTestCase qTestCase = preparedTestCaseResult.getQTestCase();
        QTestRun qTestRun = preparedTestCaseResult.getQTestRun();
        QTestLog qTestLog = preparedTestCaseResult.getQTestLog();
        TestCaseLogRecord testCaseLogRecord = preparedTestCaseResult.getTestCaseLogRecord();
        File logFolder = new File(testSuiteLogRecord.getLogFolder());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        String startDate = sdf.format(testCaseLogRecord.getStartTime());
        String endDate = sdf.format(testCaseLogRecord.getEndTime());
        Long testLongVersionId = null;
        if (!QTestSettingStore.isSubmitResultToLatestVersionActive(projectDir)) {
            testLongVersionId = qTestCase.getVersionId();
        }
        Object object = message = qTestLog != null ? qTestLog.getMessage() : testCaseLogRecord.getMessage();
        if (testSuiteLogRecord.getRunData() != null && testSuiteLogRecord.getRunData().containsKey("browser")) {
            message = (String)message + "\nBrowser: " + (String)testSuiteLogRecord.getRunData().get("browser");
        }
        QTestSettingCredential credential = QTestSettingCredential.getCredential(projectDir);
        TestStatus.TestStatusValue testCaseStatus = testCaseLogRecord.getStatus().getStatusValue();
        HashMap<String, Object> bodyProperties = new HashMap<String, Object>();
        bodyProperties.put("exe_start_date", startDate);
        bodyProperties.put("exe_end_date", endDate);
        bodyProperties.put("status", QTestIntegrationReportManager.getMappedStatus(testCaseStatus, projectDir));
        if (!testSuiteLogRecord.getQtestBuildNumber().equals("")) {
            bodyProperties.put("build_number", testSuiteLogRecord.getQtestBuildNumber());
        }
        if (!testSuiteLogRecord.getQtestBuildURL().equals("")) {
            bodyProperties.put("build_url", testSuiteLogRecord.getQtestBuildURL());
        }
        bodyProperties.put("test_case_version_id", testLongVersionId != null ? testLongVersionId : "");
        bodyProperties.put("note", QTestIntegrationTestCaseManager.getUploadedDescription((String)message));
        boolean attachmentIncluded = false;
        if (qTestLog != null && qTestLog.isAttachmentIncluded() || qTestLog == null && QTestIntegrationReportManager.isAvailableForSendingAttachment(testCaseStatus, projectDir)) {
            ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
            File logTempFolder = new File(tempDir, FilenameUtils.getBaseName((String)logFolder.getName()));
            if (logTempFolder.exists()) {
                FileUtils.deleteDirectory((File)logTempFolder);
            }
            logTempFolder.mkdirs();
            for (ReportFormatType formatType : QTestSettingStore.getFormatReportTypes(projectDir)) {
                if (formatType == ReportFormatType.LOG) {
                    File[] fileArray = logFolder.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReportFormatType format;
                        File reportEntry = fileArray[n2];
                        if (QTestIntegrationReportManager.isValidFileToAttach(reportEntry, projectDir) && (format = ReportFormatType.getTypeByExtension((String)FilenameUtils.getExtension((String)reportEntry.getAbsolutePath()))) == ReportFormatType.LOG && !QTestIntegrationReportManager.extractTestCaseLog(testSuiteLogRecord, testCaseLogRecord, logTempFolder)) {
                            QTestIntegrationReportManager.moveReportFile(reportEntry, new File(logTempFolder, reportEntry.getName()));
                        }
                        ++n2;
                    }
                    continue;
                }
                if (formatType == ReportFormatType.PNG) {
                    QTestIntegrationReportManager.generatePNGReportFiles(logFolder, logTempFolder);
                    continue;
                }
                File newReportFile = new File(logTempFolder, FilenameUtils.getBaseName((String)logFolder.getAbsolutePath()) + "." + formatType.getFileExtension());
                QTestIntegrationReportManager.generateReportFile(formatType, newReportFile, testCaseLogRecord, testSuiteLogRecord, logFolder);
            }
            File[] fileArray = logTempFolder.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File reportTempFile = fileArray[n3];
                JsonObject attachment = QTestIntegrationReportManager.getAttachmentJsonObject(reportTempFile.getAbsolutePath());
                if (attachment != null) {
                    jsonObjects.add(attachment);
                }
                ++n3;
            }
            bodyProperties.put("attachments", new JsonArray(jsonObjects));
            attachmentIncluded = true;
            try {
                FileUtils.cleanDirectory((File)logTempFolder);
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
            }
        }
        String result = QTestIntegrationReportManager.uploadTestResult(credential, qTestProject.getId(), qTestRun.getId(), new JsonObject(bodyProperties).toString());
        try {
            if (result != null && !result.isEmpty()) {
                JsonObject testLogJsonObject = new JsonObject(result);
                QTestLog returnedQTestLog = new QTestLog();
                returnedQTestLog.setId(testLogJsonObject.getLong("id"));
                returnedQTestLog.setName(qTestCase.getName());
                returnedQTestLog.setAttachmentIncluded(attachmentIncluded);
                returnedQTestLog.setMessage((String)message);
                return returnedQTestLog;
            }
            return null;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    private static String getMappedStatus(TestStatus.TestStatusValue status, String projectDir) {
        List<ExecutionStatusMapping> mappings = QTestSettingStore.getExecutionStatusMappings(projectDir);
        for (ExecutionStatusMapping mapping : mappings) {
            if (!mapping.getKatalonStatus().equals(status.toString())) continue;
            return mapping.getQTestStatus();
        }
        return null;
    }

    private static void moveReportFile(File sourceReportFile, File destReportFile) throws IOException {
        FileUtils.copyFile((File)sourceReportFile, (File)destReportFile);
    }

    private static void generateReportFile(ReportFormatType format, File destReportFile, TestCaseLogRecord testCaseLogRecord, TestSuiteLogRecord testSuiteLR, File logFolder) throws IOException, URISyntaxException {
        ReportSettings settings = ReportSettingStore.getStore().getSettings();
        switch (format) {
            case CSV: {
                ReportUtil.writeLogRecordToCSVFile((TestSuiteLogRecord)testSuiteLR, (File)destReportFile, Arrays.asList(testCaseLogRecord));
                break;
            }
            case HTML: {
                ReportUtil.writeLogRecordToHTMLFile((ReportWriterUtil.SuiteReportGenerationOptions)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)ReportWriterUtil.SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(testSuiteLR).filteredTestCases(Arrays.asList(testCaseLogRecord)).settings(settings)).reportDir(logFolder)).outputFile(destReportFile)).build());
                break;
            }
            case PDF: {
                QTestIntegrationReportManager.checkPDFReportInProject(format, logFolder, destReportFile);
            }
        }
    }

    private static void checkPDFReportInProject(ReportFormatType formatType, File logFolder, File destReportFile) {
        try {
            File[] pdfReportFiles;
            if (logFolder.exists() && (pdfReportFiles = QTestIntegrationReportManager.getPDFReport(logFolder)) != null && pdfReportFiles.length > 0) {
                FileUtils.copyFile((File)pdfReportFiles[0], (File)destReportFile);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static File[] getPDFReport(File folder) {
        return folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".pdf");
            }
        });
    }

    private static void generatePNGReportFiles(File logFolder, File logTempFolder) {
        try {
            if (logFolder.exists()) {
                File[] pngFiles;
                File[] fileArray = pngFiles = QTestIntegrationReportManager.getPNGReport(logFolder);
                int n = pngFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    File destFile = new File(logTempFolder, FilenameUtils.getBaseName((String)file.getAbsolutePath()) + ".png");
                    MediaUtils.optimizeImage((File)file, (File)destFile);
                    ++n2;
                }
            }
        }
        catch (IOException error) {
            LogUtil.logError((Throwable)error);
        }
    }

    private static File[] getPNGReport(File folder) {
        return folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".png");
            }
        });
    }

    private static boolean isValidFileToAttach(File file, String projectDir) {
        String fileExt = FilenameUtils.getExtension((String)file.getAbsolutePath());
        return QTestSettingStore.getFormatReportTypes(projectDir).contains(ReportFormatType.getTypeByExtension((String)fileExt));
    }

    private static JsonObject getAttachmentJsonObject(String filePath) throws QTestException, IOException, ZipUtil.FileCompressionException {
        File file = new File(filePath);
        String contentType = "";
        String fileContent = "";
        String fileName = "";
        if (file.isFile()) {
            fileName = file.getName();
            fileContent = FileUtil.readFileAsBase64((File)file);
            ReportFormatType format = ReportFormatType.getTypeByExtension((String)FilenameUtils.getExtension((String)filePath));
            if (format == null) {
                contentType = "application/octet-stream";
            } else {
                switch (format) {
                    case CSV: {
                        contentType = "text/csv";
                        break;
                    }
                    case HTML: {
                        contentType = "text/html";
                        break;
                    }
                    case LOG: {
                        contentType = "application/xml";
                        break;
                    }
                    case PDF: {
                        contentType = "application/pdf";
                        break;
                    }
                    case PNG: {
                        contentType = "image/png";
                        break;
                    }
                }
            }
        } else {
            Path tempFolder = Files.createTempDirectory("katalon-qtest", new FileAttribute[0]);
            File tempFile = new File(tempFolder.toFile(), file.getName() + ".zip");
            try {
                ZipUtil.compressFolder(tempFile, file);
                fileContent = FileUtil.readFileAsBase64((File)tempFile);
                fileName = tempFile.getName();
                contentType = "application/zip";
            }
            finally {
                FileUtils.deleteQuietly((File)tempFolder.toFile());
            }
        }
        if (StringUtils.isBlank((String)fileName)) {
            return null;
        }
        LinkedHashMap<String, String> attachmentObject = new LinkedHashMap<String, String>();
        attachmentObject.put("name", fileName);
        attachmentObject.put("content_type", contentType);
        attachmentObject.put("data", fileContent);
        return new JsonObject(attachmentObject);
    }

    private static boolean isAvailableForSendingAttachment(TestStatus.TestStatusValue status, String projectDir) {
        QTestAttachmentSendingType statusSendingType = null;
        switch (status) {
            case ERROR: {
                statusSendingType = QTestAttachmentSendingType.SEND_IF_FAILS;
                break;
            }
            case FAILED: {
                statusSendingType = QTestAttachmentSendingType.SEND_IF_FAILS;
                break;
            }
            case PASSED: {
                statusSendingType = QTestAttachmentSendingType.SEND_IF_PASSES;
                break;
            }
        }
        return QTestSettingStore.getAttachmentSendingTypes(projectDir).contains((Object)statusSendingType);
    }

    public static boolean isAvailableForSendingResult(String projectDir) {
        return true;
    }

    public static String uploadTestResult(IQTestCredential credential, long projectId, long testRunId, String postBody) throws QTestException {
        String url = String.format(credential.getServerUrl() + "/api/v3/projects/%s/test-runs/%s/auto-test-logs", projectId, testRunId);
        String resText = QTestAPIRequestHelper.sendPostRequestViaAPI(url, credential.getToken(), postBody);
        return resText;
    }

    public static QTestDefect submitDefect(IQTestCredential credential, long projectId, String postBody) throws QTestException {
        String url = String.format(credential.getServerUrl() + "/api/v3/projects/%s/defects", projectId);
        String res = QTestAPIRequestHelper.sendPostRequestViaAPI(url, credential.getToken(), postBody);
        try {
            JsonObject jo = new JsonObject(res);
            QTestDefect defect = new QTestDefect(jo.getLong("id"), "");
            defect.setGid(jo.getString("pid"));
            return defect;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(res);
        }
    }

    public static List<QTestDefectField> getDefectFields(IQTestCredential credential, long projectId) throws QTestException {
        ArrayList<QTestDefectField> list = new ArrayList<QTestDefectField>();
        String url = credential.getServerUrl() + "/api/v3/projects/" + projectId + "/defects/fields";
        String json = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonArray jArr = new JsonArray(json);
            int i = 0;
            while (i < jArr.length()) {
                JsonObject jo = jArr.getJsonObject(i);
                QTestDefectField field = QTestIntegrationReportManager.parseToGetDefectField(jo, new QTestDefectField());
                if (jo.has("allowed_values")) {
                    JsonArray allowedValues = new JsonArray(jo.getString("allowed_values"));
                    int j = 0;
                    while (j < allowedValues.length()) {
                        JsonObject valueObject = allowedValues.getJsonObject(j);
                        QTestDefectField subField = QTestIntegrationReportManager.parseToGetDefectField(valueObject, new QTestDefectField());
                        subField.setMainField(field);
                        field.getAllowedValues().add(subField);
                        ++j;
                    }
                }
                list.add(field);
                ++i;
            }
            return list;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(json);
        }
    }

    private static QTestDefectField parseToGetDefectField(JsonObject jo, QTestDefectField field) throws JsonException {
        long id;
        String name = jo.getString("label");
        long l = id = jo.has("id") ? jo.getLong("id") : jo.getLong("value");
        if (field == null) {
            field = new QTestDefectField(id, name);
        } else {
            field.setId(id);
            field.setName(name);
        }
        return field;
    }

    public static List<QTestStepLog> getStepLogs(IQTestCredential credential, long qTestProjectId, long qTestRunId) throws QTestException {
        ArrayList<QTestStepLog> stepLogs = new ArrayList<QTestStepLog>();
        String url = String.format("%s/api/v3/projects/%s/test-runs/%s/test-logs/last-run?expand=teststeplog.teststep", credential.getServerUrl(), qTestProjectId, qTestRunId);
        String resText = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonObject jo = new JsonObject(resText);
            JsonArray jarrStepLogs = jo.getJsonArray("test_step_logs");
            int i = 0;
            while (i < jarrStepLogs.length()) {
                jo = jarrStepLogs.getJsonObject(i);
                QTestStepLog stepLog = new QTestStepLog();
                stepLog.setqTestStepId(jo.getLong("test_step_id"));
                stepLogs.add(stepLog);
                JsonArray jarrLinks = jo.getJsonArray("links");
                int j = 0;
                while (j < jarrLinks.length()) {
                    String rel = jarrLinks.getJsonObject(j).getString("rel");
                    if (rel.equals("self")) {
                        String href = jarrLinks.getJsonObject(j).getString("href");
                        String strId = href.substring(href.indexOf("/test-steps/") + "/test-steps/".length());
                        stepLog.setId(Long.parseLong(strId));
                        stepLog.setSelfLink(href);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return stepLogs;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(resText);
        }
    }

    private static boolean extractTestCaseLog(TestSuiteLogRecord testSuiteLogRecord, TestCaseLogRecord testCaseLogRecord, File toFolder) {
        Logger logger = Logger.getLogger("");
        try {
            FileHandler fileHandler = new FileHandler(toFolder.getAbsolutePath() + File.separator + "execution.log");
            fileHandler.setFormatter((Formatter)new CustomXmlFormatter());
            logger.addHandler(fileHandler);
            ArrayList<XmlLogRecord> logRecs = new ArrayList<XmlLogRecord>();
            String testCaseId = testCaseLogRecord.getId();
            boolean foundTest = false;
            int foundTestNestedLevel = -1;
            for (XmlLogRecord rc : ReportUtil.getAllLogRecords((String)testSuiteLogRecord.getLogFolder())) {
                String level = rc.getLevel().getName();
                String methodName = rc.getSourceMethodName();
                int nestedLevel = rc.getNestedLevel();
                if (level.equals(LogLevel.START.toString()) && "startSuite".equals(methodName) || level.equals(LogLevel.END.toString()) && "endSuite".equals(methodName)) {
                    logRecs.add(rc);
                    continue;
                }
                if (level.equals(LogLevel.START.toString()) && "startTest".equals(methodName) && testCaseId.equals(rc.getProperties().get("id"))) {
                    foundTest = true;
                    foundTestNestedLevel = rc.getNestedLevel();
                    logRecs.add(rc);
                    continue;
                }
                if (!foundTest) continue;
                if (level.equals(LogLevel.START.toString()) && "startTest".equals(methodName) && nestedLevel <= foundTestNestedLevel) {
                    foundTest = false;
                    continue;
                }
                logRecs.add(rc);
                if (!level.equals(LogLevel.END.toString()) || !"endTest".equals(methodName) || !testCaseId.equals(rc.getProperties().get("id")) || nestedLevel != foundTestNestedLevel) continue;
                foundTest = false;
            }
            for (XmlLogRecord rc : logRecs) {
                logger.log((LogRecord)rc);
            }
            fileHandler.flush();
            fileHandler.close();
            return true;
        }
        catch (XMLParserException | IOException | SecurityException | XMLStreamException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }
}

