/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.admin.dto;

import com.kms.katalon.admin.dto.OrganizationDto;
import com.kms.katalon.admin.dto.ProjectDto;
import com.kms.katalon.admin.dto.UserConfigDto;
import com.kms.katalon.session.core.model.UserInfo;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

public class UserInfoDto {
    private UserConfigDto configs;
    private String email;
    private String firstName;
    private String fullName;
    private Long id;
    private String lastName;
    private List<OrganizationDto> organizations;
    private List<ProjectDto> projects;
    private boolean samlSSO;
    private String trialExpirationDate;

    public UserConfigDto getConfigs() {
        return this.configs;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Long getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public List<OrganizationDto> getOrganizations() {
        return this.organizations;
    }

    public List<ProjectDto> getProjects() {
        return this.projects;
    }

    public String getTrialExpirationDate() {
        return this.trialExpirationDate;
    }

    public boolean isSamlSSO() {
        return this.samlSSO;
    }

    public void setConfigs(UserConfigDto configs) {
        this.configs = configs;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setOrganizations(List<OrganizationDto> organizations) {
        this.organizations = organizations;
    }

    public void setProjects(List<ProjectDto> projects) {
        this.projects = projects;
    }

    public void setSamlSSO(boolean samlSSO) {
        this.samlSSO = samlSSO;
    }

    public void setTrialExpirationDate(String trialExpirationDate) {
        this.trialExpirationDate = trialExpirationDate;
    }

    public UserInfo toDomainModel() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        UserInfo userInfo = new UserInfo();
        userInfo.setEmail(this.email);
        userInfo.setFirstName(this.firstName);
        userInfo.setFullName(this.fullName);
        userInfo.setId(this.id);
        userInfo.setLastName(this.lastName);
        userInfo.setSamlSSO(this.samlSSO);
        ZonedDateTime trialExpirationDate = this.trialExpirationDate == null ? null : ZonedDateTime.parse(this.trialExpirationDate, formatter);
        userInfo.setTrialExpirationDate(trialExpirationDate);
        userInfo.setConfigs(this.configs.toDomainModel());
        userInfo.setOrganizations(null);
        userInfo.setProjects(null);
        if (this.organizations != null) {
            userInfo.setOrganizations(this.organizations.stream().map(OrganizationDto::toDomainModel).collect(Collectors.toList()));
        }
        if (this.projects != null) {
            userInfo.setProjects(this.projects.stream().map(ProjectDto::toDomainModel).collect(Collectors.toList()));
        }
        return userInfo;
    }
}

