/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.authentication.services;

import com.katalon.authentication.dto.KatOneTokenDto;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.UrlInvalidException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.AuthenticationRequest;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.session.core.model.exception.AuthenticationException;
import com.kms.katalon.session.core.services.IAuthenticationService;
import jakarta.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AuthenticationService
implements IAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationService.class);
    private final String REDIRECT_URI = "katalonstudio://oidc/callback";
    private final String SCOPE = "openid";
    private final String PROMT = "login";
    private final String CLIENT_ID = "katalon-studio";
    private final String RESPONSE_TYPE = "code";
    private final String AUTHENTICATION_CLIENT_ID_PARAM = "client_id";
    private final String AUTHENTICATION_REDIRECT_URL_PARAM = "redirect_uri";
    private final String AUTHENTICATION_RESPONSE_TYPE_PARAM = "response_type";
    private final String AUTHENTICATION_SCOPE_PARAM = "scope";
    private final String AUTHENTICATION_PROMPT_PARAM = "prompt";
    private final String AUTHENTICATION_CODE_CHALLENGE_PARAM = "code_challenge";
    private final String AUTHENTICATION_CODE_CHALLENGE_METHOD_PARAM = "code_challenge_method";
    private final String AUTHENTICATION_GRANT_TYPE_PARAM = "grant_type";
    private final String AUTHENTICATION_CODE_PARAM = "code";
    private final String AUTHENTICATION_CODE_VERIFIER_PARAM = "code_verifier";
    private final String AUTHENTICATION_REFRESH_TOKEN_PARAM = "refresh_token";
    private final String AUTHENTICATION_REFRESH_TOKEN = "refresh_token";
    private final String AUTHENTICATION_AUTHORIZATION_CODE = "authorization_code";
    @Inject
    IDiscoveryService discoveryService;
    @Inject
    IHttpClient httpClient;
    @Inject
    INetworkPreferences networkPreferences;

    public AuthenticationRequest buildAuthenticationRequest() throws AuthenticationException {
        String codeChallenge;
        String codeVerifier;
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.setRedirectUri("katalonstudio://oidc/callback");
        try {
            codeVerifier = this.generateCodeVerifier();
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException("Failed to generate code verify!", (Throwable)e);
        }
        authenticationRequest.setCodeVerifier(codeVerifier);
        try {
            codeChallenge = this.generateCodeChallange(codeVerifier);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AuthenticationException("Failed to generate code challenge!", (Throwable)e);
        }
        try {
            String authenticationServerUrl = this.discoveryService.getServerUrl(ServerType.AUTHENTICATION);
            String authenticationPath = "realms/katalon/protocol/openid-connect/auth";
            URI baseUri = new URI(authenticationServerUrl);
            URIBuilder authenticationUriBuilder = new URIBuilder();
            authenticationUriBuilder.setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(authenticationPath).addParameter("client_id", "katalon-studio").addParameter("redirect_uri", "katalonstudio://oidc/callback").addParameter("response_type", "code").addParameter("scope", "openid").addParameter("prompt", "login").addParameter("code_challenge", codeChallenge).addParameter("code_challenge_method", "S256");
            authenticationRequest.setAuthenticationUrl(authenticationUriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException("Invalid server url!", (Throwable)e);
        }
        return authenticationRequest;
    }

    public AuthenticationToken getKatOneToken(AuthenticationRequest authenticationRequest) throws AuthenticationException, UrlInvalidException, NetworkErrorException, MalformedContentException {
        HttpResponse response;
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.AUTHENTICATION);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("realms/katalon/protocol/openid-connect/token");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("grant_type", "authorization_code");
        body.put("client_id", "katalon-studio");
        body.put("code", authenticationRequest.getCode());
        body.put("code_verifier", authenticationRequest.getCodeVerifier());
        body.put("redirect_uri", authenticationRequest.getRedirectUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            response = this.httpClient.formPost(uri, body, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        KatOneTokenDto katOneTokenDto = (KatOneTokenDto)response.json(KatOneTokenDto.class);
        return katOneTokenDto.convertToAuthenticationToken();
    }

    public AuthenticationToken refreshKatOneToken(AuthenticationToken katOneToken) throws AuthenticationException, NetworkErrorException, MalformedContentException, URISyntaxException {
        HttpResponse response;
        String refreshToken = katOneToken.getRefreshToken();
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw new AuthenticationException("Cannot find valid katOne's refreshToken");
        }
        KatOneJwtToken jwtToken = KatOneJwtToken.parseToken((String)katOneToken.getRefreshToken());
        if (jwtToken.isExpired()) {
            throw new AuthenticationException("The katOne's refreshToken has been expired!");
        }
        if (!jwtToken.getAzp().endsWith("katalon-studio")) {
            throw new AuthenticationException("The katOne's token was not issued by Katalon Studio");
        }
        String baseUrl = this.discoveryService.getServerUrl(ServerType.AUTHENTICATION);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new AuthenticationException("The authentication server not found!");
        }
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("realms/katalon/protocol/openid-connect/token");
        URI uri = uriBuilder.build();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("grant_type", "refresh_token");
        body.put("client_id", "katalon-studio");
        body.put("refresh_token", katOneToken.getRefreshToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
        try {
            response = this.httpClient.formPost(uri, body, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        KatOneTokenDto katOneTokenDto = (KatOneTokenDto)response.json(KatOneTokenDto.class);
        return katOneTokenDto.convertToAuthenticationToken();
    }

    public void revokeKatOneToken(AuthenticationToken katOneToken) throws AuthenticationException, UrlInvalidException, NetworkErrorException {
        HttpResponse response;
        long currentEpoch = Instant.now().getEpochSecond();
        KatOneJwtToken jwtToken = KatOneJwtToken.parseToken((String)katOneToken.getRefreshToken());
        if (jwtToken == null) {
            return;
        }
        if (jwtToken.getExp() < currentEpoch) {
            return;
        }
        if (!jwtToken.getAzp().equals("katalon-studio")) {
            return;
        }
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.AUTHENTICATION);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("realms/katalon/protocol/openid-connect/logout");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("grant_type", "authorization_code");
        body.put("client_id", "katalon-studio");
        body.put("refresh_token", katOneToken.getRefreshToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            response = this.httpClient.formPost(uri, body, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
    }

    private void handleError(int statusCode, String message) throws AuthenticationException {
        throw new AuthenticationException(message);
    }

    private void handleServerError(int statusCode, String message) throws AuthenticationException {
        throw new AuthenticationException(message);
    }

    private String generateCodeVerifier() throws UnsupportedEncodingException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] codeVerifier = new byte[32];
        secureRandom.nextBytes(codeVerifier);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(codeVerifier);
    }

    private String generateCodeChallange(String codeVerifier) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytes = codeVerifier.getBytes("US-ASCII");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(bytes, 0, bytes.length);
        byte[] digest = messageDigest.digest();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

