/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.amazonaws.util.EC2MetadataUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.common.About;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryManager;
import com.kms.katalon.license.models.AwsKatalonAmi;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.machine.utils.MachineUtil;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.UrlInvalidException;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.ActivationRequest;
import com.kms.katalon.session.core.model.AdminJwtToken;
import com.kms.katalon.session.core.model.AuthenticationRequest;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.session.core.model.KatalonPackage;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseResource;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Product;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.RememberMeOption;
import com.kms.katalon.session.core.model.RememberedApiKey;
import com.kms.katalon.session.core.model.RememberedCredential;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.model.UserConfig;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.model.UserOrganizationRole;
import com.kms.katalon.session.core.model.exception.AuthenticationException;
import com.kms.katalon.session.core.model.exception.LicenseException;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.IAdminService;
import com.kms.katalon.session.core.services.IAuthenticationService;
import com.kms.katalon.session.core.services.IFeatureManager;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.session.core.services.ISessionService;
import com.kms.katalon.session.utils.AwsKatalonUtil;
import com.kms.katalon.util.FileHashUtil;
import com.kms.katalon.util.NetworkUtil;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class SessionManager
implements ISessionManager {
    private final String MACHINE_ID_KATALON_AMI = "katalon-ami";
    private final String MACHINE_ID_BYPASS = "katalon-special-license";
    private static ISessionManager instance;
    private ScheduledFuture<?> checkingLicenseTask;
    private ScheduledFuture<?> checkingTokenTask;
    private final String DEFAULT_KATALON_AMI = "true";
    private final String ENV_KATALON_AMI = "KATALON_AMI";
    private final int TOKEN_BUFFER_MINUTES = 5;
    private final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final int DEFAULT_RETRY_DELAY_MILLIS = 5000;
    private final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private final String LICENSE_TYPE = Arrays.stream(LicenseType.values()).map(e -> e.name().toLowerCase()).collect(Collectors.joining(","));
    @Inject
    private IDiscoveryManager discoveryManager;
    @Inject
    private IAdminService adminService;
    @Inject
    private IAuthenticationService authService;
    @Inject
    private ISessionService sessionService;
    @Inject
    private AwsKatalonUtil awsUtil;
    @Inject
    private IFeatureManager featureManager;
    License license;
    String licenseFeature;
    AuthenticationToken adminToken;
    AuthenticationToken katOneToken;
    String idpType;
    String subdomain;
    String contextAction;
    Organization organization;
    Account account;
    User user;
    UserInfo userInfo;
    String hostname = this.getHostname();
    String katalonVersion = About.releaseVersion();
    String machineId = MachineUtil.getMachineId();
    String sessionId = UUID.randomUUID().toString();
    String userKey = this.hashMacAndHostName();
    SessionExpireSchedule.Reason lastExpireReason;

    public static ISessionManager getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(SessionManager.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (ISessionManager)ContextInjectionFactory.make(SessionManager.class, (IEclipseContext)context);
        }
        return instance;
    }

    public Session authenticateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        UserInfo userInfo;
        AuthenticationToken katOneToken;
        AuthenticationToken adminToken;
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            return new Session();
        }
        Organization organization = null;
        try {
            adminToken = this.adminService.getAdminToken(apiKey);
            katOneToken = this.parseKatOneToken(adminToken);
            userInfo = this.adminService.getUserInfo(adminToken);
        }
        catch (HttpException | AuthenticationException | URISyntaxException e) {
            throw new SessionException(e);
        }
        if (Objects.nonNull(organizationId)) {
            organization = userInfo.getOrganizations().stream().filter(o -> o.getId().compareTo(organizationId) == 0).findAny().orElse(null);
        }
        this.adminToken = adminToken;
        this.katOneToken = katOneToken;
        this.organization = organization;
        this.userInfo = userInfo;
        return this.getSession();
    }

    public Session activateOffline(String activationCode) throws SessionException {
        try {
            this.clearSession();
            LicenseResource licenseResource = new LicenseResource();
            licenseResource.setJwtCode(activationCode);
            Session session = this.parseLicenseResource(licenseResource, new Session());
            this.applySession(session, true);
            return this.getSession();
        }
        catch (SessionException sessionException) {
            return null;
        }
    }

    public Session activateWithApiKey(String apiKey) throws SessionException {
        return this.activateWithApiKey(apiKey, null);
    }

    public Session activateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        this.clearSession();
        Session newSession = this.authenticateWithApiKey(apiKey, organizationId);
        this.activateOnline(newSession);
        this.applySession(newSession, true);
        return this.getSession();
    }

    public Session activateWithAuthenticationRequest(AuthenticationRequest request) throws SessionException {
        AuthenticationToken adminToken;
        AuthenticationToken katOneToken;
        this.clearSession();
        try {
            katOneToken = this.authService.getKatOneToken(request);
            adminToken = this.adminService.getAdminToken(katOneToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            throw new SessionException(e);
        }
        Session newSession = new Session();
        newSession.setAdminToken(adminToken);
        newSession.setKatOneToken(katOneToken);
        newSession.setIdpType(request.getIdpType());
        newSession.setSubdomain(request.getSubdomain());
        newSession.setContextAction(request.getActionContext());
        try {
            this.activateOnline(newSession);
        }
        catch (SessionException e) {
            if (katOneToken != null) {
                try {
                    this.authService.revokeKatOneToken(katOneToken);
                }
                catch (NetworkErrorException | UrlInvalidException | AuthenticationException throwable) {}
            }
            throw e;
        }
        this.applySession(newSession, true);
        Session currentSession = this.getSession();
        this.safelyUpdateRememberMeApiKey();
        return currentSession;
    }

    public Session activateWithEngineAmiMachine() throws SessionException {
        if (!this.isRunOnAmiMachine()) {
            return null;
        }
        String amiMachineJwtCode = this.getAmiMachineLicense();
        if (StringUtils.isBlank((CharSequence)amiMachineJwtCode)) {
            return null;
        }
        return this.activateOffline(amiMachineJwtCode);
    }

    public Session activateWithPassword(String username, String password) throws SessionException {
        UserInfo userInfo;
        AuthenticationToken katOneToken;
        AuthenticationToken adminToken;
        this.clearSession();
        try {
            adminToken = this.adminService.getAdminToken(username, password);
            katOneToken = this.parseKatOneToken(adminToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            throw new SessionException(e);
        }
        try {
            String serverUrl = this.discoveryManager.getDiscoveryServerUrl();
            userInfo = this.adminService.getUserInfo(serverUrl, adminToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | URISyntaxException e) {
            throw new SessionException(e);
        }
        Session newSession = new Session();
        newSession.setAdminToken(adminToken);
        newSession.setKatOneToken(katOneToken);
        newSession.setUserInfo(userInfo);
        this.activateOnline(newSession);
        this.applySession(newSession, true);
        this.overrideEndpoints(userInfo.getConfigs());
        Session currentSession = this.getSession();
        this.safelyUpdateRememberMeApiKey();
        return currentSession;
    }

    private void safelyUpdateRememberMeApiKey() {
        try {
            this.sessionService.clearRememberedCredential();
        }
        catch (Exception e) {
            this.logger.warn("Failed to clear remembered credential", (Throwable)e);
        }
        try {
            if (!RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption())) {
                return;
            }
            ExecutorService fetchApiKeyThread = Executors.newFixedThreadPool(1);
            fetchApiKeyThread.submit(() -> {
                try {
                    RetryPolicy retryPolicy = RetryPolicy.builder().withMaxAttempts(3).withDelay(Duration.ofMillis(5000L)).build();
                    String apiKey = (String)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.adminService.fetchApiKey(this.adminToken));
                    if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                        this.sessionService.saveRememberedCredential((RememberedCredential)new RememberedApiKey(apiKey));
                        this.logger.info("Saved remember me credential");
                    } else {
                        this.logger.warn("User does not have valid API key to save for remember me option.");
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to query and save remember me API key", (Throwable)e);
                }
            });
            fetchApiKeyThread.shutdown();
        }
        catch (Exception e) {
            this.logger.error("Failed to query and save remember me API key", (Throwable)e);
        }
    }

    public boolean checkTestingOfflineLicense(File testingFile) throws SessionException {
        License testingLicense;
        block8: {
            block7: {
                String activationCode;
                block6: {
                    activationCode = FileUtils.readFileToString((File)testingFile, (Charset)Charset.forName("UTF-8"));
                    if (!StringUtils.isBlank((CharSequence)activationCode)) break block6;
                    return false;
                }
                LicenseResource licenseResource = new LicenseResource();
                licenseResource.setJwtCode(activationCode);
                testingLicense = this.parseJwtCode(licenseResource);
                if (testingLicense != null) break block7;
                return false;
            }
            if (testingLicense.isTesting()) break block8;
            return false;
        }
        try {
            this.featureManager.initFeatures(testingLicense);
            boolean isValid = this.isValidLicense(testingLicense);
            if (!isValid) {
                this.featureManager.clear();
            }
            return isValid;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SessionException((Throwable)e);
        }
    }

    public void logout() throws SessionException {
        try {
            try {
                AuthenticationToken katOneToken = this.katOneToken;
                this.deactivate();
                if (katOneToken != null) {
                    this.authService.revokeKatOneToken(katOneToken);
                }
            }
            catch (NetworkErrorException | UrlInvalidException | AuthenticationException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.applySession(null, true);
        }
    }

    public void deactivate() throws SessionException {
        if (this.license == null || this.license.isOffline()) {
            this.license = null;
            this.licenseFeature = null;
            return;
        }
        this.deactivateWithApiKey(null, null);
    }

    public void deactivateWithApiKey(String apiKey, Long organizationId) throws SessionException {
        try {
            this.logger.info("Start release license task");
            if (this.license == null || this.license.isOffline()) {
                this.license = null;
                this.licenseFeature = null;
                return;
            }
            try {
                AuthenticationToken adminToken = this.adminToken;
                if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                    try {
                        adminToken = this.adminService.getAdminToken(apiKey);
                    }
                    catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
                        throw new SessionException(e);
                    }
                }
                Session session = this.getSession();
                session.setAdminToken(adminToken);
                if (organizationId != null) {
                    Organization organization = new Organization();
                    organization.setId(organizationId);
                    session.setOrganization(organization);
                }
                this.adminService.releaseLicense(this.buildActivationRequest(session));
                this.logger.info("End release license task");
            }
            catch (NetworkErrorException | UrlInvalidException e) {
                throw new SessionException(e);
            }
        }
        finally {
            this.license = null;
            this.licenseFeature = null;
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public AuthenticationToken getAdminToken() {
        return this.adminToken;
    }

    public AuthenticationToken getKatOneToken() {
        return this.katOneToken;
    }

    public License getLicense() {
        return this.license;
    }

    public String getMacAddress() {
        String macAddress = "";
        try {
            String localhostAddress = NetworkUtil.getLocalHostAddress();
            macAddress = NetworkUtil.getMacAddress((String)localhostAddress);
        }
        catch (SocketException | UnknownHostException iOException) {}
        return (String)StringUtils.defaultIfBlank((CharSequence)macAddress, (CharSequence)"unknown");
    }

    public Organization getOrganization() {
        return this.organization;
    }

    private List<Organization> getAllOrganizations() {
        return this.userInfo != null ? this.userInfo.getOrganizations() : List.of();
    }

    private String extractAccountUuidFromKatoneToken(AuthenticationToken katOneToken) {
        if (katOneToken == null) {
            return null;
        }
        if (katOneToken.getAccessToken() == null) {
            return null;
        }
        KatOneJwtToken jwtToken = KatOneJwtToken.parseToken((String)katOneToken.getAccessToken());
        return Objects.nonNull(jwtToken) ? jwtToken.getAccountUuid() : null;
    }

    public List<Organization> getOrganizationsOfSelectedAccount() {
        List<Organization> allOrganizations = this.getAllOrganizations();
        if (this.account != null && this.account.getId() > 0L) {
            return allOrganizations.stream().filter(org -> Objects.equals(this.account.getId(), org.getAccountId())).collect(Collectors.toList());
        }
        String accountUuid = this.extractAccountUuidFromKatoneToken(this.katOneToken);
        if (StringUtils.isEmpty((CharSequence)accountUuid)) {
            return allOrganizations;
        }
        return allOrganizations.stream().filter(org -> StringUtils.isEmpty((CharSequence)org.getAccountUuid()) || accountUuid.equals(org.getAccountUuid())).collect(Collectors.toList());
    }

    public Session getSession() {
        Session session = new Session();
        session.setKatOneToken(this.katOneToken);
        session.setAdminToken(this.adminToken);
        session.setIdpType(this.idpType);
        session.setSubdomain(this.subdomain);
        session.setContextAction(this.contextAction);
        session.setUser(this.user);
        session.setOrganization(this.organization);
        session.setAccount(this.account);
        session.setUserInfo(this.userInfo);
        session.setLicense(this.license);
        session.setLicenseFeature(this.licenseFeature);
        session.setHostname(this.hostname);
        session.setUserKey(this.userKey);
        session.setMachineId(this.machineId);
        session.setSessionId(this.sessionId);
        session.setOs(Platform.getOS());
        String arch = Platform.getOSArch();
        session.setOsArch(arch);
        session.setOsType(arch.contains("64") ? "64" : "32");
        session.setOsVersion(System.getProperty("os.version"));
        session.setKatType(System.getProperty("sun.arch.data.model"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(About.version());
        String buildVersion = About.build();
        if (StringUtils.isNotBlank((CharSequence)buildVersion)) {
            stringBuilder.append(" build ");
            stringBuilder.append(buildVersion);
        }
        session.setKatVersion(stringBuilder.toString());
        session.setKatalonPackage(this.getKatalonPackage());
        session.setKatalonEdition(Product.getEdition());
        return session;
    }

    public User getUser() {
        return this.user;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public UserInfo getUserInfo(String serverUrl, AuthenticationToken adminToken) throws SessionException {
        try {
            return this.adminService.getUserInfo(serverUrl, adminToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | URISyntaxException e) {
            throw new SessionException(e);
        }
    }

    public void reactivation() throws SessionException {
        Session newSession = this.activateOnline(this.getSession());
        this.applySession(newSession, true);
    }

    public void renewTokens() throws SessionException {
        try {
            this.renewTokensByKatOneRefreshToken();
        }
        catch (Exception e) {
            this.logger.error("Failed to renew tokens by KatOne refresh token. Will try to use remember me if enabled.", (Throwable)e);
            this.renewTokensByRememberMe();
        }
    }

    private void renewTokensByKatOneRefreshToken() throws SessionException {
        if (this.katOneToken == null || this.katOneToken.getRefreshToken() == null) {
            throw new SessionException("No refresh token available for renewal.");
        }
        RunningMode runMode = ApplicationRunningMode.get();
        try {
            AuthenticationToken newKatOneToken = this.authService.refreshKatOneToken(this.katOneToken);
            if (Objects.nonNull(newKatOneToken)) {
                this.katOneToken = newKatOneToken;
                if (RunningMode.GUI.equals((Object)runMode)) {
                    this.sessionService.saveKatOneToken(newKatOneToken);
                }
            }
        }
        catch (JsonProcessingException | MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            throw new SessionException(e);
        }
        try {
            AuthenticationToken newAdminToken = this.adminService.getAdminToken(this.katOneToken);
            if (Objects.nonNull(newAdminToken)) {
                this.adminToken = newAdminToken;
                if (RunningMode.GUI.equals((Object)runMode)) {
                    this.sessionService.saveAdminToken(newAdminToken);
                }
            }
        }
        catch (JsonProcessingException | MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException e) {
            throw new SessionException(e);
        }
    }

    private TokenPair fetchNewTokensByRememberMe() throws SessionException {
        String rememberMeApiKey;
        if (!RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption())) {
            throw new SessionException("Cannot renew tokens because remember me option is not enabled.");
        }
        try {
            RememberedCredential rememberedCredential = this.sessionService.getRememberedCredential();
            if (rememberedCredential instanceof RememberedApiKey) {
                RememberedApiKey rememberedApiKeyObj = (RememberedApiKey)rememberedCredential;
                rememberMeApiKey = rememberedApiKeyObj.getValue();
            } else {
                rememberMeApiKey = null;
            }
        }
        catch (Exception e) {
            throw new SessionException("Cannot renew tokens because remember me API key is not available.", (Throwable)e);
        }
        if (StringUtils.isBlank(rememberMeApiKey)) {
            throw new SessionException("Cannot renew tokens because remember me API key is not available.");
        }
        this.logger.info("Renew tokens by remember me API key");
        try {
            RetryPolicy retryPolicy = RetryPolicy.builder().withMaxAttempts(3).withDelay(Duration.ofMillis(5000L)).build();
            AuthenticationToken newAdminToken = (AuthenticationToken)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.adminService.getAdminToken(rememberMeApiKey));
            AuthenticationToken newKatOneToken = this.parseKatOneToken(newAdminToken);
            return new TokenPair(newAdminToken, newKatOneToken);
        }
        catch (Exception e) {
            throw new SessionException("Failed to renew tokens by remember me API key.", (Throwable)e);
        }
    }

    private void renewTokensByRememberMe() throws SessionException {
        TokenPair tokens = this.fetchNewTokensByRememberMe();
        this.saveRenewedTokens(tokens.adminToken, tokens.katOneToken);
    }

    private void saveRenewedTokens(AuthenticationToken newAdminToken, AuthenticationToken newKatOneToken) throws SessionException {
        RunningMode runMode = ApplicationRunningMode.get();
        try {
            if (Objects.nonNull(newAdminToken)) {
                this.adminToken = newAdminToken;
                if (RunningMode.GUI.equals((Object)runMode)) {
                    this.sessionService.saveAdminToken(newAdminToken);
                }
            }
            if (Objects.nonNull(newKatOneToken)) {
                this.katOneToken = newKatOneToken;
                if (RunningMode.GUI.equals((Object)runMode)) {
                    this.sessionService.saveKatOneToken(newKatOneToken);
                }
            }
        }
        catch (Exception e) {
            throw new SessionException("Failed to save renewed tokens.", (Throwable)e);
        }
    }

    public Session restoreSession() throws SessionException {
        License license;
        block13: {
            block14: {
                license = null;
                try {
                    String licenseJwt = this.sessionService.getLicense();
                    license = License.parseJwt((String)licenseJwt);
                    if (license == null || !license.isOffline()) break block13;
                    this.featureManager.initFeatures(license);
                    if (this.isValidLicense(license)) break block14;
                    this.featureManager.clear();
                    return null;
                }
                catch (Exception exception) {}
            }
            Session offlineSession = new Session();
            offlineSession.setLicense(license);
            this.applySession(offlineSession, true);
            return offlineSession;
        }
        AuthenticationToken adminToken = null;
        AuthenticationToken katOneToken = null;
        Organization organization = null;
        try {
            adminToken = this.sessionService.getAdminToken();
            katOneToken = this.sessionService.getKatOneToken();
            organization = this.sessionService.getOrganization();
        }
        catch (JsonProcessingException jsonProcessingException) {}
        if (adminToken == null || katOneToken == null || organization == null) {
            return null;
        }
        try {
            String katOneRefreshToken = katOneToken.getRefreshToken();
            if (StringUtils.isNotEmpty((CharSequence)katOneRefreshToken)) {
                katOneToken = this.authService.refreshKatOneToken(katOneToken);
            }
            adminToken = this.adminService.getAdminToken(katOneToken);
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | AuthenticationException | URISyntaxException throwable) {
            try {
                TokenPair newTokens = this.fetchNewTokensByRememberMe();
                katOneToken = newTokens.katOneToken;
                adminToken = newTokens.adminToken;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Session currentSession = new Session();
        currentSession.setAdminToken(adminToken);
        currentSession.setKatOneToken(katOneToken);
        currentSession.setOrganization(organization);
        currentSession.setLicense(license);
        currentSession.setIdpType(this.sessionService.getIdpType());
        currentSession.setSubdomain(this.sessionService.getSubDomain());
        Session newSession = this.activateOnline(currentSession);
        license = newSession.getLicense();
        if (!this.isValidLicense(license)) {
            return null;
        }
        if (newSession.getOrganization() == null) {
            newSession.setOrganization(organization);
        }
        this.applySession(newSession, true);
        this.setOrganization(newSession.getOrganization());
        return this.getSession();
    }

    public void setOrganization(Organization organization) throws SessionException {
        this.organization = organization;
        try {
            RunningMode runMode = ApplicationRunningMode.get();
            if (RunningMode.GUI.equals((Object)runMode)) {
                this.sessionService.saveOrganization(organization);
            }
        }
        catch (JsonProcessingException e) {
            throw new SessionException((Throwable)e);
        }
        Account account = new Account();
        account.setId(organization.getAccountId());
        this.account = account;
        try {
            RunningMode runMode = ApplicationRunningMode.get();
            if (RunningMode.GUI.equals((Object)runMode)) {
                this.sessionService.saveAccount(account);
            }
        }
        catch (JsonProcessingException e) {
            throw new SessionException((Throwable)e);
        }
    }

    public AuthenticationRequest setupAuthenticationRequest() throws SessionException {
        try {
            return this.authService.buildAuthenticationRequest();
        }
        catch (AuthenticationException e) {
            throw new SessionException((Throwable)e);
        }
    }

    private Session activateOnline(Session session) throws SessionException {
        LicenseResource licenseResource;
        try {
            String serverUrl = this.discoveryManager.getDiscoveryServerUrl();
            if (this.discoveryManager.isDiscovered()) {
                serverUrl = this.discoveryManager.getServerUrl(ServerType.ADMIN);
            }
            if (session.getUserInfo() == null) {
                UserInfo userInfo = this.adminService.getUserInfo(serverUrl, session.getAdminToken());
                session.setUserInfo(userInfo);
            }
        }
        catch (MalformedContentException | NetworkErrorException | UrlInvalidException | URISyntaxException throwable) {
            return session;
        }
        try {
            licenseResource = this.adminService.activate(this.buildActivationRequest(session));
        }
        catch (LicenseException e) {
            throw new SessionException((Throwable)e);
        }
        this.parseLicenseResource(licenseResource, session);
        return session;
    }

    private ActivationRequest buildActivationRequest(Session session) {
        String subDomain;
        String idpType;
        License license;
        Organization organization;
        ActivationRequest activationRequest = new ActivationRequest();
        activationRequest.setMachineId(this.machineId);
        activationRequest.setSessionId(this.sessionId);
        activationRequest.setKatalonVersion(this.katalonVersion);
        activationRequest.setHostname(this.hostname);
        activationRequest.setKatalonPackage(this.getKatalonPackage());
        activationRequest.setLicenseType(this.LICENSE_TYPE);
        AuthenticationToken adminToken = session.getAdminToken();
        if (adminToken != null) {
            activationRequest.setAdminToken(adminToken);
        }
        if ((organization = session.getOrganization()) != null && ((license = session.getLicense()) == null || LicenseType.ENTERPRISE.equals((Object)license.getLicenseType()))) {
            activationRequest.setOrganizationId(Long.toString(organization.getId()));
        }
        if (!Objects.isNull(idpType = session.getIdpType())) {
            activationRequest.setIdpType(idpType);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subDomain = session.getSubdomain()})) {
            activationRequest.setSubdomain(subDomain);
        }
        return activationRequest;
    }

    private String getAmiMachineLicense() {
        AwsKatalonAmi awsKatalonAmi;
        List productCodes;
        block7: {
            block6: {
                productCodes = EC2MetadataUtils.getProductCodes();
                if (productCodes != null) break block6;
                return null;
            }
            awsKatalonAmi = this.awsUtil.getAwsKatalonAmi();
            if (awsKatalonAmi != null) break block7;
            return null;
        }
        try {
            productCodes.retainAll(awsKatalonAmi.getAmiIds());
            if (productCodes.size() > 0) {
                RunningMode runMode = ApplicationRunningMode.get();
                if (runMode == RunningMode.GUI) {
                    return awsKatalonAmi.getKseLicense();
                }
                return awsKatalonAmi.getKreLicense();
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    private String getHostname() {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            host = "unknown";
        }
        return host;
    }

    private KatalonPackage getKatalonPackage() {
        boolean isDevelopmentMode = Platform.inDevelopmentMode();
        boolean isRunningInKatalonC = this.isRunningInKatalonC();
        RunningMode runMode = ApplicationRunningMode.get();
        if (isRunningInKatalonC || isDevelopmentMode && runMode == RunningMode.CONSOLE) {
            return KatalonPackage.ENGINE;
        }
        return KatalonPackage.KSE;
    }

    private String hashMacAndHostName() {
        String hostname = this.getHostname();
        String macAddress = this.getMacAddress();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode rootNode = objectMapper.createObjectNode();
            rootNode.put("macAddress", macAddress);
            rootNode.put("hostname", hostname);
            String jsonString = objectMapper.writeValueAsString((Object)rootNode);
            return FileHashUtil.hash((String)jsonString, (String)"MD5");
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage());
            return macAddress;
        }
    }

    private boolean isRunningInKatalonC() {
        Properties props = System.getProperties();
        String launcherName = props.getProperty("eclipse.launcher.name");
        return "katalonc".equalsIgnoreCase(launcherName);
    }

    private boolean isRunOnAmiMachine() {
        try {
            String hasKatalonAmi = System.getenv("KATALON_AMI");
            return "true".equalsIgnoreCase(hasKatalonAmi);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    private License parseJwtCode(LicenseResource licenseResource) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (Objects.isNull(licenseResource) || StringUtils.isBlank((CharSequence)licenseResource.getJwtCode())) {
            return null;
        }
        String jwtCode = licenseResource.getJwtCode();
        if (licenseResource.getPublicKey() != null) {
            return License.parseJwt((String)jwtCode, (String)licenseResource.getPublicKey());
        }
        License license = License.parseJwt((String)jwtCode);
        license.setOrganization(licenseResource.getOrganization());
        return license;
    }

    private Session parseLicenseResource(LicenseResource licenseResource, Session session) throws SessionException {
        Account account;
        try {
            License license = this.parseJwtCode(licenseResource);
            this.featureManager.initFeatures(license);
            if (this.isValidLicense(license)) {
                license.setActivationNotice(licenseResource.getActivationNotice());
                session.setLicense(license);
            } else {
                this.featureManager.clear();
            }
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {}
        session.setLicenseFeature(licenseResource.getFeature());
        session.setUser(licenseResource.getUser());
        Organization organization = licenseResource.getOrganization();
        if (organization != null) {
            Long orgId = organization.getId();
            Organization membershipOrganization = session.getUserInfo().getOrganizations().stream().filter(org -> org.getId().equals(orgId)).findFirst().orElse(null);
            if (membershipOrganization == null) {
                organization.setRole(UserOrganizationRole.USER.getValue());
            } else {
                organization = membershipOrganization;
            }
            session.setOrganization(organization);
        }
        if ((account = licenseResource.getAccount()) != null) {
            session.setAccount(account);
        }
        return session;
    }

    private void clearSession() throws SessionException {
        this.sessionId = UUID.randomUUID().toString();
        this.applySession(null, false);
    }

    private void applySession(Session session, boolean persist) throws SessionException {
        if (session == null) {
            session = new Session();
        }
        AuthenticationToken adminToken = session.getAdminToken();
        AuthenticationToken katOneToken = session.getKatOneToken();
        String idpType = session.getIdpType();
        String subdomain = session.getSubdomain();
        License license = session.getLicense();
        String licenseJwt = license != null ? license.getJwt() : null;
        String licenseFeature = session.getLicenseFeature();
        User user = session.getUser();
        Account account = session.getAccount();
        Organization organization = session.getOrganization();
        boolean saveOrg = license == null || license.getOrganization() == null;
        UserInfo userInfo = session.getUserInfo();
        String contextAction = session.getContextAction();
        if (persist && RunningMode.GUI.equals((Object)ApplicationRunningMode.get())) {
            try {
                this.sessionService.saveIdpType(idpType);
                this.sessionService.saveSubDomain(subdomain);
                if (saveOrg) {
                    this.sessionService.saveOrganization(organization);
                }
                this.sessionService.saveAdminToken(adminToken);
                this.sessionService.saveKatOneToken(katOneToken);
                this.sessionService.saveUser(user);
                this.sessionService.saveAccount(account);
                this.sessionService.saveLicense(licenseJwt);
            }
            catch (JsonProcessingException e) {
                throw new SessionException("Failed to save session!", (Throwable)e);
            }
        }
        this.adminToken = adminToken;
        this.katOneToken = katOneToken;
        this.idpType = idpType;
        this.subdomain = subdomain;
        this.contextAction = contextAction;
        this.license = license;
        this.licenseFeature = licenseFeature;
        this.user = user;
        this.account = account;
        this.userInfo = userInfo;
        if (saveOrg) {
            this.organization = organization;
        }
        this.updateApplicationContext(session);
    }

    private boolean canRenewWithRememberMe() {
        RememberedApiKey rememberedApiKey;
        block3: {
            try {
                RememberMeOption rememberMeOption = this.sessionService.getRememberMeOption();
                if (RememberMeOption.isExplicitlyEnabled((RememberMeOption)rememberMeOption)) break block3;
                return false;
            }
            catch (Exception e) {
                this.logger.warn("Failed to check if we can renew token via remember me credential", (Throwable)e);
                return false;
            }
        }
        RememberedCredential rememberedCredential = this.sessionService.getRememberedCredential();
        return rememberedCredential instanceof RememberedApiKey && StringUtils.isNotBlank((CharSequence)(rememberedApiKey = (RememberedApiKey)rememberedCredential).getValue());
    }

    public void startScheduleCheckingLicense(Runnable expiredHandler, Runnable renewHandler) {
        if (this.checkingLicenseTask != null) {
            this.checkingLicenseTask.cancel(true);
            this.checkingLicenseTask = null;
        }
        LogUtil.logInfo((String)"Start checking license task");
        this.checkingLicenseTask = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            try {
                if (!this.isValidLicense(this.license)) {
                    this.featureManager.clear();
                    expiredHandler.run();
                } else {
                    boolean isOffline = this.license.isOffline();
                    if (!isOffline && this.license.doesReachRenewTime()) {
                        renewHandler.run();
                    }
                }
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e, (String)ApplicationMessageConstants.LICENSE_ERROR_RENEW);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void startScheduleCheckingToken(Consumer<SessionExpireSchedule> expirationHandler, Runnable renewHandler) {
        if (this.checkingTokenTask != null) {
            this.checkingTokenTask.cancel(true);
            this.checkingTokenTask = null;
        }
        LogUtil.logInfo((String)"Start checking token task");
        this.checkingTokenTask = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            try {
                if (this.katOneToken == null) {
                    return;
                }
                KatOneJwtToken accessToken = KatOneJwtToken.parseToken((String)this.katOneToken.getAccessToken());
                boolean isAccessTokenExpiringSoon = accessToken.isExpiringSoon(5);
                if (!isAccessTokenExpiringSoon) {
                    return;
                }
                String katOneRefreshJwt = this.katOneToken.getRefreshToken();
                boolean canRenewWithRememberMe = this.canRenewWithRememberMe();
                if (StringUtils.isBlank((CharSequence)katOneRefreshJwt) && !canRenewWithRememberMe) {
                    SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW, ApplicationMessageConstants.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW_MESSAGE, Optional.empty());
                    expirationHandler.accept(schedule);
                    return;
                }
                KatOneJwtToken refreshToken = KatOneJwtToken.parseToken((String)katOneRefreshJwt);
                if (refreshToken.isExpired() && !canRenewWithRememberMe) {
                    SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW, ApplicationMessageConstants.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW_MESSAGE, Optional.empty());
                    expirationHandler.accept(schedule);
                    return;
                }
                renewHandler.run();
            }
            catch (Exception exception) {}
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void endScheduleCheckingLicense() {
        LogUtil.logInfo((String)"Start clean up session");
        if (this.checkingLicenseTask != null) {
            this.checkingLicenseTask.cancel(true);
            LogUtil.logInfo((String)"End check license task");
        }
        LogUtil.logInfo((String)"End clean up session");
    }

    public void endScheduleCheckingToken() {
        LogUtil.logInfo((String)"Start clean up token");
        if (this.checkingTokenTask != null) {
            this.checkingTokenTask.cancel(true);
            LogUtil.logInfo((String)"End check token task");
        }
        LogUtil.logInfo((String)"End clean up session");
    }

    public boolean isActivated() {
        return this.isValidLicense(this.license);
    }

    public Date getExpirationOnline(String licenseFeature) throws SessionException {
        Session session = this.getSession();
        Organization organization = session.getOrganization();
        String feature = Objects.nonNull(licenseFeature) ? licenseFeature : session.getLicenseFeature();
        try {
            return this.adminService.getExpirationOnline(session.getAdminToken(), organization.getId(), feature);
        }
        catch (MalformedContentException | NetworkErrorException | URISyntaxException e) {
            throw new SessionException(e);
        }
    }

    public boolean shouldShowBrowserLoginAvailableDialog() {
        String testOpsServerUrl = this.discoveryManager.getServerUrl(ServerType.TESTOPS);
        boolean isOnPremServer = false;
        try {
            URI testOpsUri = new URI(testOpsServerUrl);
            String testOpsHost = testOpsUri.getHost();
            isOnPremServer = !testOpsHost.endsWith(".katalon.com") && !testOpsHost.endsWith(".katalon.io");
        }
        catch (Exception exception) {
            isOnPremServer = false;
        }
        boolean credentialLogin = LoginMethod.CREDENTIAL.equals((Object)ApplicationInfo.getLoginMethod());
        return credentialLogin && this.discoveryManager.isDiscovered() && this.sessionService.shouldShowBrowserLoginAvailableDialog() && isOnPremServer;
    }

    public void toggleShowBrowserLoginAvailableDialog(boolean shouldDisplay) {
        this.sessionService.setShouldShowBrowserLoginAvailableDialog(shouldDisplay);
    }

    private boolean isValidLicense(License license) {
        if (license == null) {
            return false;
        }
        boolean isValidMachineId = this.isValidLicenseMachineId(license);
        Date currentDate = new Date();
        Long licenseExpirationDate = license.getExpirationDate();
        Instant instant = Instant.ofEpochSecond(licenseExpirationDate);
        boolean isLicenseExpired = currentDate.after(Date.from(instant));
        if (isValidMachineId && !isLicenseExpired) {
            RunningMode runMode = ApplicationRunningMode.get();
            if (runMode == RunningMode.CONSOLE && this.featureManager.canUse(ProductFeature.CLI)) {
                return true;
            }
            if (runMode == RunningMode.GUI && this.featureManager.canUse(ProductFeature.GUI)) {
                return true;
            }
        } else {
            if (!isValidMachineId) {
                this.logger.error("MachineId invalid!");
            }
            if (isLicenseExpired) {
                this.logger.error("License expired!");
            }
        }
        return false;
    }

    private boolean isValidLicenseMachineId(License license) {
        if (license == null) {
            return false;
        }
        String machineId = license.getMachineId();
        if (machineId == null) {
            return false;
        }
        if ("katalon-ami".contains(machineId)) {
            return true;
        }
        if ("katalon-special-license".equals(machineId)) {
            return true;
        }
        return machineId.endsWith(MachineUtil.getMachineId());
    }

    private void overrideEndpoints(UserConfig config) {
        if (this.discoveryManager.isDiscovered()) {
            return;
        }
        this.discoveryManager.setServerUrl(ServerType.AUTHENTICATION, config.getKeyCloakUrl());
        this.discoveryManager.setServerUrl(ServerType.ADMIN, config.getServerUrl());
        this.discoveryManager.setServerUrl(ServerType.TESTOPS, config.getIoServerUrl());
        this.discoveryManager.setServerUrl(ServerType.PLUGIN_STORE, config.getStoreUrl());
        this.discoveryManager.setServerUrl(ServerType.PLATFORM, config.getE2eServerUrl());
    }

    private AuthenticationToken parseKatOneToken(AuthenticationToken adminToken) {
        if (adminToken == null) {
            return null;
        }
        AdminJwtToken jwtToken = AdminJwtToken.parseToken((String)adminToken.getAccessToken());
        if (jwtToken == null) {
            return adminToken;
        }
        String accessToken = jwtToken.getKatOneJwt();
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return adminToken;
        }
        return new AuthenticationToken(jwtToken.getKatOneJwt(), null);
    }

    private void updateApplicationContext(Session session) {
        ApplicationContext context = ApplicationContext.getInstance();
        User user = session.getUser();
        Organization organization = session.getOrganization();
        context.setUserId(user == null ? null : user.getEmail());
        context.setUserFirstName(user == null ? null : user.getFirstName());
        context.setOrganization(organization);
        if (user != null && user.getTrialExpirationDate() != null) {
            context.setExpirationTrial(Date.from(user.getTrialExpirationDate().toInstant()));
        } else {
            context.setExpirationTrial(null);
        }
    }

    public void resetSession() {
        this.sessionService.reset();
    }

    public SessionExpireSchedule.Reason getLastExpireReason() {
        return this.lastExpireReason;
    }

    public void setLastExpireReason(SessionExpireSchedule.Reason expireReason) {
        this.lastExpireReason = expireReason;
    }

    public void clearLastExpireReason() {
        this.lastExpireReason = null;
    }

    public LicenseType getLicenseType() {
        if (Objects.isNull(this.license)) {
            return null;
        }
        return this.license.getLicenseType();
    }

    public RememberedCredential getRememberedCredential() {
        if (!RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption())) {
            return null;
        }
        try {
            return this.sessionService.getRememberedCredential();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearRememberedCredential() {
        try {
            this.sessionService.clearRememberedCredential();
        }
        catch (Exception exception) {}
    }

    private static class TokenPair {
        final AuthenticationToken adminToken;
        final AuthenticationToken katOneToken;

        TokenPair(AuthenticationToken adminToken, AuthenticationToken katOneToken) {
            this.adminToken = adminToken;
            this.katOneToken = katOneToken;
        }
    }
}

