/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.factory;

import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CustomKeywordPluginFactory {
    public static final String DEV_PLUGIN_ID = "devPlugin";
    private static CustomKeywordPluginFactory instance;
    private Map<String, CustomKeywordPlugin> customKeywordPluginCollection = new HashMap<String, CustomKeywordPlugin>();
    private CustomKeywordPlugin devPlugin;

    public static CustomKeywordPluginFactory getInstance() {
        if (instance == null) {
            instance = new CustomKeywordPluginFactory();
        }
        return instance;
    }

    public void addDevPluginFile(File file) {
        this.devPlugin = new CustomKeywordPlugin();
        this.devPlugin.setId(DEV_PLUGIN_ID);
        this.devPlugin.setPluginFile(file);
    }

    public void addPluginFile(File file, CustomKeywordPlugin plugin) {
        this.customKeywordPluginCollection.put(file.getAbsolutePath(), plugin);
    }

    public void removePluginFile(File file, CustomKeywordPlugin plugin) {
        this.customKeywordPluginCollection.remove(file.getAbsolutePath());
    }

    public CustomKeywordPlugin getByPath(String path) {
        return this.customKeywordPluginCollection.get(path);
    }

    public List<CustomKeywordPlugin> getPlugins() {
        ArrayList<CustomKeywordPlugin> plugins = new ArrayList<CustomKeywordPlugin>(this.customKeywordPluginCollection.entrySet().stream().filter(e -> ((CustomKeywordPlugin)e.getValue()).getPluginFile() != null).map(plugin -> (CustomKeywordPlugin)plugin.getValue()).collect(Collectors.toList()));
        if (this.devPlugin != null) {
            plugins.add(this.devPlugin);
        }
        return plugins;
    }

    public List<File> getStoredPluginFiles() {
        ArrayList<File> pluginFiles = new ArrayList<File>(this.customKeywordPluginCollection.entrySet().stream().filter(e -> ((CustomKeywordPlugin)e.getValue()).getPluginFile() != null).map(plugin -> ((CustomKeywordPlugin)plugin.getValue()).getPluginFile()).collect(Collectors.toList()));
        return pluginFiles;
    }

    public List<File> getAllPluginFiles() {
        ArrayList<File> pluginFiles = new ArrayList<File>();
        pluginFiles.addAll(this.getStoredPluginFiles());
        if (this.devPlugin != null) {
            pluginFiles.add(this.devPlugin.getPluginFile());
        }
        return pluginFiles;
    }

    public CustomKeywordPlugin getDevPlugin() {
        return this.devPlugin;
    }

    public void clearPluginInStore() {
        CustomKeywordPlugin devPlugin = this.customKeywordPluginCollection.get(DEV_PLUGIN_ID);
        this.customKeywordPluginCollection.clear();
        if (devPlugin != null) {
            this.customKeywordPluginCollection.put(DEV_PLUGIN_ID, devPlugin);
        }
    }

    public void clearDevPlugin() {
        this.devPlugin = null;
    }
}

