/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.debug.JDIBinding;
import org.codehaus.groovy.eclipse.debug.JDIScriptLoader;
import org.codehaus.groovy.eclipse.debug.JDITargetDelegate;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class EvaluationEngine
implements IAstEvaluationEngine {
    private final IJavaDebugTarget debugTarget;
    private final IJavaProject javaProject;

    public EvaluationEngine(IJavaProject javaProject, IJavaDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        this.javaProject = javaProject;
    }

    public IJavaDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void dispose() {
    }

    public void evaluate(String snippet, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.evaluateExpression(this.getCompiledExpression(snippet, frame), frame, listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluate(String snippet, IJavaObject object, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.evaluateExpression(this.getCompiledExpression(snippet, object), object, thread, listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluateExpression(ICompiledExpression expression, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.evaluateExpression(expression, frame, null, (IJavaThread)frame.getThread(), listener, evaluationDetail, hitBreakpoints);
    }

    public void evaluateExpression(ICompiledExpression expression, IJavaObject object, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.evaluateExpression(expression, null, object, thread, listener, evaluationDetail, hitBreakpoints);
    }

    private void evaluateExpression(ICompiledExpression expression, IJavaStackFrame stackFrame, IJavaObject thisObject, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        if (thread.isPerformingEvaluation() && evaluationDetail == 64) {
            listener.evaluationComplete(this.withError("Cannot perform nested evaluations.", thread, expression.getSnippet()));
        } else {
            thread.queueRunnable(() -> {
                try {
                    class Eval
                    implements IEvaluationRunnable {
                        private final /* synthetic */ IJavaStackFrame val$stackFrame;
                        private final /* synthetic */ IJavaObject val$thisObject;
                        private final /* synthetic */ ICompiledExpression val$expression;
                        private final /* synthetic */ IEvaluationListener val$listener;

                        Eval(IJavaStackFrame iJavaStackFrame, IJavaObject iJavaObject, ICompiledExpression iCompiledExpression, IEvaluationListener iEvaluationListener) {
                            this.val$stackFrame = iJavaStackFrame;
                            this.val$thisObject = iJavaObject;
                            this.val$expression = iCompiledExpression;
                            this.val$listener = iEvaluationListener;
                        }

                        public void run(IJavaThread javaThread, IProgressMonitor progressMonitor) throws DebugException {
                            IJavaValue result;
                            JDITargetDelegate delegate = new JDITargetDelegate(EvaluationEngine.this.debugTarget, javaThread);
                            JDIBinding groovyBinding = new JDIBinding(delegate, this.val$stackFrame, this.val$thisObject);
                            String groovyScript = this.val$expression.toString();
                            try {
                                try {
                                    Throwable throwable = null;
                                    Object var8_9 = null;
                                    try (JDIScriptLoader loader = this.createScriptLoader();){
                                        Script script = InvokerHelper.newScript((Class)loader.parseClass(groovyScript), (Binding)groovyBinding);
                                        script.setMetaClass(groovyBinding.getMetaClass());
                                        delegate.initialize(loader);
                                        Object proxy = script.run();
                                        result = delegate.toJDIValue(proxy);
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Throwable t) {
                                    if (t instanceof DebugException) {
                                        throw (DebugException)t;
                                    }
                                    if (t.getCause() instanceof DebugException) {
                                        throw (DebugException)t.getCause();
                                    }
                                    throw new DebugException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", null, t));
                                }
                            }
                            finally {
                                delegate.cleanup();
                            }
                            this.val$listener.evaluationComplete(EvaluationEngine.this.withValue(result, javaThread, this.val$expression.getSnippet()));
                        }

                        private JDIScriptLoader createScriptLoader() {
                            Bundle bundle = GroovyPlugin.getDefault().getBundle();
                            ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                            return new JDIScriptLoader(GroovyLanguageSupport.newGroovyClassLoader((IJavaProject)EvaluationEngine.this.javaProject, (ClassLoader)loader).getParent());
                        }
                    }
                    thread.runEvaluation((IEvaluationRunnable)new Eval(stackFrame, thisObject, expression, listener), null, evaluationDetail, hitBreakpoints);
                }
                catch (DebugException e) {
                    listener.evaluationComplete(this.withError(e, thread, expression.getSnippet()));
                }
            });
        }
    }

    public ICompiledExpression getCompiledExpression(String snippet, IJavaObject object) throws DebugException {
        return this.getCompiledExpression(snippet, (IJavaReferenceType)object.getJavaType());
    }

    public ICompiledExpression getCompiledExpression(String snippet, IJavaStackFrame frame) throws DebugException {
        StringBuilder header;
        block9: {
            ICompilationUnit compilationUnit;
            Object sourceElement;
            IJavaElement element;
            header = new StringBuilder();
            String typeName = frame.getReferenceType().getName();
            int i = typeName.lastIndexOf(46);
            if (i != -1) {
                String packageName = typeName.substring(0, i);
                header.append("package ").append(packageName);
                header.append(";\n");
            }
            if ((element = (IJavaElement)Adapters.adapt((Object)(sourceElement = this.getDebugTarget().getLaunch().getSourceLocator().getSourceElement((IStackFrame)frame)), IJavaElement.class)) == null || (compilationUnit = (ICompilationUnit)element.getAncestor(5)) == null) break block9;
            try {
                IImportDeclaration[] iImportDeclarationArray = compilationUnit.getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        String label;
                        IImportDeclaration importDeclaration;
                        block10: {
                            importDeclaration = iImportDeclarationArray[n2];
                            label = importDeclaration.getElementName();
                            if (importDeclaration.isOnDemand()) break block10;
                            int x = label.lastIndexOf(32);
                            if (x == -1) {
                                x = label.lastIndexOf(46);
                            }
                            if (!snippet.contains(x == -1 ? label : label.substring(x + 1))) break block11;
                        }
                        header.append("import ");
                        if (Flags.isStatic((int)importDeclaration.getFlags())) {
                            header.append("static ");
                        }
                        header.append(label);
                        header.append(";\n");
                    }
                    ++n2;
                }
                header.append("\n");
            }
            catch (JavaModelException e) {
                throw new DebugException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", null, (Throwable)e));
            }
        }
        return this.getCompiledExpression(snippet, frame.getReferenceType(), Collections.singletonMap("header", header.toString()));
    }

    public ICompiledExpression getCompiledExpression(String snippet, IJavaReferenceType type) throws DebugException {
        StringBuilder header = new StringBuilder();
        String typeName = type.getName();
        if (!typeName.endsWith("]")) {
            String packageName;
            int i = typeName.lastIndexOf(46);
            if (i != -1 && !"java.lang".equals(packageName = typeName.substring(0, i))) {
                header.append("import ").append(packageName);
                header.append(".*;\n");
            }
            header.append("import static ").append(typeName).append(".*;\n");
        }
        return this.getCompiledExpression(snippet, type, Collections.singletonMap("header", header.toString()));
    }

    public ICompiledExpression getCompiledExpression(final String snippet, IJavaReferenceType type, final Map<String, String> compileOptions) throws DebugException {
        return new ICompiledExpression(){

            public String toString() {
                return compileOptions.getOrDefault("header", "") + snippet;
            }

            public String getSnippet() {
                return snippet;
            }

            public boolean hasErrors() {
                return false;
            }

            public Message[] getErrors() {
                return null;
            }

            public String[] getErrorMessages() {
                return null;
            }
        };
    }

    private IEvaluationResult withError(DebugException exception, IJavaThread thread, String source) {
        EvaluationResult result = new EvaluationResult();
        result.errorMessages = new String[0];
        result.exception = exception;
        result.snippet = source;
        result.thread = thread;
        result.errorMessages = JavaInspectExpression.getErrorMessages((IEvaluationResult)result);
        result.errorMessages[0] = result.errorMessages[0].replaceFirst("^startup failed:\\s+Script_[0-9a-f]+\\.groovy:\\s\\d+:\\s*", "");
        return result;
    }

    private IEvaluationResult withError(CharSequence message, IJavaThread thread, String source) {
        String[] messageAsArray = new String[]{message.toString()};
        EvaluationResult result = new EvaluationResult();
        result.errorMessages = messageAsArray;
        result.snippet = source;
        result.thread = thread;
        return result;
    }

    private IEvaluationResult withValue(IJavaValue value, IJavaThread thread, String source) {
        EvaluationResult result = new EvaluationResult();
        result.snippet = source;
        result.thread = thread;
        result.value = value;
        return result;
    }

    private class EvaluationResult
    implements IEvaluationResult {
        DebugException exception;
        String[] errorMessages;
        boolean terminated;
        IJavaThread thread;
        IJavaValue value;
        String snippet;

        private EvaluationResult() {
        }

        public IEvaluationEngine getEvaluationEngine() {
            return EvaluationEngine.this;
        }

        public DebugException getException() {
            return this.exception;
        }

        public String[] getErrorMessages() {
            return this.errorMessages;
        }

        public Message[] getErrors() {
            return (Message[])Arrays.stream(this.getErrorMessages()).map(it -> new Message(it, -1)).toArray(Message[]::new);
        }

        public boolean hasErrors() {
            return DefaultGroovyMethods.asBoolean((Object[])this.getErrorMessages());
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public IJavaThread getThread() {
            return this.thread;
        }

        public IJavaValue getValue() {
            return this.value;
        }

        public String getSnippet() {
            return this.snippet;
        }
    }
}

