/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.preferences.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class GroovyPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String GROOVY_MULTILINE_STRINGS = "__groovy_multiline_string";
    public static final String[] LEGAL_CONTENT_TYPES = new String[]{"__java_character", "__java_string", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__groovy_multiline_string"};

    public GroovyPartitionScanner() {
        List<IRule> rules = GroovyPartitionScanner.createRules(false);
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    public static List<IRule> createRules(boolean withColor) {
        ArrayList<IRule> rules = new ArrayList<IRule>(8);
        Token javadocComment = new Token((Object)"__java_javadoc");
        Token multilnComment = new Token((Object)"__java_multiline_comment");
        Token endlineComment = new Token((Object)"__java_singleline_comment");
        rules.add((IRule)new WordPredicateRule((IToken)multilnComment));
        rules.add((IRule)new MultiLineRule("/**", "*/", (IToken)javadocComment, '\u0000', true));
        rules.add((IRule)new MultiLineRule("/*", "*/", (IToken)multilnComment, '\u0000', true));
        rules.add((IRule)new EndOfLineRule("//", (IToken)endlineComment));
        String textAttr = null;
        if (withColor) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)PreferenceConstants.getPreferenceStore(), (String)"java_string");
            textAttr = new TextAttribute(new Color(null, rgb), null, 2);
        }
        Token groovyString = new Token((Object)(textAttr != null ? textAttr : GROOVY_MULTILINE_STRINGS));
        Token javaString = new Token((Object)(textAttr != null ? textAttr : "__java_string"));
        rules.add((IRule)new MultiLineRule("'''", "'''", (IToken)groovyString));
        rules.add((IRule)new MultiLineRule("\"\"\"", "\"\"\"", (IToken)groovyString));
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)javaString, '\\'));
        rules.add((IRule)new SingleLineRule("\"", "\"", (IToken)javaString, '\\'));
        return rules;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private final IToken fSuccessToken;

        WordPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

